/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.SLPUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public abstract class AuthenticatedURL {
    int lifetime;
    protected AuthenticationBlock[] authBlocks = new AuthenticationBlock[0];

    protected final void sign(List spiList) throws ServiceLocationException {
        this.authBlocks = new AuthenticationBlock[spiList.size()];
        int k = 0;
        while (k < spiList.size()) {
            int timestamp = SLPUtils.getTimestamp();
            String spi = (String)spiList.get(k);
            byte[] data = this.getAuthData(spi, timestamp += this.lifetime);
            this.authBlocks[k] = new AuthenticationBlock(2, spi, timestamp, data, null);
            ++k;
        }
    }

    protected final boolean verify() throws ServiceLocationException {
        int i = 0;
        while (i < this.authBlocks.length) {
            byte[] data = this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp());
            if (this.authBlocks[i].verify(data)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private byte[] getAuthData(String spi, int timestamp) throws ServiceLocationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            byte[] temp = spi.getBytes();
            dos.writeShort(temp.length);
            dos.write(temp);
            temp = this.toString().getBytes();
            dos.writeShort(temp.length);
            dos.write(temp);
            dos.writeInt(timestamp);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ServiceLocationException(20, ioe.getMessage());
        }
    }

    protected void writeAuthBlock(DataOutputStream out) throws IOException {
        out.write(this.authBlocks.length);
        int i = 0;
        while (i < this.authBlocks.length) {
            this.authBlocks[i].write(out);
            ++i;
        }
    }

    protected final int getAuthBlockLength() {
        int len = 1;
        int i = 0;
        while (i < this.authBlocks.length) {
            len += this.authBlocks[i].getLength();
            ++i;
        }
        return len;
    }

    protected static final AuthenticationBlock[] parseAuthBlock(DataInputStream input) throws ServiceLocationException, IOException {
        return AuthenticationBlock.parse(input);
    }
}

