/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.msn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.protocol.msn.Contact;
import org.eclipse.ecf.protocol.msn.Group;
import org.eclipse.ecf.protocol.msn.MsnClient;
import org.eclipse.ecf.protocol.msn.events.IContactListListener;
import org.eclipse.ecf.protocol.msn.internal.encode.StringUtils;

public final class ContactList {
    private final Map groups;
    private final ArrayList contacts;
    private final ArrayList listeners;
    private final MsnClient client;

    ContactList(MsnClient client) {
        this.client = client;
        this.groups = new HashMap();
        this.contacts = new ArrayList();
        this.listeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContactAdded(Contact contact) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListListener)this.listeners.get(i)).contactAdded(contact);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireContactRemoved(String guid) {
        Contact contact = this.findContactByGuid(guid);
        if (!contact.getGroups().isEmpty()) {
            contact.remove();
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListListener)this.listeners.get(i)).contactRemoved(contact);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireContactAddedUser(String email) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListListener)this.listeners.get(i)).contactAddedUser(email);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireContactRemovedUser(String email) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListListener)this.listeners.get(i)).contactRemovedUser(email);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGroupAdded(Group group) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListListener)this.listeners.get(i)).groupAdded(group);
                ++i;
            }
        }
    }

    void internalAddContact(String email, String contactName) {
        this.addContact(email, contactName, null);
    }

    void addContact(String email, String contactName, String guid) {
        Contact contact;
        if (guid == null) {
            contact = new Contact(email, contactName);
            this.contacts.add(contact);
        } else {
            contact = this.findContactByGuid(guid);
            if (contact == null) {
                contact = new Contact(email, contactName, guid);
            }
            this.contacts.add(contact);
        }
        this.fireContactAdded(contact);
    }

    void addContact(String contactName, String email, String guid, String groupGUID) {
        Contact contact = new Contact(email, contactName, guid);
        this.contacts.add(contact);
        String[] split = StringUtils.split(groupGUID, ',');
        int i = 0;
        while (i < split.length) {
            ((Group)this.groups.get(split[i])).add(contact);
            ++i;
        }
        this.fireContactAdded(contact);
    }

    void addGroup(String guid, Group group) {
        this.groups.put(guid, group);
        this.fireGroupAdded(group);
    }

    public void addContact(String email, String userName) throws IOException {
        if (userName == null || userName.equals("")) {
            this.client.add(email, email);
        } else {
            this.client.add(email, userName);
        }
    }

    public void removeContact(Contact contact) throws IOException {
        this.client.remove(contact);
    }

    public void removeGroup(Group group) throws IOException {
        String guid = this.getGuid(group);
        if (guid != null) {
            this.client.remove(guid);
        }
    }

    public Contact getContact(String email) {
        int i = 0;
        while (i < this.contacts.size()) {
            Contact contact = (Contact)this.contacts.get(i);
            if (contact.getEmail().equals(email)) {
                return contact;
            }
            ++i;
        }
        return null;
    }

    private Contact findContactByGuid(String guid) {
        int i = 0;
        while (i < this.contacts.size()) {
            Contact contact = (Contact)this.contacts.get(i);
            if (guid.equals(contact.getGuid())) {
                return contact;
            }
            ++i;
        }
        return null;
    }

    public Collection getContacts() {
        return Collections.unmodifiableCollection(this.contacts);
    }

    public Collection getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    String getGuid(Group group) {
        Iterator it = this.groups.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != group) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContactListListener(IContactListListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactsListListener(IContactListListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(listener);
            }
        }
    }

    public String toString() {
        return this.contacts.toString();
    }
}

