/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservices.ui;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ITopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.EndpointDiscoveryView;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.RemoteServiceAdminView;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

public class DiscoveryComponent
implements EndpointEventListener,
RemoteServiceAdminListener {
    private static String ENDPOINT_LISTENER_SCOPE = System.getProperty("org.eclipse.ecf.remoteservices.ui.endpointListenerScope", "(ecf.endpoint.id.ns=*)");
    private static DiscoveryComponent instance;
    private BundleContext context;
    private RemoteServiceAdmin rsa;
    private ITopologyManager tm;
    private EndpointDiscoveryView discoveryView;
    private RemoteServiceAdminView rsaView;
    private IEndpointDescriptionLocator edLocator;
    private ServiceRegistration<EndpointEventListener> eelRegistration;
    private ServiceRegistration<RemoteServiceAdminListener> rsaadminRegistration;
    private List<EndpointEvent> history;

    void bindRemoteServiceAdmin(org.osgi.service.remoteserviceadmin.RemoteServiceAdmin r) {
        this.rsa = (RemoteServiceAdmin)r;
    }

    void unbindRemoteServiceAdmin(org.osgi.service.remoteserviceadmin.RemoteServiceAdmin rsa) {
        this.rsa = null;
    }

    void bindTopologyManager(ITopologyManager tm) {
        this.tm = tm;
    }

    void unbindTopologyManager(ITopologyManager tm) {
        this.tm = null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    void bindEndpointDescriptionLocator(IEndpointDescriptionLocator locator) {
        this.edLocator = locator;
    }

    void unbindEndpointDescriptionLocator(IEndpointDescriptionLocator locator) {
        this.edLocator = null;
    }

    public IEndpointDescriptionLocator getEndpointDescriptionLocator() {
        return this.edLocator;
    }

    public static DiscoveryComponent getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(EndpointDiscoveryView edv) {
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            this.discoveryView = edv;
        }
    }

    public RemoteServiceAdmin getRSA() {
        return this.rsa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(BundleContext context) throws Exception {
        this.history = new ArrayList<EndpointEvent>();
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            instance = this;
            this.context = context;
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("endpoint.listener.scope", ENDPOINT_LISTENER_SCOPE);
            this.eelRegistration = context.registerService(EndpointEventListener.class, (Object)this, props);
            this.rsaadminRegistration = context.registerService(RemoteServiceAdminListener.class, (Object)this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            if (this.eelRegistration != null) {
                this.eelRegistration.unregister();
                this.eelRegistration = null;
            }
            if (this.rsaadminRegistration != null) {
                this.rsaadminRegistration.unregister();
                this.rsaadminRegistration = null;
            }
            instance = null;
            this.discoveryView = null;
            this.rsa = null;
            this.context = null;
            if (this.history != null) {
                this.history.clear();
                this.history = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EndpointEvent> getHistory() {
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            return this.history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointChanged(EndpointEvent event, String filter) {
        EndpointDiscoveryView view = null;
        List<EndpointEvent> h = null;
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            h = this.history;
            view = this.discoveryView;
        }
        if (view != null) {
            view.handleEndpointChanged(event);
        } else if (h != null) {
            h.add(event);
        }
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        if (this.rsaView != null) {
            this.rsaView.handleRSAEvent(event);
        }
        if (this.discoveryView != null) {
            this.discoveryView.handleRSAEent(event);
        }
    }

    public void setRSAView(RemoteServiceAdminView rsaView) {
        this.rsaView = rsaView;
    }
}

