/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.roster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.roster.IMultiResourceRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterResource;
import org.eclipse.ecf.presence.roster.RosterGroup;
import org.eclipse.ecf.presence.roster.RosterItem;
import org.eclipse.ecf.presence.roster.RosterResource;

public class RosterEntry
extends RosterItem
implements IRosterEntry,
IMultiResourceRosterEntry {
    protected IUser user;
    protected IPresence presence;
    protected List groups;
    protected List resources;

    public RosterEntry(IRosterItem parent, IUser user, IPresence presenceState) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)user);
        this.parent = parent;
        this.user = user;
        this.presence = presenceState;
        this.groups = Collections.synchronizedList(new ArrayList());
        if (parent instanceof RosterGroup) {
            this.groups.add(parent);
            ((RosterGroup)parent).add(this);
        }
        this.resources = new ArrayList();
    }

    public void setPresence(IPresence newPresence) {
        this.presence = newPresence;
    }

    public String getName() {
        return this.user.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof RosterEntry) {
            RosterEntry re = (RosterEntry)obj;
            return re.getUser().getID().equals((Object)this.getUser().getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getUser().getID().hashCode();
    }

    public boolean add(IRosterGroup group) {
        if (group == null) {
            return false;
        }
        return this.groups.add(group);
    }

    public boolean remove(IRosterGroup group) {
        if (group == null) {
            return false;
        }
        return this.groups.remove(group);
    }

    public IUser getUser() {
        return this.user;
    }

    public Collection getGroups() {
        return this.groups;
    }

    public IPresence getPresence() {
        return this.presence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb;
        StringBuffer stringBuffer = sb = new StringBuffer("RosterEntry[");
        synchronized (stringBuffer) {
            sb.append("userid=" + this.getUser().getID().getName()).append(";");
            sb.append("name=").append(this.getName()).append(';');
            sb.append("presence=").append(this.presence).append(';');
            sb.append("groups=");
            if (!this.groups.isEmpty()) {
                int i = 0;
                while (i < this.groups.size()) {
                    sb.append(((IRosterGroup)this.groups.get(i)).getName());
                    if (i < this.groups.size() - 1) {
                        sb.append(',');
                    }
                    ++i;
                }
            }
            sb.append(']');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateResource(String resourceName, IPresence p) {
        if (resourceName == null) {
            return false;
        }
        List list = this.resources;
        synchronized (list) {
            RosterResource r;
            Iterator i = this.resources.iterator();
            do {
                if (i.hasNext()) continue;
                this.resources.add(new RosterResource(this, resourceName, p));
                return false;
            } while (!(r = (RosterResource)i.next()).getName().equals(resourceName));
            r.setPresence(p);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterResource removeResource(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        RosterResource result = null;
        List list = this.resources;
        synchronized (list) {
            Iterator i = this.resources.iterator();
            while (i.hasNext()) {
                RosterResource r = (RosterResource)i.next();
                if (!r.getName().equals(resourceName)) continue;
                i.remove();
                result = r;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRosterResource[] getResources() {
        ArrayList result = null;
        List list = this.resources;
        synchronized (list) {
            result = new ArrayList(this.resources);
        }
        return result.toArray(new IRosterResource[result.size()]);
    }
}

