/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.csv.importer.utils;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionDate;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.csv.importer.mapping.DataType;
import org.eclipse.rmf.reqif10.csv.importer.mapping.MappingItem;
import org.eclipse.rmf.reqif10.csv.importer.mapping.MappingLibrary;
import org.eclipse.rmf.reqif10.csv.importer.utils.Utils;

public class Importer {
    private static final ReqIF10Factory FACTORY = ReqIF10Factory.eINSTANCE;
    private EditingDomain editingDomain;
    private String path;
    private MappingLibrary library;
    private ReqIF reqIf;
    private char separator;
    private boolean header;
    private CompoundCommand compoundCommand;
    private Map<String, AttributeDefinition> attributeDefinitionMap;

    public Importer(EditingDomain editingDomain, String path, MappingLibrary library, ReqIF reqIf, char separator, boolean header) {
        this.editingDomain = editingDomain;
        this.path = path;
        this.library = library;
        this.reqIf = reqIf;
        this.separator = separator;
        this.header = header;
        this.attributeDefinitionMap = new HashMap<String, AttributeDefinition>();
    }

    public static void importReq(EditingDomain editingDomain, IFile file, String path, MappingLibrary library, char separator, boolean header) throws IOException {
        boolean needDispose = false;
        if (editingDomain == null) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
            editingDomain = Utils.createReqIFEditingDomain();
            editingDomain.getResourceSet().getResource(uri, true);
            needDispose = true;
        }
        ReqIF reqIf = (ReqIF)((Resource)editingDomain.getResourceSet().getResources().get(0)).getContents().get(0);
        Importer importer = new Importer(editingDomain, path, library, reqIf, separator, header);
        importer.doImportReq();
        if (needDispose) {
            ComposedAdapterFactory adapterFactory = (ComposedAdapterFactory)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
            adapterFactory.dispose();
            EList resources = editingDomain.getResourceSet().getResources();
            HashMap<String, String> saveOptions = new HashMap<String, String>();
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            for (Resource resource : resources) {
                resource.save(saveOptions);
                resource.unload();
                resource.getContents().clear();
            }
        }
    }

    public void doImportReq() throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(this.path), this.separator);
        Map<Short, String> map = null;
        if (this.header) {
            String[] headerNames = reader.readNext();
            map = this.buildMappingMap(this.library, Arrays.asList(headerNames));
        } else {
            map = this.buildMappingMap(this.library);
        }
        this.compoundCommand = new CompoundCommand();
        this.importReq(reader, map, (List<MappingItem>)this.library.getItems());
        this.editingDomain.getCommandStack().execute((Command)this.compoundCommand);
        this.compoundCommand = null;
        this.attributeDefinitionMap.clear();
    }

    protected void importReq(CSVReader reader, Map<Short, String> map, List<MappingItem> mappingItems) throws IOException {
        String[] nextLine;
        Specification specification = (Specification)this.reqIf.getCoreContent().getSpecifications().get(0);
        SpecObjectType specObjectType = this.getSpecObjectType(mappingItems, this.getSpecTypeName());
        System.out.println();
        while ((nextLine = reader.readNext()) != null) {
            Command command = CreateChildCommand.create((EditingDomain)this.editingDomain, (Object)specification, (Object)new CommandParameter((Object)specification, (Object)ReqIF10Package.Literals.SPECIFICATION__CHILDREN, (Object)specObjectType), Collections.singleton(specification));
            this.compoundCommand.appendAndExecute(command);
            Collection result = command.getResult();
            for (Object object : result) {
                if (!(object instanceof SpecHierarchy)) continue;
                SpecObject specObject = ((SpecHierarchy)object).getObject();
                this.createAttributeValues(specObject);
                int i = 0;
                while (i < nextLine.length) {
                    String attributeName = map.get((short)i);
                    String attributeStringValue = nextLine[i];
                    if (attributeName != null) {
                        EAttribute attribute = this.getSpecObjectAttribute(attributeName);
                        if (attribute != null) {
                            specObject.eSet((EStructuralFeature)attribute, EcoreUtil.createFromString((EDataType)attribute.getEAttributeType(), (String)attributeStringValue));
                        } else {
                            AttributeDefinition attributeDefinition = this.attributeDefinitionMap.get(attributeName);
                            AttributeValue attributeValue = ReqIF10Util.getAttributeValue((SpecElementWithAttributes)specObject, (AttributeDefinition)attributeDefinition);
                            if (attributeValue != null) {
                                if (attributeValue instanceof AttributeValueEnumeration) {
                                    EnumValue enumValue = this.getEnumValue((AttributeDefinitionEnumeration)attributeDefinition, attributeStringValue);
                                    ReqIF10Util.setTheValue((AttributeValue)attributeValue, Collections.singleton(enumValue));
                                } else if (!(attributeValue instanceof AttributeValueXHTML)) {
                                    EAttribute eAttribute = (EAttribute)ReqIF10Util.getTheValueFeature((AttributeValue)attributeValue);
                                    ReqIF10Util.setTheValue((AttributeValue)attributeValue, (Object)EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)attributeStringValue));
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        reader.close();
    }

    private void createAttributeValues(SpecObject specObject) {
        EList attributeDefinitions = specObject.getType().getSpecAttributes();
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            specObject.getValues().add((Object)ReqIF10Util.createAttributeValue((AttributeDefinition)attributeDefinition));
        }
    }

    private EnumValue getEnumValue(AttributeDefinitionEnumeration attributeDefinition, String attributeStringValue) {
        EnumValue enumValue2;
        EList values = attributeDefinition.getType().getSpecifiedValues();
        for (EnumValue enumValue2 : values) {
            if (enumValue2.getLongName() == null || !enumValue2.getLongName().equals(attributeStringValue)) continue;
            return enumValue2;
        }
        enumValue2 = FACTORY.createEnumValue();
        enumValue2.setLongName(attributeStringValue);
        values.add((Object)enumValue2);
        return enumValue2;
    }

    protected SpecObjectType getSpecObjectType(List<MappingItem> mappingItems, String specTypeName) {
        EList specTypes = this.reqIf.getCoreContent().getSpecTypes();
        for (SpecType specType : specTypes) {
            SpecObjectType specObjectType;
            if (!(specType instanceof SpecObjectType) || !this.containsAttributeDefinitions(specObjectType = (SpecObjectType)specType, mappingItems, specTypeName)) continue;
            this.fillAttributeDefinitionMap(specObjectType);
            return specObjectType;
        }
        return this.createSpecObjectType(mappingItems, specTypeName);
    }

    private void fillAttributeDefinitionMap(SpecObjectType specObjectType) {
        EList attributeDefinitions = specObjectType.getSpecAttributes();
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            this.attributeDefinitionMap.put(attributeDefinition.getLongName(), attributeDefinition);
        }
    }

    private boolean containsAttributeDefinitions(SpecObjectType specObjectType, List<MappingItem> mappingItems, String specTypeName) {
        if (specObjectType.getLongName() == null || !specObjectType.getLongName().equals(specTypeName)) {
            return false;
        }
        if (mappingItems.size() != specObjectType.getSpecAttributes().size()) {
            return false;
        }
        for (MappingItem mappingItem : mappingItems) {
            if (this.containsAttributeDefinition(specObjectType, mappingItem)) continue;
            return false;
        }
        return true;
    }

    private boolean containsAttributeDefinition(SpecObjectType specObjectType, MappingItem item) {
        boolean found = false;
        EList attributeDefinitions = specObjectType.getSpecAttributes();
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            if (attributeDefinition.getLongName() == null || !attributeDefinition.getLongName().equals(item.getAttributeName())) continue;
            switch (item.getDataType()) {
                case BOOLEAN: {
                    found = attributeDefinition instanceof AttributeDefinitionBoolean;
                    break;
                }
                case INTEGER: {
                    found = attributeDefinition instanceof AttributeDefinitionInteger;
                    break;
                }
                case REAL: {
                    found = attributeDefinition instanceof AttributeDefinitionReal;
                    break;
                }
                case DATE: {
                    found = attributeDefinition instanceof AttributeDefinitionDate;
                    break;
                }
                case XHTML: {
                    found = attributeDefinition instanceof AttributeDefinitionXHTML;
                    break;
                }
                case ENUMERATION: {
                    found = attributeDefinition instanceof AttributeDefinitionEnumeration;
                    break;
                }
                default: {
                    found = attributeDefinition instanceof AttributeDefinitionString;
                }
            }
            if (found) break;
        }
        return found;
    }

    protected SpecObjectType createSpecObjectType(List<MappingItem> mappingItems, String specTypeName) {
        SpecObjectType specObjectType = FACTORY.createSpecObjectType();
        specObjectType.setLongName(specTypeName);
        for (MappingItem mappingItem : mappingItems) {
            String attributeName = mappingItem.getAttributeName();
            if (this.getSpecObjectAttribute(attributeName) != null) continue;
            DatatypeDefinition datatypeDefinition = this.createDatatypeDefinition(mappingItem.getDataType(), attributeName);
            Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.reqIf.getCoreContent(), (Object)ReqIF10Package.Literals.REQ_IF_CONTENT__DATATYPES, Collections.singleton(datatypeDefinition));
            this.compoundCommand.appendAndExecute(command);
            AttributeDefinition attributeDefinition = this.createAttributeDefinition(datatypeDefinition, attributeName);
            attributeDefinition.setLongName(attributeName);
            specObjectType.getSpecAttributes().add((Object)attributeDefinition);
        }
        Command specTypecommand = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.reqIf.getCoreContent(), (Object)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_TYPES, Collections.singleton(specObjectType));
        this.compoundCommand.appendAndExecute(specTypecommand);
        this.fillAttributeDefinitionMap(specObjectType);
        return specObjectType;
    }

    protected AttributeDefinition createAttributeDefinition(DatatypeDefinition datatypeDefinition, String name) {
        AttributeDefinitionBoolean attributeDefinition = null;
        if (datatypeDefinition instanceof DatatypeDefinitionBoolean) {
            attributeDefinition = FACTORY.createAttributeDefinitionBoolean();
            attributeDefinition.setType((DatatypeDefinitionBoolean)datatypeDefinition);
        } else if (datatypeDefinition instanceof DatatypeDefinitionInteger) {
            attributeDefinition = FACTORY.createAttributeDefinitionInteger();
            ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition);
        } else if (datatypeDefinition instanceof DatatypeDefinitionReal) {
            attributeDefinition = FACTORY.createAttributeDefinitionReal();
            ((AttributeDefinitionReal)attributeDefinition).setType((DatatypeDefinitionReal)datatypeDefinition);
        } else if (datatypeDefinition instanceof DatatypeDefinitionDate) {
            attributeDefinition = FACTORY.createAttributeDefinitionDate();
            ((AttributeDefinitionDate)attributeDefinition).setType((DatatypeDefinitionDate)datatypeDefinition);
        } else if (datatypeDefinition instanceof DatatypeDefinitionXHTML) {
            attributeDefinition = FACTORY.createAttributeDefinitionXHTML();
            ((AttributeDefinitionXHTML)attributeDefinition).setType((DatatypeDefinitionXHTML)datatypeDefinition);
        } else if (datatypeDefinition instanceof DatatypeDefinitionEnumeration) {
            attributeDefinition = FACTORY.createAttributeDefinitionEnumeration();
            ((AttributeDefinitionEnumeration)attributeDefinition).setType((DatatypeDefinitionEnumeration)datatypeDefinition);
        } else {
            attributeDefinition = FACTORY.createAttributeDefinitionString();
            ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition);
        }
        attributeDefinition.setLongName(name);
        return attributeDefinition;
    }

    protected DatatypeDefinition createDatatypeDefinition(DataType dataType, String name) {
        DatatypeDefinitionBoolean dataTypeDefinition = null;
        switch (dataType) {
            case BOOLEAN: {
                dataTypeDefinition = FACTORY.createDatatypeDefinitionBoolean();
                break;
            }
            case INTEGER: {
                dataTypeDefinition = FACTORY.createDatatypeDefinitionInteger();
                break;
            }
            case REAL: {
                dataTypeDefinition = FACTORY.createDatatypeDefinitionReal();
                break;
            }
            case DATE: {
                dataTypeDefinition = FACTORY.createDatatypeDefinitionDate();
                break;
            }
            case XHTML: {
                dataTypeDefinition = FACTORY.createDatatypeDefinitionXHTML();
                break;
            }
            case ENUMERATION: {
                dataTypeDefinition = FACTORY.createDatatypeDefinitionEnumeration();
                break;
            }
            default: {
                dataTypeDefinition = FACTORY.createDatatypeDefinitionString();
            }
        }
        dataTypeDefinition.setLongName(name);
        return dataTypeDefinition;
    }

    protected EAttribute getSpecObjectAttribute(String attributeName) {
        EStructuralFeature feature = ReqIF10Package.Literals.SPEC_OBJECT.getEStructuralFeature(attributeName);
        if (feature instanceof EAttribute) {
            return (EAttribute)feature;
        }
        return null;
    }

    protected Map<Short, String> buildMappingMap(MappingLibrary library) {
        EList<MappingItem> items = library.getItems();
        HashMap<Short, String> map = new HashMap<Short, String>(items.size());
        for (MappingItem columnIndexMappingItem : items) {
            map.put(Short.valueOf(columnIndexMappingItem.getColumnId()), columnIndexMappingItem.getAttributeName());
        }
        return map;
    }

    protected Map<Short, String> buildMappingMap(MappingLibrary library, List<String> columnNames) {
        EList<MappingItem> items = library.getItems();
        HashMap<Short, String> map = new HashMap<Short, String>(items.size());
        for (MappingItem columnNameMappingItem : items) {
            String columnName = columnNameMappingItem.getColumnId();
            short columnIndex = (short)columnNames.indexOf(columnName);
            if (columnIndex == -1) continue;
            map.put(columnIndex, columnNameMappingItem.getAttributeName());
        }
        return map;
    }

    protected String getSpecTypeName() {
        return this.path.substring(this.path.lastIndexOf(File.separator) + 1, this.path.lastIndexOf(46));
    }
}

