/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.log.logentry;

import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.test.assertj.bundle.AbstractBundleAssert;
import org.osgi.test.assertj.bundle.BundleAssert;
import org.osgi.test.assertj.date.Dates;
import org.osgi.test.assertj.servicereference.AbstractServiceReferenceAssert;
import org.osgi.test.assertj.servicereference.ServiceReferenceAssert;

public abstract class AbstractLogEntryAssert<SELF extends AbstractLogEntryAssert<SELF, ACTUAL>, ACTUAL extends LogEntry>
extends AbstractAssert<SELF, ACTUAL> {
    protected AbstractLogEntryAssert(ACTUAL actual, Class<SELF> selfType) {
        super(actual, selfType);
    }

    public SELF hasBundle(Bundle expected) {
        this.isNotNull();
        if (!Objects.equals(((LogEntry)this.actual).getBundle(), expected)) {
            throw this.failureWithActualExpected(((LogEntry)this.actual).getBundle(), expected, "%nExpecting%n <%s>%nto have bundle source:%n <%s>%n but was:%n<%s>", new Object[]{this.actual, expected, ((LogEntry)this.actual).getBundle()});
        }
        return (SELF)((Object)((AbstractLogEntryAssert)this.myself));
    }

    public AbstractBundleAssert<?, ? extends Bundle> hasBundleThat() {
        return (AbstractBundleAssert)((BundleAssert)((AbstractLogEntryAssert)this.isNotNull()).extracting(LogEntry::getBundle, (AssertFactory)BundleAssert.BUNDLE)).as(this.actual + ".bundle", new Object[0]);
    }

    public SELF hasServiceReference(ServiceReference<?> expected) {
        this.isNotNull();
        if (!Objects.equals(((LogEntry)this.actual).getServiceReference(), expected)) {
            throw this.failureWithActualExpected(((LogEntry)this.actual).getServiceReference(), expected, "%nExpecting%n <%s>%nto have service reference:%n <%s>%n but was:%n<%s>", new Object[]{this.actual, expected, ((LogEntry)this.actual).getServiceReference()});
        }
        return (SELF)((Object)((AbstractLogEntryAssert)this.myself));
    }

    public AbstractServiceReferenceAssert<?, ? extends ServiceReference<?>, ?> hasServiceReferenceThat() {
        return (AbstractServiceReferenceAssert)((ServiceReferenceAssert)((AbstractLogEntryAssert)this.isNotNull()).extracting(LogEntry::getServiceReference, (AssertFactory)ServiceReferenceAssert.SERVICE_REFERENCE)).as(this.actual + ".serviceReference", new Object[0]);
    }

    public SELF hasMessage(String expected) {
        this.isNotNull();
        if (!Objects.equals(((LogEntry)this.actual).getMessage(), expected)) {
            throw this.failureWithActualExpected(((LogEntry)this.actual).getMessage(), expected, "%nExpecting%n  <%s>%nto have message:%n  <%s>%n but was:%n  <%s>", new Object[]{this.actual, expected, ((LogEntry)this.actual).getMessage()});
        }
        return (SELF)((Object)((AbstractLogEntryAssert)this.myself));
    }

    public AbstractStringAssert<?> hasMessageThat() {
        return (AbstractStringAssert)((AbstractStringAssert)((AbstractLogEntryAssert)this.isNotNull()).extracting(LogEntry::getMessage, (AssertFactory)InstanceOfAssertFactories.STRING)).as(this.actual + ".message", new Object[0]);
    }

    public SELF hasException(Throwable expected) {
        this.isNotNull();
        if (!Objects.equals(((LogEntry)this.actual).getException(), expected)) {
            throw this.failureWithActualExpected(((LogEntry)this.actual).getException(), expected, "%nExpecting%n  <%s>%nto have exception:%n  <%s>%n but was:%n  <%s>", new Object[]{this.actual, expected, ((LogEntry)this.actual).getException()});
        }
        return (SELF)((Object)((AbstractLogEntryAssert)this.myself));
    }

    public AbstractThrowableAssert<?, ?> hasExceptionThat() {
        return (AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractLogEntryAssert)this.isNotNull()).extracting(LogEntry::getException, (AssertFactory)InstanceOfAssertFactories.THROWABLE)).as(this.actual + ".exception", new Object[0]);
    }

    public AbstractLongAssert<?> hasTimeLongThat() {
        return (AbstractLongAssert)((AbstractLongAssert)((AbstractLogEntryAssert)this.isNotNull()).extracting(LogEntry::getTime, (AssertFactory)InstanceOfAssertFactories.LONG)).as(this.actual + ".time", new Object[0]);
    }

    public AbstractDateAssert<?> hasTimeDateThat() {
        return (AbstractDateAssert)((AbstractDateAssert)((AbstractLogEntryAssert)this.isNotNull()).extracting(LogEntry::getTime, (AssertFactory)Dates.LONG_AS_DATE)).as(this.actual + ".time", new Object[0]);
    }

    public SELF hasLogLevel(LogLevel expected) {
        this.isNotNull();
        if (!Objects.equals(((LogEntry)this.actual).getLogLevel(), expected)) {
            throw this.failureWithActualExpected(((LogEntry)this.actual).getLogLevel(), expected, "%nExpecting%n  <%s>%nto have log level:%n  <%s>%n but was:%n  <%s>", new Object[]{this.actual, expected, ((LogEntry)this.actual).getLogLevel()});
        }
        return (SELF)((Object)((AbstractLogEntryAssert)this.myself));
    }

    public SELF hasLoggerName(String expected) {
        this.isNotNull();
        if (!Objects.equals(((LogEntry)this.actual).getLoggerName(), expected)) {
            throw this.failureWithActualExpected(((LogEntry)this.actual).getLoggerName(), expected, "%nExpecting%n  <%s>%nto have logger name:%n  <%s>%n but was:%n  <%s>", new Object[]{this.actual, expected, ((LogEntry)this.actual).getLoggerName()});
        }
        return (SELF)((Object)((AbstractLogEntryAssert)this.myself));
    }

    public AbstractStringAssert<?> hasLoggerNameThat() {
        return (AbstractStringAssert)((AbstractStringAssert)((AbstractLogEntryAssert)this.isNotNull()).extracting(LogEntry::getLoggerName, (AssertFactory)InstanceOfAssertFactories.STRING)).as(this.actual + ".loggerName", new Object[0]);
    }
}

