/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.launching.ApplicationFileViewerFilter;
import org.eclipse.php.internal.debug.ui.launching.Messages;
import org.eclipse.php.internal.debug.ui.model.ExtendedWorkbenchContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.osgi.service.prefs.BackingStoreException;

public class ApplicationFileSelectionDialog
extends ElementTreeSelectionDialog {
    private static final String SHOW_EXTERNAL_FILES = "ApplicationFileSelectionDialog_showExternalFiles";
    protected String[] fExtensions;
    protected String[] fRequiredNatures;
    private Button fExternalFilesBt;
    private boolean fAllowExternalFiles;

    public ApplicationFileSelectionDialog(Shell parent, ILabelProvider labelProvider, String title, String message, String[] extensions, String[] requiredNatures, boolean allowMultiple, boolean allowExternalFiles) {
        super(parent, labelProvider, (ITreeContentProvider)new ExtendedWorkbenchContentProvider(allowExternalFiles));
        this.fAllowExternalFiles = allowExternalFiles;
        this.setShellStyle(67696);
        this.setTitle(title);
        if (title == null) {
            this.setTitle(Messages.ApplicationFileSelectionDialog_2);
        }
        if (message == null) {
            message = Messages.ApplicationFileSelectionDialog_1;
        }
        this.setMessage(message);
        this.setAllowMultiple(allowMultiple);
        if (extensions != null) {
            this.addFilter(new ApplicationFileViewerFilter(requiredNatures, extensions));
        }
    }

    public String[] getExtensions() {
        return this.fExtensions;
    }

    public void setExtensions(String[] extensions) {
        this.fExtensions = extensions;
    }

    protected Control createDialogArea(Composite parent) {
        if (!this.fAllowExternalFiles) {
            return super.createDialogArea(parent);
        }
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        super.createDialogArea(composite);
        this.fExternalFilesBt = new Button(composite, 32);
        this.fExternalFilesBt.setText(Messages.ApplicationFileSelectionDialog_0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        this.fExternalFilesBt.setLayoutData((Object)data);
        this.fExternalFilesBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationFileSelectionDialog.this.updateView(ApplicationFileSelectionDialog.this.fExternalFilesBt.getSelection());
            }
        });
        String shouldShowExternals = Platform.getPreferencesService().getString("org.eclipse.php.debug.ui", SHOW_EXTERNAL_FILES, Boolean.toString(false), null);
        boolean show = Boolean.valueOf(shouldShowExternals);
        this.fExternalFilesBt.setSelection(show);
        this.updateView(show);
        return composite;
    }

    protected void okPressed() {
        if (this.fExternalFilesBt != null) {
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.ui");
            preferences.put(SHOW_EXTERNAL_FILES, Boolean.toString(this.fExternalFilesBt.getSelection()));
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                Logger.logException(e);
            }
        }
        super.okPressed();
    }

    private void updateView(boolean showExternalFiles) {
        ((ExtendedWorkbenchContentProvider)this.getTreeViewer().getContentProvider()).setProvideExternalFiles(showExternalFiles);
        this.getTreeViewer().refresh();
    }
}

