/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.generation.utils;

public class IndentingStringBuilder {
    private static final char NOT_A_CHAR = '\u0000';
    private static final char HARD_NEW_LINE = '\n';
    private static final char HARD_SPACE = ' ';
    private static final char SOFT_NEW_LINE = '\r';
    private static final char SOFT_SPACE = '\u00bb';
    private static final char INDENTATION = '\f';
    private StringBuilder s = new StringBuilder();
    private char lastChar = '\u0000';
    private char nextChar = '\u0000';
    private int indentationDepth = 0;

    public void append(boolean value) {
        this.append(Boolean.toString(value));
    }

    public void append(char ch) {
        assert (this.assertStateIsValid());
        assert (ch != '\u0000' && ch != '\r' && ch != '\u00bb' && ch != '\f');
        if (ch == '\n') {
            this.s.append("\n");
            this.lastChar = (char)10;
            this.nextChar = (char)12;
        } else if (ch == ' ') {
            if (this.nextChar == '\u0000') {
                this.s.append(ch);
                this.lastChar = ch;
            }
        } else {
            this.appendNextChar(this.s);
            this.s.append(ch);
            this.nextChar = '\u0000';
            this.lastChar = ch;
        }
        assert (this.assertStateIsValid());
    }

    public void append(String string) {
        if (string != null) {
            int i = 0;
            while (i < string.length()) {
                char ch = string.charAt(i);
                this.append(ch);
                ++i;
            }
        }
    }

    public void appendEndLine() {
        if (this.endsWithNonNewLine()) {
            this.append("\n");
        }
    }

    protected void appendNextChar(StringBuilder is) {
        assert (this.nextChar != '\n');
        assert (this.nextChar != ' ');
        if (this.nextChar == '\f') {
            assert (this.lastChar == '\u0000' || this.lastChar == '\n');
            int i = 0;
            while (i < this.indentationDepth) {
                is.append("\t");
                ++i;
            }
        } else if (this.nextChar == '\r') {
            if (this.lastChar != '\u0000' && this.lastChar != '\n') {
                is.append("\n");
            }
            int i = 0;
            while (i < this.indentationDepth) {
                is.append("\t");
                ++i;
            }
        } else if (this.nextChar == '\u00bb') {
            is.append(" ");
        } else if (this.nextChar != '\u0000') assert (false);
    }

    public void appendRaw(String string) {
        if (string != null && string.length() > 0) {
            this.appendNextChar(this.s);
            this.s.append(string);
            this.lastChar = string.charAt(string.length() - 1);
            this.nextChar = '\u0000';
        }
    }

    public void appendSoftNewLine() {
        if (this.nextChar == '\r' || this.nextChar == '\n' || this.nextChar == '\f') {
            return;
        }
        if (this.nextChar == '\u0000' && (this.lastChar == '\r' || this.lastChar == '\n')) {
            return;
        }
        this.nextChar = (char)13;
    }

    public void appendSoftSpace() {
        if (this.nextChar == '\r' || this.nextChar == '\n' || this.nextChar == '\u00bb' || this.nextChar == ' ' || this.nextChar == '\f') {
            return;
        }
        if (this.nextChar == '\u0000' && (this.lastChar == '\r' || this.lastChar == '\n' || this.nextChar == '\u00bb' || this.nextChar == ' ')) {
            return;
        }
        this.nextChar = (char)187;
    }

    protected boolean assertStateIsValid() {
        assert (this.lastChar == (this.s.length() > 0 ? this.s.charAt(this.s.length() - 1) : (char)'\u0000'));
        assert (this.nextChar == '\u0000' || this.nextChar == '\r' || this.nextChar == '\u00bb' || this.nextChar == '\f');
        assert (this.nextChar != '\f' || this.lastChar == '\u0000' || this.lastChar == '\n');
        return true;
    }

    public void close() {
        assert (this.indentationDepth == 0);
        if (this.nextChar == '\n') {
            this.s.append("\n");
        }
        this.nextChar = '\u0000';
    }

    protected boolean endsWithNonNewLine() {
        if (this.nextChar == ' ') {
            return true;
        }
        if (this.nextChar == '\u00bb') {
            return true;
        }
        if (this.nextChar == '\n') {
            return false;
        }
        if (this.nextChar == '\r') {
            return false;
        }
        if (this.nextChar == '\f') {
            return false;
        }
        if (this.nextChar != '\u0000') {
            return true;
        }
        if (this.lastChar == ' ') {
            return true;
        }
        if (this.lastChar == '\u00bb') {
            return true;
        }
        if (this.lastChar == '\u0000') {
            return false;
        }
        if (this.lastChar == '\n') {
            return false;
        }
        return this.lastChar != '\r';
    }

    protected boolean endsWithNonWhitespace() {
        if (this.nextChar == '\n') {
            return false;
        }
        if (this.nextChar == '\r') {
            return false;
        }
        if (this.nextChar == ' ') {
            return false;
        }
        if (this.nextChar == '\u00bb') {
            return false;
        }
        if (this.nextChar == '\f') {
            return false;
        }
        if (this.nextChar != '\u0000') {
            return true;
        }
        if (this.lastChar == '\u0000') {
            return false;
        }
        if (this.lastChar == '\n') {
            return false;
        }
        if (this.lastChar == '\r') {
            return false;
        }
        return this.lastChar != ' ';
    }

    public void popIndentation() {
        --this.indentationDepth;
    }

    public void pushIndentation() {
        ++this.indentationDepth;
    }

    public String toString() {
        if (this.nextChar == '\u0000') {
            return this.s.toString();
        }
        StringBuilder sWithIndentation = new StringBuilder();
        sWithIndentation.append((CharSequence)this.s);
        sWithIndentation.append("\u2551");
        this.appendNextChar(sWithIndentation);
        return sWithIndentation.toString();
    }
}

