/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.provider;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;

public class DefaultLayoutProvider
extends AbstractLayoutProvider {
    protected CustomLayoutConfiguration layoutConfiguration;

    @Override
    public boolean provides(IOperation operation) {
        if (operation instanceof ILayoutNodeOperation) {
            boolean canHandleLayoutType;
            ILayoutNodeOperation layoutNodeOperation = (ILayoutNodeOperation)operation;
            IAdaptable layoutHint = layoutNodeOperation.getLayoutHint();
            String layoutType = (String)layoutHint.getAdapter(String.class);
            boolean bl = canHandleLayoutType = "DEFAULT".equals(layoutType) || "OPENING".equals(layoutType) || "KEEP FIXED".equals(layoutType);
            return canHandleLayoutType && this.isLayoutForSiriusDiagram(layoutNodeOperation);
        }
        return false;
    }

    public void setLayoutConfiguration(CustomLayoutConfiguration layoutConfiguration) {
        this.layoutConfiguration = layoutConfiguration;
    }

    private boolean isLayoutForSiriusDiagram(ILayoutNodeOperation layoutOperation) {
        for (ILayoutNode node : Iterables.filter((Iterable)layoutOperation.getLayoutNodes(), ILayoutNode.class)) {
            Diagram diag;
            Diagram diagram = diag = node.getNode() != null ? node.getNode().getDiagram() : null;
            if (diag == null || !DiagramPackage.Literals.DDIAGRAM.isInstance((Object)diag.getElement())) continue;
            return true;
        }
        return false;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        DslCommonPlugin.PROFILER.startWork(ARRANGE_ALL);
        CompoundCommand cc = new CompoundCommand();
        Map<EditPart, List<EditPart>> allLayouts = this.split(selectedObjects);
        for (Map.Entry<EditPart, List<EditPart>> currentEntry : allLayouts.entrySet()) {
            AbstractLayoutEditPartProvider gmfLayoutProvider;
            LayoutProvider airLayoutProvider;
            IGraphicalEditPart container = (IGraphicalEditPart)currentEntry.getKey();
            List<EditPart> children = currentEntry.getValue();
            if (container instanceof DiagramEditPart) {
                DiagramEditPart diagramEditPart = (DiagramEditPart)container;
                children.addAll(diagramEditPart.getConnections());
            }
            if ((airLayoutProvider = LayoutService.getProvider(container)) == null || (gmfLayoutProvider = airLayoutProvider.getLayoutNodeProvider(container)) == null) continue;
            if (gmfLayoutProvider instanceof AbstractLayoutProvider) {
                ((AbstractLayoutProvider)gmfLayoutProvider).setViewsToChangeBoundsRequest(this.getViewsToChangeBoundsRequest());
            }
            cc.add(gmfLayoutProvider.layoutEditParts(children, layoutHint));
            if (!(gmfLayoutProvider instanceof AbstractLayoutProvider)) continue;
            this.getViewsToChangeBoundsRequest().putAll(((AbstractLayoutProvider)gmfLayoutProvider).getViewsToChangeBoundsRequest());
        }
        DslCommonPlugin.PROFILER.stopWork(ARRANGE_ALL);
        return cc;
    }

    protected Map<EditPart, List<EditPart>> split(List<EditPart> editParts) {
        HashMap<EditPart, List<EditPart>> result = new HashMap<EditPart, List<EditPart>>();
        ListIterator<EditPart> iterEditParts = editParts.listIterator();
        while (iterEditParts.hasNext()) {
            DiagramEditPart container;
            Object next = iterEditParts.next();
            if (next instanceof ConnectionEditPart) {
                ConnectionEditPart connectionEditPart = (ConnectionEditPart)next;
                container = this.getDiagramEditPart((EditPart)connectionEditPart);
                DefaultLayoutProvider.addToMap(result, (EditPart)container, (EditPart)connectionEditPart);
                continue;
            }
            if (next instanceof IGraphicalEditPart) {
                IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)next;
                container = graphicalEditPart.getParent();
                DefaultLayoutProvider.addToMap(result, (EditPart)container, (EditPart)graphicalEditPart);
                continue;
            }
            iterEditParts.remove();
        }
        return result;
    }

    protected static void addToMap(Map<EditPart, List<EditPart>> map, EditPart key, EditPart value) {
        List<EditPart> values = map.get(key);
        if (values == null) {
            values = new LinkedList<EditPart>();
            map.put(key, values);
        }
        values.add(value);
    }

    protected static void retainType(List<?> list, Class<?> type) {
        Iterator<?> iterElements = list.iterator();
        while (iterElements.hasNext()) {
            if (type.isInstance(iterElements.next())) continue;
            iterElements.remove();
        }
    }

    protected DiagramEditPart getDiagramEditPart(EditPart editPart) {
        EditPart current = editPart;
        while (current != null) {
            if (current instanceof DiagramEditPart) {
                return (DiagramEditPart)current;
            }
            current = current instanceof ConnectionEditPart ? ((ConnectionEditPart)current).getSource() : current.getParent();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected <T extends EditPart> Map<View, T> getViews(List<T> editParts) {
        HashMap<void, EditPart> result = new HashMap<void, EditPart>();
        for (EditPart next : editParts) {
            void model;
            Object object = next.getModel();
            if (!(object instanceof View)) continue;
            View cfr_ignored_0 = (View)object;
            View cfr_ignored_1 = (View)object;
            result.put(model, next);
        }
        return result;
    }
}

