/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.elements;

import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.phpunit.model.connection.MessageElement;

public abstract class PHPUnitElement {
    protected static final String SEPARATOR_LINE = ":";
    protected static final String SEPARATOR_MESSAGE = "!";
    protected static final String SEPARATOR_NAME = "$";
    protected String file = null;
    protected String localFile = null;
    protected boolean isFiltered = false;
    protected int line = 0;
    protected PHPUnitElement parent;
    protected int testId = 0;

    public PHPUnitElement(MessageElement test, PHPUnitElement parent, RemoteDebugger remoteDebugger) {
        if (test != null) {
            this.parseFrame(test, remoteDebugger);
        }
        if (parent != null) {
            this.setParent(parent);
        }
    }

    public void setParent(PHPUnitElement parent) {
        this.parent = parent;
    }

    public String getFile() {
        return this.file;
    }

    public String getLocalFile() {
        return this.localFile;
    }

    public int getLine() {
        return this.line;
    }

    public PHPUnitElement getParent() {
        return this.parent;
    }

    public int getTestId() {
        if (this.testId == 0) {
            this.setTestId();
        }
        return this.testId;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    private void parseFrame(MessageElement test, RemoteDebugger remoteDebugger) {
        String sFile = test.getFile();
        if (sFile != null) {
            this.file = sFile;
            if (remoteDebugger != null) {
                this.localFile = remoteDebugger.convertToLocalFilename(this.file, null, null);
            }
            if (this.localFile == null) {
                this.localFile = this.file;
            }
            this.line = test.getLine();
        }
        if (test.getFiltered() != null) {
            this.isFiltered = true;
        }
    }

    protected void setTestId() {
        this.testId = this.toString().hashCode();
    }
}

