/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;

public class DBGpBoolValue
extends AbstractDBGpValue {
    private static final String[] fAllowedValues = new String[]{"false", "true"};

    public DBGpBoolValue(DBGpVariable owner) {
        super(owner);
    }

    @Override
    protected boolean verifyValue(String expression) {
        String[] stringArray = fAllowedValues;
        int n = fAllowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String allowed = stringArray[n2];
            if (expression.equals(allowed)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected String createValueString(AbstractDBGpValue.DBGpValueData data) {
        String valueString = data.getValueString();
        if (valueString != null) {
            try {
                int bool = Integer.parseInt(valueString);
                if (1 == bool) {
                    return fAllowedValues[1];
                }
                if (bool == 0) {
                    return fAllowedValues[0];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected boolean supportsValueModification() {
        return true;
    }
}

