/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.GistService;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.github.core.gist.GistConnector;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.gist.CreateGistJob;
import org.eclipse.mylyn.internal.github.ui.gist.GistConnectorSelectionDialog;
import org.eclipse.mylyn.internal.github.ui.gist.GistConnectorUi;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateGistHandler
extends AbstractHandler {
    public static final String PUBLIC_GIST = "publicGist";
    private static final String DEFAULT_FILENAME = "file.txt";

    public boolean isEnabled() {
        return !GistConnectorUi.getRepositories().isEmpty();
    }

    private static IEditorInput getActiveEditorInput(ExecutionEvent event) {
        Object var = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditorInput");
        return var instanceof IEditorInput ? (IEditorInput)var : null;
    }

    private IWorkbenchPart getActivePart(ExecutionEvent event) {
        Object var = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activePart");
        return var instanceof IWorkbenchPart ? (IWorkbenchPart)var : null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorInput input = CreateGistHandler.getActiveEditorInput(event);
        IWorkbenchPart part = this.getActivePart(event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        }
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        boolean isPublic = Boolean.parseBoolean(event.getParameter(PUBLIC_GIST));
        if (selection instanceof ITextSelection) {
            ITextSelection text = (ITextSelection)selection;
            Object name = null;
            if (part == null || part instanceof IEditorPart) {
                int lastSlash;
                String rawPath;
                URI uri;
                IPath path;
                IFile file;
                if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
                    name = file.getName();
                }
                if (name == null && input instanceof IPathEditorInput && (path = ((IPathEditorInput)input).getPath()) != null) {
                    name = path.lastSegment();
                }
                if (name == null && input instanceof IURIEditorInput && (uri = ((IURIEditorInput)input).getURI()) != null && (rawPath = uri.getRawPath()) != null && (lastSlash = rawPath.lastIndexOf(47) + 1) > 0 && lastSlash < rawPath.length()) {
                    name = rawPath.substring(lastSlash);
                }
            } else if (part instanceof IWorkbenchPart2) {
                name = ((IWorkbenchPart2)part).getPartName().replace(" ", "").toLowerCase(Locale.US) + ".txt";
            }
            if (name == null) {
                name = DEFAULT_FILENAME;
            }
            this.createGistJob(event, (String)name, text.getText(), isPublic);
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object obj = structuredSelection.getFirstElement();
            IResource file = null;
            if (obj instanceof IResource) {
                file = (IResource)obj;
            } else if (obj instanceof IAdaptable && (file = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) == null) {
                file = (IResource)((IAdaptable)obj).getAdapter(IFile.class);
            }
            if (file instanceof IFile) {
                this.createGistJob(event, (IFile)file, isPublic);
            }
        }
        return null;
    }

    private void createGistJob(ExecutionEvent event, String name, String contents, boolean isPublic) {
        Set<TaskRepository> repositories = GistConnectorUi.getRepositories();
        if (repositories.isEmpty()) {
            return;
        }
        TaskRepository repository = null;
        if (repositories.size() > 1) {
            GistConnectorSelectionDialog dialog = new GistConnectorSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), repositories);
            if (dialog.open() == 0) {
                repository = (TaskRepository)dialog.getResult()[0];
            }
        } else {
            repository = repositories.iterator().next();
        }
        if (repository == null) {
            return;
        }
        GitHubClient client = GistConnector.createClient((TaskRepository)repository);
        GistService service = new GistService(client);
        CreateGistJob job = new CreateGistJob(Messages.CreateGistHandler_CreateGistJobName, name, contents, service, isPublic, repository);
        job.schedule();
    }

    private void createGistJob(ExecutionEvent event, IFile file, boolean isPublic) {
        block13: {
            BufferedReader br = null;
            try {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(file.getContents()));
                    StringBuilder result = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        result.append(line).append('\n');
                    }
                    String contents = result.toString();
                    this.createGistJob(event, file.getName(), contents, isPublic);
                }
                catch (IOException | CoreException e) {
                    GitHubUi.logError(e);
                    if (br == null) break block13;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        GitHubUi.logError(e2);
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        GitHubUi.logError(e);
                    }
                }
            }
        }
    }
}

