/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SeverityKind implements Enumerator
{
    ERROR(0, "error", "error"),
    WARNING(1, "warning", "warning"),
    FATAL(2, "fatal", "fatal");

    public static final int ERROR_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int FATAL_VALUE = 2;
    private static final SeverityKind[] VALUES_ARRAY;
    public static final List<SeverityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SeverityKind[]{ERROR, WARNING, FATAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SeverityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SeverityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SeverityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SeverityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SeverityKind get(int value) {
        switch (value) {
            case 0: {
                return ERROR;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return FATAL;
            }
        }
        return null;
    }

    private SeverityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

