/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.build;

import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.filtering.ResourceFilteringBuildParticipant;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WarProjectBuildParticipant
extends ResourceFilteringBuildParticipant {
    @Override
    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        MavenProject mavenProject;
        WarPluginConfiguration warConfig;
        super.build(kind, monitor);
        IMavenProjectFacade facade = this.getMavenProjectFacade();
        IProject project = facade.getProject();
        boolean iswtp = WTPProjectsUtil.isWTPProject(project);
        if (!iswtp) {
            return null;
        }
        final Boolean[] requiresWebXmlCheck = new Boolean[]{Boolean.FALSE};
        boolean deleteMarkers = true;
        switch (kind) {
            case 15: {
                break;
            }
            case 6: {
                requiresWebXmlCheck[0] = Boolean.TRUE;
                break;
            }
            default: {
                IResourceDelta delta = this.getDelta(project);
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            String name;
                            boolean foundInterestingFile = false;
                            IResource resource = delta.getResource();
                            if (resource instanceof IFile && ("web.xml".equals(name = resource.getName()) || "pom.xml".equals(name))) {
                                foundInterestingFile = true;
                                requiresWebXmlCheck[0] = Boolean.TRUE;
                            }
                            return !foundInterestingFile;
                        }
                    });
                }
                deleteMarkers = requiresWebXmlCheck[0];
            }
        }
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        IFile pom = facade.getPom();
        if (deleteMarkers && pom.findMarkers("org.eclipse.m2e.core.maven2Problem.wtp.failOnMissingWebXml", false, 0) != null) {
            markerManager.deleteMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.wtp.failOnMissingWebXml");
        }
        if (requiresWebXmlCheck[0].booleanValue() && (warConfig = new WarPluginConfiguration(mavenProject = facade.getMavenProject(monitor), project)).isFailOnMissingWebXml() && this.isWebXmlMissing(project)) {
            SourceLocation sourceLocation = SourceLocationHelper.findLocation((MavenProject)mavenProject, (MojoExecutionKey)new MojoExecutionKey("org.apache.maven.plugins", "maven-war-plugin", null, null, null, null));
            markerManager.addMarker((IResource)pom, "org.eclipse.m2e.core.maven2Problem.wtp.failOnMissingWebXml", Messages.WarProjectBuildParticipant_Error_FailOnMissingWebXml, sourceLocation.getLineNumber(), 2);
        }
        return null;
    }

    private boolean isWebXmlMissing(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (boolean)true);
        if (component != null) {
            IVirtualFolder rootFolder = component.getRootFolder();
            return rootFolder.findMember((IPath)new Path("WEB-INF/web.xml")) == null;
        }
        return false;
    }
}

