/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ext.test;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.ext.WebServiceExtension;
import org.eclipse.jst.ws.internal.ext.WebServiceExtensionRegistryImpl;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;

public class WebServiceTestRegistry
extends WebServiceExtensionRegistryImpl {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private static WebServiceTestRegistry wstr;

    public static WebServiceTestRegistry getInstance() {
        if (wstr == null) {
            wstr = new WebServiceTestRegistry();
        }
        return wstr;
    }

    private WebServiceTestRegistry() {
    }

    private String genNewValue(String existingValue, String newValue) {
        if (existingValue == null || newValue == null) {
            return newValue;
        }
        return String.valueOf(existingValue) + " " + newValue;
    }

    @Override
    protected void loadExtensions() {
        Hashtable<String, String> supportedClientRuntimes = new Hashtable<String, String>();
        IConfigurationElement[] config = this.getConfigElements();
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            String label = elem.getAttribute("label");
            String id = elem.getAttribute("id");
            if (label != null) {
                WebServiceExtension webServiceExtension = this.createWebServiceExtension(elem);
                this.nameExtensionTable_.put(id, webServiceExtension);
                this.label_.add(label);
                this.id_.add(id);
            } else {
                String existingValue = (String)supportedClientRuntimes.get(id);
                String newValue = this.genNewValue(existingValue, elem.getAttribute("supportedClientRuntimes"));
                if (newValue != null) {
                    supportedClientRuntimes.put(id, newValue);
                }
            }
            ++idx;
        }
        for (WebServiceTestExtension webServiceTestExtension : this.nameExtensionTable_.values()) {
            if (!webServiceTestExtension.allowClientRuntimesRestriction()) continue;
            String id = webServiceTestExtension.getId();
            webServiceTestExtension.addRuntimes((String)supportedClientRuntimes.get(id));
        }
    }

    @Override
    public String[] getWebServiceExtensionNames() {
        return this.label_.toArray(new String[0]);
    }

    public String labelToId(String label) {
        int labelIndex = this.label_.indexOf(label);
        if (labelIndex == -1) {
            return label;
        }
        return (String)this.id_.elementAt(labelIndex);
    }

    public WebServiceExtension getWebServiceExtensionsById(String id) {
        return (WebServiceExtension)this.nameExtensionTable_.get(id);
    }

    @Override
    public WebServiceExtension getWebServiceExtensionsByName(String name) {
        return this.getWebServiceExtensionsById(this.labelToId(name));
    }

    @Override
    public WebServiceExtension createWebServiceExtension(IConfigurationElement configElement) {
        return new WebServiceTestExtension(configElement);
    }

    @Override
    public IConfigurationElement[] getConfigElements() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "tester");
        return config;
    }
}

