/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.ui.provider;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.parsley.runtime.ui.IImageHelper;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ViewerLabelProvider
implements ILabelProvider,
IFontProvider,
IColorProvider {
    @Inject
    private IImageHelper imageHelper;
    @Inject
    @Named(value="IterableStringSeparator")
    private String separator;
    @Inject
    @Named(value="IterableStringEllipses")
    private String ellipses;
    @Inject
    @Named(value="IterableStringMaxLength")
    private int iterableStringMaxLength;
    private PolymorphicDispatcher<String> textDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"text", (int)1, (int)1, (Object)this);
    private PolymorphicDispatcher<Object> imageDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"image", (int)1, (int)1, (Object)this);
    private PolymorphicDispatcher<Font> fontDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"font", (int)1, (int)1, (Object)this);
    private PolymorphicDispatcher<Color> foregroundDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"foreground", (int)1, (int)1, (Object)this);
    private PolymorphicDispatcher<Color> backgroundDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"background", (int)1, (int)1, (Object)this);
    protected ILabelProvider delegateLabelProvider;

    @Inject
    public ViewerLabelProvider(AdapterFactoryLabelProvider delegate) {
        this.delegateLabelProvider = delegate;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        String text = (String)this.textDispatcher.invoke(new Object[]{element});
        if (text != null) {
            return text;
        }
        return this.getDelegateText(element);
    }

    protected String getDelegateText(Object element) {
        return this.getDelegateLabelProvider().getText(element);
    }

    public Image getImage(Object element) {
        Image image;
        if (element == null) {
            return null;
        }
        Object imageObject = this.imageDispatcher.invoke(new Object[]{element});
        if (imageObject != null && (image = this.imageHelper.convertToImage(imageObject)) != null) {
            return image;
        }
        return this.getDelegateImage(element);
    }

    protected Image getDelegateImage(Object element) {
        return this.getDelegateLabelProvider().getImage(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.getDelegateLabelProvider().addListener(listener);
    }

    public void dispose() {
        this.getDelegateLabelProvider().dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.getDelegateLabelProvider().isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.getDelegateLabelProvider().removeListener(listener);
    }

    public ILabelProvider getDelegateLabelProvider() {
        return this.delegateLabelProvider;
    }

    public String text(Object element) {
        return null;
    }

    public Object image(Object element) {
        return null;
    }

    public String text(FeatureMap.Entry entry) {
        return this.getText(entry.getValue());
    }

    public Object image(FeatureMap.Entry entry) {
        return this.getImage(entry.getValue());
    }

    public String text(Iterable<?> iterable) {
        StringBuilder builder = new StringBuilder();
        for (Object object : iterable) {
            if (builder.length() > 0) {
                builder.append(this.separator);
            }
            builder.append(this.getText(object));
            if (builder.length() <= this.iterableStringMaxLength) continue;
            return builder.substring(0, this.iterableStringMaxLength) + this.ellipses;
        }
        return builder.toString();
    }

    public Font getFont(Object element) {
        if (element == null) {
            return null;
        }
        return (Font)this.fontDispatcher.invoke(new Object[]{element});
    }

    public Font font(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element == null) {
            return null;
        }
        return (Color)this.foregroundDispatcher.invoke(new Object[]{element});
    }

    public Color foreground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element == null) {
            return null;
        }
        return (Color)this.backgroundDispatcher.invoke(new Object[]{element});
    }

    public Color background(Object element) {
        return null;
    }
}

