/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CommentStatus implements Enumerator
{
    NONE(0, "None", "None"),
    UNRESOLVED(1, "Unresolved", "Unresolved"),
    RESOLVED(2, "Resolved", "Resolved");

    public static final int NONE_VALUE = 0;
    public static final int UNRESOLVED_VALUE = 1;
    public static final int RESOLVED_VALUE = 2;
    private static final CommentStatus[] VALUES_ARRAY;
    public static final List<CommentStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CommentStatus[]{NONE, UNRESOLVED, RESOLVED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CommentStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommentStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommentStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommentStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommentStatus get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return UNRESOLVED;
            }
            case 2: {
                return RESOLVED;
            }
        }
        return null;
    }

    private CommentStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

