/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.util.CDONameProvider;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.internal.explorer.AbstractManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public abstract class AbstractElement
extends org.eclipse.net4j.util.event.Notifier
implements CDOExplorerElement,
Adapter.Internal,
IManagedContainerProvider {
    public static final String ILLEGAL_LABEL_CHARACTERS = "/\\:;,";
    public static final String PROP_TYPE = "type";
    public static final String PROP_LABEL = "label";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_KEYWORDS = "keywords";
    public static final String PROP_SERVER_BROWSER_PORT = "serverBrowserPort";
    private static final String KEYWORD_DELIMITER = " ";
    private final IRegistry<String, Object> transientProperties = new HashMapRegistry.AutoCommit();
    private Notifier target;
    private File folder;
    private String id;
    private String type;
    private String label;
    private String description;
    private Set<String> keywords;
    private int serverBrowserPort;
    private String error;

    public abstract AbstractManager<?> getManager();

    public IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    @Override
    public final File getFolder() {
        return this.folder;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setLabel(String label) {
        if (!ObjectUtil.equals((Object)this.label, (Object)label)) {
            this.label = label;
            this.save();
            this.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.PARENT);
        }
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final void setDescription(String description) {
        if (!ObjectUtil.equals((Object)this.description, (Object)description)) {
            this.description = description;
            this.save();
            this.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE);
        }
    }

    @Override
    public final boolean hasKeyword(String keyword) {
        if (this.keywords != null) {
            return this.keywords.contains(keyword);
        }
        return false;
    }

    @Override
    public final Set<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public final boolean setKeywords(Set<String> keywords) {
        if (!ObjectUtil.equals(this.keywords, keywords)) {
            this.keywords = AbstractElement.sanitizeKeywords(keywords);
            this.save();
            this.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE);
            return true;
        }
        return false;
    }

    @Override
    public final boolean addKeyword(String keyword) {
        HashSet<String> newKeywords = new HashSet<String>(this.keywords);
        newKeywords.add(keyword);
        return this.setKeywords(newKeywords);
    }

    @Override
    public final boolean removeKeyword(String keyword) {
        HashSet<String> newKeywords = new HashSet<String>(this.keywords);
        newKeywords.remove(keyword);
        return this.setKeywords(newKeywords);
    }

    public final int getServerBrowserPort() {
        return this.serverBrowserPort;
    }

    public final void setServerBrowserPort(int serverBrowserPort) {
        if (this.serverBrowserPort != serverBrowserPort) {
            this.serverBrowserPort = serverBrowserPort;
            this.save();
        }
    }

    @Override
    public final String getError() {
        return this.error;
    }

    public final void setError(String error) {
        if (!ObjectUtil.equals((Object)this.error, (Object)error)) {
            this.error = error;
            this.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE);
        }
    }

    protected final void fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact structuralImpact) {
        AbstractManager<?> manager = this.getManager();
        if (manager != null) {
            manager.fireElementChangedEvent(structuralImpact, this);
        }
    }

    protected final void fireStateChangedEvent() {
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent(new StateChangedEventImpl(this), listeners);
        }
    }

    public String validateLabel(String label) {
        if (StringUtil.isEmpty((String)label.trim())) {
            return "Label is empty.";
        }
        if (ObjectUtil.equals((Object)label, (Object)this.getLabel())) {
            return null;
        }
        AbstractManager<?> manager = this.getManager();
        if (manager != null && manager.getElementByLabel(label) != null) {
            return "Label is not unique.";
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == CDONameProvider.class) {
            return new CDONameProvider(){

                public String getName() {
                    return AbstractElement.this.label;
                }
            };
        }
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public final void notifyChanged(Notification notification) {
    }

    public final Notifier getTarget() {
        return this.target;
    }

    public final void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    public final void unsetTarget(Notifier oldTarget) {
        if (this.target == oldTarget) {
            this.target = null;
        }
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            AbstractElement that = (AbstractElement)obj;
            return this.id.equals(that.getID());
        }
        return false;
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.id.hashCode();
    }

    @Override
    public final int compareTo(CDOExplorerElement o) {
        String label1 = StringUtil.safe((String)this.label).toLowerCase();
        String label2 = StringUtil.safe((String)o.getLabel()).toLowerCase();
        return label1.compareTo(label2);
    }

    @Override
    public final File getStateFolder(String path) {
        return this.getStateFolder(path, true);
    }

    @Override
    public final File getStateFolder(String path, boolean createOnDemand) {
        File stateFolder = new File(this.folder, path);
        if (!stateFolder.exists()) {
            if (!createOnDemand) {
                return null;
            }
            stateFolder.mkdirs();
        }
        return stateFolder;
    }

    @Override
    public void delete(boolean deleteContents) {
        if (deleteContents) {
            IOUtil.delete((File)this.folder);
        } else {
            String propertiesFileName = this.getManager().getPropertiesFileName();
            File from = new File(this.folder, propertiesFileName);
            File dest = new File(from.getParentFile(), String.valueOf(from.getName()) + ".removed");
            from.renameTo(dest);
        }
    }

    public final void save() {
        String propertiesFileName = this.getManager().getPropertiesFileName();
        Properties properties = this.getProperties();
        this.saveProperties(propertiesFileName, properties);
    }

    @Override
    public final Properties getProperties() {
        Properties properties = new Properties();
        this.collectProperties(properties);
        return properties;
    }

    @Override
    public final IRegistry<String, Object> getTransientProperties() {
        return this.transientProperties;
    }

    protected final void saveProperties(String fileName, Properties properties) {
        AbstractManager.saveProperties(this.folder, fileName, properties, String.valueOf(this.getClass().getSimpleName()) + KEYWORD_DELIMITER + fileName);
    }

    protected void init(File folder, String type, Properties properties) {
        this.folder = folder;
        this.id = folder.getName();
        this.type = type;
        this.label = properties.getProperty(PROP_LABEL);
        this.description = properties.getProperty(PROP_DESCRIPTION);
        Set<String> set = AbstractElement.parseKeywords(properties.getProperty(PROP_KEYWORDS));
        this.keywords = AbstractElement.sanitizeKeywords(set);
        String property = properties.getProperty(PROP_SERVER_BROWSER_PORT);
        if (property != null) {
            this.serverBrowserPort = Integer.parseInt(property);
        }
    }

    protected void collectProperties(Properties properties) {
        properties.setProperty(PROP_TYPE, this.type);
        properties.setProperty(PROP_LABEL, this.label);
        if (!StringUtil.isEmpty((String)this.description)) {
            properties.setProperty(PROP_DESCRIPTION, this.description);
        }
        if (!ObjectUtil.isEmpty(this.keywords)) {
            properties.setProperty(PROP_KEYWORDS, AbstractElement.formatKeywords(this.keywords));
        }
        if (this.serverBrowserPort != 0) {
            properties.setProperty(PROP_SERVER_BROWSER_PORT, Integer.toString(this.serverBrowserPort));
        }
    }

    public static AbstractElement[] collect(Collection<?> c) {
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        for (Object object : c) {
            if (!(object instanceof AbstractElement)) continue;
            AbstractElement element = (AbstractElement)object;
            result.add(element);
        }
        return result.toArray(new AbstractElement[result.size()]);
    }

    public static String formatKeywords(Set<String> keywords) {
        ArrayList<String> list = new ArrayList<String>(keywords);
        list.sort(null);
        return String.join((CharSequence)KEYWORD_DELIMITER, list);
    }

    public static Set<String> parseKeywords(String string) {
        HashSet<String> keywords = new HashSet<String>();
        if (!StringUtil.isEmpty((String)string)) {
            StringTokenizer tokenizer = new StringTokenizer(string, KEYWORD_DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String keyword = tokenizer.nextToken();
                if (keyword.length() == 0) continue;
                keywords.add(keyword);
            }
        }
        return keywords;
    }

    private static Set<String> sanitizeKeywords(Set<String> set) {
        return ObjectUtil.isEmpty(set) ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    private static final class StateChangedEventImpl
    extends Event
    implements CDOExplorerElement.StateChangedEvent {
        private static final long serialVersionUID = 1L;

        public StateChangedEventImpl(AbstractElement element) {
            super((INotifier)element);
        }

        @Override
        public AbstractElement getSource() {
            return (AbstractElement)super.getSource();
        }
    }
}

