/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.ScriptRuntime;

public class ScriptSourcePathComputer
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedSourceBuildpath(configuration);
        IRuntimeBuildpathEntry[] resolved = ScriptRuntime.resolveRuntimeBuildpath(entries, configuration);
        ISourceContainer[] containers = ScriptRuntime.getSourceContainers(resolved);
        IProject project = LaunchConfigurationUtils.getProject(configuration);
        if (project != null) {
            FolderSourceContainer container = new FolderSourceContainer((IContainer)project, false);
            ArrayList<ISourceContainer> list = new ArrayList<ISourceContainer>(Arrays.asList(containers));
            if (!list.contains(container)) {
                list.add((ISourceContainer)container);
            }
            return list.toArray(new ISourceContainer[list.size()]);
        }
        return containers;
    }
}

