/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;

public abstract class SynchronizeModelAction
extends BaseSelectionListenerAction {
    private final ISynchronizePageConfiguration configuration;

    protected SynchronizeModelAction(String text, ISynchronizePageConfiguration configuration) {
        this(text, configuration, configuration.getSite().getSelectionProvider());
    }

    protected SynchronizeModelAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text);
        this.configuration = configuration;
        this.initialize(configuration, selectionProvider);
    }

    protected void initialize(ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        configuration.getPage().getViewer().getControl().addDisposeListener(e -> selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this));
    }

    public void run() {
        if (this.needsToSaveDirtyEditors() && !this.saveAllEditors(this.confirmSaveOfDirtyEditor())) {
            return;
        }
        try {
            this.runOperation();
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException e) {
            this.handle(e);
        }
    }

    protected void runOperation() throws InvocationTargetException, InterruptedException {
        this.getSubscriberOperation(this.configuration, this.getFilteredDiffElements()).run();
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    protected boolean confirmSaveOfDirtyEditor() {
        return true;
    }

    protected abstract SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration var1, IDiffElement[] var2);

    protected void handle(Exception e) {
        Utils.handle(e);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        return this.isEnabledForSelection(selection);
    }

    private boolean isEnabledForSelection(IStructuredSelection selection) {
        return Utils.hasMatchingDescendant(selection, this.getSyncInfoFilter());
    }

    protected final IDiffElement[] getSelectedDiffElements() {
        return Utils.getDiffNodes(this.getStructuredSelection().toArray());
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter();
    }

    protected final IDiffElement[] getFilteredDiffElements() {
        IDiffElement[] elements = this.getSelectedDiffElements();
        ArrayList<IDiffElement> filtered = new ArrayList<IDiffElement>();
        IDiffElement[] iDiffElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info;
            IDiffElement e = iDiffElementArray[n2];
            if (e instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)e).getSyncInfo()) != null && this.getSyncInfoFilter().select(info)) {
                filtered.add(e);
            }
            ++n2;
        }
        return filtered.toArray(new IDiffElement[filtered.size()]);
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            super.selectionChanged((IStructuredSelection)selection);
        } else {
            super.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public final boolean saveAllEditors(boolean confirm) {
        return IDE.saveAllEditors((IResource[])Utils.getResources(this.getFilteredDiffElements()), (boolean)confirm);
    }
}

