/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;

public class ToolBarItemClickedRule
extends GenerationSimpleRule {
    private String toolTipText;
    private String text;
    private ToolItem widget;

    @Override
    public boolean appliesTo(Event event) {
        if (event.widget instanceof ToolItem && event.type == 13) {
            ToolItem item = (ToolItem)event.widget;
            int style = item.getStyle();
            return (style & 4) == 0 && (style & 8) != 0;
        }
        return false;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.widget = (ToolItem)event.widget;
        this.text = this.widget.getText();
        this.toolTipText = this.widget.getToolTipText();
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder res = new StringBuilder("bot.");
        if (this.text != null && this.text.length() > 0) {
            res.append("toolbarButton(\"");
            res.append(this.text);
            res.append("\")");
        } else if (this.toolTipText != null && this.toolTipText.length() > 0) {
            res.append("toolbarButtonWithTooltip(\"");
            res.append(this.toolTipText);
            res.append("\")");
        } else {
            res.append("toolbarButton(");
            res.append("TODO index");
            res.append(')');
        }
        res.append(".click()");
        actions.add(res.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public ToolItem getWidget() {
        return this.widget;
    }
}

