/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import java.util.Objects;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.swt.graphics.Image;

public class WorkspaceImageQuery {
    private final String workspaceImagePath;

    public WorkspaceImageQuery(WorkspaceImageDescription workspaceImageDescription) {
        Objects.requireNonNull(workspaceImageDescription);
        this.workspaceImagePath = workspaceImageDescription.getWorkspacePath();
    }

    public WorkspaceImageQuery(WorkspaceImage workspaceImage) {
        Objects.requireNonNull(workspaceImage);
        this.workspaceImagePath = workspaceImage.getWorkspacePath();
    }

    public boolean doesImageExist() {
        return this.getImage() != null;
    }

    public Dimension getDefaultDimension() {
        Dimension result = new Dimension();
        if (this.doesImageExist()) {
            Image image = this.getImage();
            result.setWidth(image.getBounds().width);
            result.setHeight(image.getBounds().height);
        }
        return result;
    }

    public double getRatio() {
        double result = 1.0;
        if (this.doesImageExist()) {
            Image image = this.getImage();
            result = (double)image.getBounds().width / (double)image.getBounds().height;
        }
        return result;
    }

    protected Image getImage() {
        return WorkspaceImageFigure.getImageInstanceFromPath(this.workspaceImagePath);
    }
}

