/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.model.IPHPExceptionBreakpoint;

public class PHPExceptionBreakpoint
extends Breakpoint
implements IPHPExceptionBreakpoint {
    public static final String MARKER_ID = "org.eclipse.php.debug.core.PHPExceptionBreakpointMarker";
    public static final String ATTR_TYPE = "org.eclipse.php.debug.core.PHPExceptionType";
    private String name;
    private IPHPExceptionBreakpoint.Type type;
    private Map<IDebugTarget, Integer> lines = new WeakHashMap<IDebugTarget, Integer>();
    private Map<IDebugTarget, Integer> ids = new WeakHashMap<IDebugTarget, Integer>();

    public PHPExceptionBreakpoint() {
    }

    public PHPExceptionBreakpoint(String name, IPHPExceptionBreakpoint.Type type) {
        this.name = name;
        this.type = type;
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_ID);
            marker.setAttribute("org.eclipse.debug.core.persisted", (Object)Boolean.TRUE);
            marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
            marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
            marker.setAttribute("message", (Object)name);
            marker.setAttribute(ATTR_TYPE, (Object)type.name());
            this.setMarker(marker);
            this.setEnabled(true);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public String getModelIdentifier() {
        return "org.eclipse.php.debug.core";
    }

    @Override
    public String getExceptionName() {
        return this.name;
    }

    @Override
    public int getLine(IDebugTarget target) {
        Integer number = this.lines.get(target);
        return number != null ? number : -1;
    }

    @Override
    public int getId(IDebugTarget target) {
        Integer id = this.ids.get(target);
        return id != null ? id : -1;
    }

    @Override
    public IPHPExceptionBreakpoint.Type getType() {
        return this.type;
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.name = marker.getAttribute("message", null);
        this.type = IPHPExceptionBreakpoint.Type.valueOf(marker.getAttribute(ATTR_TYPE, null));
    }

    @Override
    public void setLine(IDebugTarget target, int line) {
        this.lines.put(target, line);
    }

    @Override
    public void setId(IDebugTarget target, int id) {
        this.ids.put(target, id);
    }
}

