/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.infra.services.decoration.util.StringUtils;

public class Decoration
implements IPapyrusDecoration {
    private final String id;
    private String message;
    private EObject element;
    private ImageDescriptor decorationImageForGE;
    private ImageDescriptor decorationImageForME;
    private String type;
    private PreferedPosition position;
    private int priority;

    public Decoration(String id, String type, ImageDescriptor decorationImageForGE, ImageDescriptor decorationImageForME, String message, EObject element, int priority) {
        this.id = id;
        this.decorationImageForGE = decorationImageForGE;
        this.decorationImageForME = decorationImageForME;
        this.message = message;
        this.element = element;
        this.type = type;
        this.position = PreferedPosition.SOUTH_EAST;
        this.priority = priority;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    public EObject getElement() {
        return this.element;
    }

    public void setElement(EObject element) {
        this.element = element;
    }

    @Override
    public ImageDescriptor getDecorationImageForGE() {
        return this.decorationImageForGE;
    }

    @Override
    public void setDecorationImageForGE(ImageDescriptor decorationImageForGE) {
        this.decorationImageForGE = decorationImageForGE;
    }

    @Override
    public ImageDescriptor getDecorationImageForME() {
        return this.decorationImageForME;
    }

    @Override
    public void setDecorationImageForME(ImageDescriptor decorationImageForME) {
        this.decorationImageForME = decorationImageForME;
    }

    @Override
    public PreferedPosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(PreferedPosition position) {
        this.position = position;
    }

    @Override
    public int getPositionForJFace() {
        switch (this.position) {
            case NORTH_WEST: 
            case NORTH: {
                return 0;
            }
            case NORTH_EAST: {
                return 1;
            }
            case SOUTH_WEST: 
            case WEST: {
                return 2;
            }
            default: {
                return 3;
            }
            case SOUTH: 
            case CENTER: 
        }
        return 4;
    }

    public static String getMessageFromDecorations(DecorationService decorationService, Object element) {
        if (decorationService == null) {
            return null;
        }
        List<IPapyrusDecoration> decorations = decorationService.getDecorations(element, true);
        EObject eObject = EMFHelper.getEObject((Object)element);
        Object message = decorationService.initialMessage(eObject);
        if (decorations != null) {
            for (IPapyrusDecoration decoration : decorations) {
                if (message == null) {
                    message = "";
                }
                if (((String)message).length() > 0) {
                    message = (String)message + "\n";
                }
                if (decoration.getMessage() == null) continue;
                message = (String)message + "- " + StringUtils.stringWrap(decoration.getMessage(), 100, "\n ");
            }
        }
        if (message != null && ((String)message).length() > 0) {
            return message;
        }
        return null;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public static enum PreferedPosition {
        NORTH_WEST,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        CENTER,
        DEFAULT;

    }
}

