/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.ocl.tracker.OclTracker;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.ocl.tracker.OclTrackerFactory;

abstract class OclTrackerWrapper {
    private final OclTrackerFactory myOclTrackerFactory;
    private OclTracker myOclTracker;

    public OclTrackerWrapper(OclTrackerFactory oclTrackerFactory) {
        this.myOclTrackerFactory = oclTrackerFactory;
    }

    public OclTracker getOclTracker() {
        if (this.myOclTracker == null) {
            this.myOclTracker = this.myOclTrackerFactory.createOclTracker(this.getExpressionBody(), true);
        }
        return this.myOclTracker;
    }

    public String getUpdatedString(IAdaptable element, int flags) {
        EObject target = (EObject)element.getAdapter(EObject.class);
        this.getOclTracker().initialize(target);
        return String.valueOf(this.getOclTracker().getValue());
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (event instanceof Notification) {
            Notification notification = (Notification)event;
            return this.getOclTracker().handleNotification(notification);
        }
        return false;
    }

    protected abstract String getExpressionBody();
}

