/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console.xtfo;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ocl.examples.xtext.console.xtfo.HighlightingReconciler;
import org.eclipse.xtext.ui.editor.XtextPresentationReconciler;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingPresenter;

public class HighlightingHelper
implements IPropertyChangeListener {
    @Inject
    private Provider<HighlightingReconciler> reconcilerProvider;
    @Inject
    private Provider<HighlightingPresenter> presenterProvider;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccessor;
    @Inject
    private HighlightingPresenter fPresenter;
    @Inject
    private HighlightingReconciler fReconciler;
    private XtextSourceViewer fSourceViewer;
    private XtextSourceViewerConfiguration fConfiguration;
    private XtextPresentationReconciler fPresentationReconciler;

    public void install(XtextSourceViewerConfiguration configuration, XtextSourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
        this.fConfiguration = configuration;
        this.fPresentationReconciler = (XtextPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
        this.preferenceStoreAccessor.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.enable();
    }

    private void enable() {
        this.fPresenter = (HighlightingPresenter)this.getPresenterProvider().get();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fSourceViewer.getDocument() != null) {
            this.fReconciler = (HighlightingReconciler)this.reconcilerProvider.get();
            this.fReconciler.install(this.fSourceViewer, this.fPresenter);
        }
    }

    public void uninstall() {
        this.disable();
        this.preferenceStoreAccessor.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fSourceViewer = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
    }

    public HighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    public void setReconcilerProvider(Provider<HighlightingReconciler> reconcilerProvider) {
        this.reconcilerProvider = reconcilerProvider;
    }

    public Provider<HighlightingReconciler> getReconcilerProvider() {
        return this.reconcilerProvider;
    }

    public void setPresenterProvider(Provider<HighlightingPresenter> presenterProvider) {
        this.presenterProvider = presenterProvider;
    }

    public Provider<HighlightingPresenter> getPresenterProvider() {
        return this.presenterProvider;
    }

    public void setPreferenceStoreAccessor(IPreferenceStoreAccess preferenceStoreAccessor) {
        this.preferenceStoreAccessor = preferenceStoreAccessor;
    }

    public IPreferenceStoreAccess getPreferenceStoreAccessor() {
        return this.preferenceStoreAccessor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fReconciler != null && event.getProperty().contains(".syntaxColorer.tokenStyles")) {
            this.fReconciler.refresh();
        }
    }
}

