/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.confirmation;

import java.util.Set;
import org.eclipse.net4j.util.confirmation.Confirmation;
import org.eclipse.net4j.util.factory.ProductCreationException;

public interface IConfirmationProvider {
    public Confirmation confirm(String var1, String var2, Set<Confirmation> var3, Confirmation var4);

    public boolean isInteractive();

    public static abstract class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.confirmationProviders";
        public static final String DEFAULT_TYPE = "default";
        public static final String INTERACTIVE_TYPE = "interactive";

        public Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        public static class Default
        extends Factory {
            public Default() {
                super(Factory.DEFAULT_TYPE);
            }

            @Override
            public Object create(String description) throws ProductCreationException {
                return new ConfirmationProvider();
            }

            private static final class ConfirmationProvider
            implements IConfirmationProvider {
                private ConfirmationProvider() {
                }

                @Override
                public boolean isInteractive() {
                    return false;
                }

                @Override
                public Confirmation confirm(String subject, String message, Set<Confirmation> acceptable, Confirmation suggestion) {
                    return suggestion != null ? suggestion : this.max(acceptable);
                }

                private Confirmation max(Set<Confirmation> confirmations) {
                    Confirmation[] all = Confirmation.values();
                    int i = all.length - 1;
                    while (i >= 0) {
                        if (confirmations.contains((Object)all[i])) {
                            return all[i];
                        }
                        --i;
                    }
                    return null;
                }
            }
        }
    }

    public static interface Provider {
        public IConfirmationProvider getConfirmationProvider();
    }
}

