/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ui.views;

import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.connector.IServerConnector;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.ui.Net4jItemProvider;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractTransportView
extends ContainerView
implements IElementFilter {
    private IAction newAction;

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new Net4jItemProvider(this){

            public void updateLabels(Object element) {
                super.updateLabels(element);
                if (element instanceof IChannel) {
                    IChannel channel = (IChannel)element;
                    this.updateLabels(channel.getMultiplexer());
                } else if (element instanceof IServerConnector) {
                    IServerConnector connector = (IServerConnector)element;
                    this.updateLabels(connector.getAcceptor());
                }
            }

            protected ContainerItemProvider.LeafNode createLeafNode(ContainerItemProvider.Node parent, Object element) {
                IChannel channel;
                IBufferHandler receiveHandler;
                ContainerItemProvider.LeafNode leafNode = super.createLeafNode(parent, element);
                if (element instanceof IChannel && (receiveHandler = (channel = (IChannel)element).getReceiveHandler()) instanceof IProtocol) {
                    EventUtil.addListener((Object)receiveHandler, (IListener)leafNode);
                }
                return leafNode;
            }

            protected ContainerItemProvider.Node removeNode(Object element) {
                ContainerItemProvider.Node node = super.removeNode(element);
                if (node instanceof ContainerItemProvider.LeafNode) {
                    IChannel channel;
                    IBufferHandler receiveHandler;
                    ContainerItemProvider.LeafNode leafNode = (ContainerItemProvider.LeafNode)node;
                    if (element instanceof IChannel && (receiveHandler = (channel = (IChannel)element).getReceiveHandler()) instanceof IProtocol) {
                        EventUtil.removeListener((Object)receiveHandler, (IListener)leafNode);
                    }
                }
                return node;
            }

            protected void handleElementEvent(IEvent event) {
                super.handleElementEvent(event);
                INotifier source = event.getSource();
                if (source instanceof IProtocol) {
                    IProtocol protocol = (IProtocol)source;
                    this.updateLabels(protocol.getChannel());
                }
            }

            public StyledString getStyledText(Object obj) {
                StyledString styledText = super.getStyledText(obj);
                if (obj instanceof IChannel) {
                    IChannel channel = (IChannel)obj;
                    this.decorateChannel(styledText, channel);
                } else if (obj instanceof IConnector) {
                    IConnector connector = (IConnector)obj;
                    this.decorateConnector(styledText, connector);
                } else if (obj instanceof IAcceptor) {
                    IAcceptor acceptor = (IAcceptor)obj;
                    this.decorateAcceptor(styledText, acceptor);
                }
                return styledText;
            }

            private void decorateChannel(StyledString styledText, IChannel channel) {
                AbstractTransportView.decorateChannelInfraStructure(styledText, channel);
                AbstractTransportView.decorateCounters(styledText, channel.getReceivedBytes(), channel.getSentBytes());
            }

            private void decorateConnector(StyledString styledText, IConnector connector) {
                Collection channels = connector.getChannels();
                if (channels.size() > 1) {
                    long receivedBytes = 0L;
                    long sentBytes = 0L;
                    for (IChannel channel : channels) {
                        receivedBytes += channel.getReceivedBytes();
                        sentBytes += channel.getSentBytes();
                    }
                    AbstractTransportView.decorateCounters(styledText, receivedBytes, sentBytes);
                }
            }

            private void decorateAcceptor(StyledString styledText, IAcceptor acceptor) {
                IConnector[] connectors = acceptor.getAcceptedConnectors();
                if (connectors.length > 1) {
                    long receivedBytes = 0L;
                    long sentBytes = 0L;
                    IConnector[] iConnectorArray = connectors;
                    int n = connectors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConnector connector = iConnectorArray[n2];
                        for (IChannel channel : connector.getChannels()) {
                            receivedBytes += channel.getReceivedBytes();
                            sentBytes += channel.getSentBytes();
                        }
                        ++n2;
                    }
                    AbstractTransportView.decorateCounters(styledText, receivedBytes, sentBytes);
                }
            }
        };
    }

    protected Control createUI(Composite parent) {
        this.newAction = this.createNewAction(this.getShell(), this.getContainer());
        return super.createUI(parent);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.newAction != null) {
            manager.add(this.newAction);
        }
        super.fillLocalToolBar(manager);
    }

    protected abstract IAction createNewAction(Shell var1, IManagedContainer var2);

    static void decorateChannelInfraStructure(StyledString styledText, IChannel channel) {
        IProtocol protocol;
        Object infraStructure;
        IBufferHandler receiveHandler = channel.getReceiveHandler();
        if (receiveHandler instanceof IProtocol && (infraStructure = (protocol = (IProtocol)receiveHandler).getInfraStructure()) != null) {
            styledText.append("  " + infraStructure, StyledString.DECORATIONS_STYLER);
        }
    }

    static void decorateCounters(StyledString styledText, long received, long sent) {
        styledText.append("  \u2190" + received + "  " + sent + "\u2192", StyledString.COUNTER_STYLER);
    }
}

