/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.BaseContainersCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;

public class RestartContainersCommandHandler
extends BaseContainersCommandHandler {
    private static final long DEFAULT_WAIT_TIME = 5L;
    private static final String CONTAINERS_RESTART_MSG = "ContainersRestart.msg";
    private static final String CONTAINER_RESTART_MSG = "ContainerRestart.msg";
    private static final String CONTAINER_RESTART_ERROR_MSG = "ContainerRestartError.msg";

    @Override
    void executeInJob(IDockerContainer container, IDockerConnection connection) {
        try {
            RunConsole console = CommandUtils.getRunConsole(connection, container);
            long waitTime = Platform.getPreferencesService().getLong("org.eclipse.linuxtools.docker.ui", "containerRestartWaitTime", 5L, null);
            if (console != null) {
                console.showConsole();
                ((DockerConnection)connection).restartContainer(container.id(), (int)waitTime, console.getOutputStream());
            } else {
                ((DockerConnection)connection).restartContainer(container.id(), (int)waitTime, null);
            }
            connection.getContainers(true);
        }
        catch (InterruptedException | DockerException e) {
            String errorMessage = DVMessages.getFormattedString(CONTAINER_RESTART_ERROR_MSG, container.id());
            this.openError(errorMessage, (Exception)e);
        }
    }

    @Override
    String getJobName(List<IDockerContainer> selectedContainers) {
        return DVMessages.getString(CONTAINERS_RESTART_MSG);
    }

    @Override
    String getTaskName(IDockerContainer container) {
        return DVMessages.getFormattedString(CONTAINER_RESTART_MSG, container.name());
    }
}

