import { Range, Position } from 'vscode-languageserver-types';
export declare const KEYWORDS: string[];
export declare class Util {
    static isWhitespace(char: string): boolean;
    static isNewline(char: string): boolean;
    /**
     * Determines if the given position is contained within the given range.
     *
     * @param position the position to check
     * @param range the range to see if the position is inside of
     */
    static isInsideRange(position: Position, range: Range): boolean;
    static rangeEquals(range: Range, range2: Range): boolean;
    static positionEquals(position: Position, position2: Position): boolean;
    static positionBefore(origin: Position, other: Position): boolean;
}
