/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TableModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AddRemoveListPane<T extends Model, E>
extends AddRemovePane<T, E> {
    private Table table;

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter<E> adapter, ListValueModel<?> listHolder, ModifiableCollectionValueModel<E> selectedItemsModel, ILabelProvider labelProvider) {
        super(parentPane, parent, adapter, listHolder, selectedItemsModel, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter<E> adapter, ListValueModel<?> listHolder, ModifiableCollectionValueModel<E> selectedItemsModel, ILabelProvider labelProvider, String helpId) {
        super(parentPane, parent, adapter, listHolder, selectedItemsModel, (IBaseLabelProvider)labelProvider, helpId);
    }

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter<E> adapter, ListValueModel<?> listHolder, ModifiableCollectionValueModel<E> selectedItemsModel, ILabelProvider labelProvider, PropertyValueModel<Boolean> enabledModel, String helpId) {
        super(parentPane, parent, adapter, listHolder, selectedItemsModel, (IBaseLabelProvider)labelProvider, enabledModel, helpId);
    }

    public AddRemoveListPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter<E> adapter, ListValueModel<?> listHolder, ModifiableCollectionValueModel<E> selectedItemsModel, ILabelProvider labelProvider) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemsModel, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveListPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter<E> adapter, ListValueModel<?> listHolder, ModifiableCollectionValueModel<E> selectedItemsModel, ILabelProvider labelProvider, String helpId) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemsModel, (IBaseLabelProvider)labelProvider, helpId);
    }

    private ColumnAdapter<E> buildColumnAdapter() {
        return new ColumnAdapter<E>(){

            @Override
            public ModifiablePropertyValueModel<?>[] cellModels(E subject) {
                ModifiablePropertyValueModel[] valueHolders = new ModifiablePropertyValueModel[]{new SimplePropertyValueModel(subject)};
                return valueHolders;
            }

            @Override
            public int columnCount() {
                return 1;
            }

            @Override
            public String columnName(int columnIndex) {
                return "";
            }
        };
    }

    @Override
    protected void itemsAdded(ListAddEvent e) {
        super.itemsAdded(e);
        this.revalidateLayout();
    }

    @Override
    protected void itemsMoved(ListMoveEvent e) {
        super.itemsMoved(e);
        this.revalidateLayout();
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent e) {
        super.itemsRemoved(e);
        this.revalidateLayout();
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent e) {
        super.itemsReplaced(e);
        this.revalidateLayout();
    }

    @Override
    protected void listChanged(ListChangeEvent e) {
        super.listChanged(e);
        this.revalidateLayout();
    }

    @Override
    protected void listCleared(ListClearEvent e) {
        super.listCleared(e);
        this.revalidateLayout();
    }

    private void revalidateLayout() {
        DisplayTools.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AddRemoveListPane.this.table.isDisposed()) {
                    AddRemoveListPane.this.table.getParent().computeSize(-1, -1);
                    AddRemoveListPane.this.table.getParent().layout();
                }
            }
        });
    }

    private Composite addTableContainer(Composite container) {
        container = this.addPane(container, this.buildTableContainerLayout());
        container.setLayoutData((Object)new GridData(1808));
        return container;
    }

    private Layout buildTableContainerLayout() {
        return new Layout(){

            protected Point computeSize(Composite composite, int widthHint, int heightHint, boolean flushCache) {
                Table table = (Table)composite.getChildren()[0];
                TableColumn tableColumn = table.getColumn(0);
                int columnWidth = tableColumn.getWidth();
                this.packColumn(table);
                Point size = table.computeSize(-1, -1);
                if (widthHint != -1) {
                    size.x = widthHint;
                }
                if (heightHint != -1) {
                    size.y = heightHint;
                }
                table.setRedraw(false);
                table.setLayoutDeferred(true);
                tableColumn.setWidth(columnWidth);
                table.setLayoutDeferred(false);
                table.setRedraw(true);
                return size;
            }

            private boolean isVerticalScrollbarBarVisible(Table table, Rectangle clientArea) {
                int height = table.getItemCount() * table.getItemHeight();
                return clientArea.height < (height += table.getBorderWidth() << 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle bounds = composite.getClientArea();
                if (bounds.width > 0) {
                    Table table = (Table)composite.getChildren()[0];
                    table.setBounds(0, 0, bounds.width, bounds.height);
                    this.updateTableColumnWidth(table, bounds.width, this.isVerticalScrollbarBarVisible(table, bounds));
                }
            }

            private void packColumn(Table table) {
                TableColumn tableColumn = table.getColumn(0);
                table.setRedraw(false);
                table.setLayoutDeferred(true);
                tableColumn.pack();
                table.setLayoutDeferred(false);
                table.setRedraw(true);
                table.setData("column.width", (Object)tableColumn.getWidth());
            }

            private void updateTableColumnWidth(Table table, int width, boolean verticalScrollbarBarVisible) {
                width -= table.getBorderWidth() << 1;
                if (verticalScrollbarBarVisible) {
                    width -= table.getVerticalBar().getSize().x;
                }
                TableColumn tableColumn = table.getColumn(0);
                Integer columnWitdh = (Integer)table.getData("column.width");
                width = Math.max(width, columnWitdh);
                tableColumn.setWidth(width);
            }
        };
    }

    private ITableLabelProvider buildTableLabelProvider(IBaseLabelProvider labelProvider) {
        return new TableLabelProvider((ILabelProvider)labelProvider);
    }

    public Table getMainControl() {
        return this.table;
    }

    @Override
    protected void initializeMainComposite(Composite container, AddRemovePane.Adapter<E> adapter, ListValueModel<?> listHolder, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider, String helpId) {
        this.table = this.addTable(this.addTableContainer(container), 66306, helpId);
        TableModelAdapter.adapt(listHolder, this.getSelectedItemsModel(), this.table, this.buildColumnAdapter(), this.buildTableLabelProvider(labelProvider));
        this.initializeTable(this.table);
    }

    protected void initializeTable(Table table) {
        table.setData("column.width", (Object)0);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        Composite container = table.getParent();
        GridData gridData = (GridData)container.getLayoutData();
        gridData.heightHint = 75;
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ILabelProvider labelProvider;

        TableLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.labelProvider.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.labelProvider.getText(element);
        }
    }
}

