/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import java.io.Serializable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.jface.PluggableTextTableLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.swt.graphics.Image;

public class ResourceManagerTableLabelProvider<E>
extends PluggableTextTableLabelProvider<E> {
    private volatile ImageDescriptorTransformer<E> imageDescriptorTransformer;
    private final ResourceManager resourceManager;

    public ResourceManagerTableLabelProvider() {
        this(JFaceResources.getResources());
    }

    public ResourceManagerTableLabelProvider(ResourceManager resourceManager) {
        this(DefaultImageDescriptorTransformer.instance(), resourceManager);
    }

    public ResourceManagerTableLabelProvider(ImageDescriptorTransformer<E> imageDescriptorTransformer, ResourceManager resourceManager) {
        this(imageDescriptorTransformer, PluggableTextTableLabelProvider.DefaultTextTransformer.instance(), resourceManager);
    }

    public ResourceManagerTableLabelProvider(ImageDescriptorTransformer<E> imageDescriptorTransformer, PluggableTextTableLabelProvider.TextTransformer<E> textTransformer, ResourceManager resourceManager) {
        super(textTransformer);
        if (imageDescriptorTransformer == null || resourceManager == null) {
            throw new NullPointerException();
        }
        this.imageDescriptorTransformer = imageDescriptorTransformer;
        this.resourceManager = new LocalResourceManager(resourceManager);
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        ImageDescriptor imageDescriptor = this.getColumnImageDescriptor(element, columnIndex);
        return imageDescriptor == null ? null : this.resourceManager.createImage(imageDescriptor);
    }

    private ImageDescriptor getColumnImageDescriptor(Object element, int columnIndex) {
        return this.imageDescriptorTransformer.transform(element, columnIndex);
    }

    public void setImageDescriptorTransformer(ImageDescriptorTransformer<E> imageDescriptorTransformer) {
        if (imageDescriptorTransformer == null) {
            throw new NullPointerException();
        }
        this.imageDescriptorTransformer = imageDescriptorTransformer;
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    public static class DefaultImageDescriptorTransformer<E>
    implements ImageDescriptorTransformer<E>,
    Serializable {
        public static final ImageDescriptorTransformer<?> INSTANCE = new DefaultImageDescriptorTransformer();
        private static final long serialVersionUID = 1L;

        public static <R> ImageDescriptorTransformer<R> instance() {
            return INSTANCE;
        }

        private DefaultImageDescriptorTransformer() {
        }

        @Override
        public ImageDescriptor transform(E element, int columnIndex) {
            return null;
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static interface ImageDescriptorTransformer<E>
    extends PluggableTextTableLabelProvider.Transformer<E, ImageDescriptor> {
        @Override
        public ImageDescriptor transform(E var1, int var2);
    }
}

