/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.branch.CDODuplicateBranchException;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.AuthorizationException;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.common.util.CurrentTimeProvider;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.CommitManager;
import org.eclipse.emf.cdo.internal.server.InstancesQueryHandler;
import org.eclipse.emf.cdo.internal.server.LockingManager;
import org.eclipse.emf.cdo.internal.server.QueryManager;
import org.eclipse.emf.cdo.internal.server.ResourcesQueryHandler;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.TimeStampAuthority;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.UnitManager;
import org.eclipse.emf.cdo.internal.server.XRefsQueryHandler;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IQueryHandlerProvider;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationInfo;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.BaseCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.common.util.CoreOperations;
import org.eclipse.emf.cdo.spi.server.ContainerQueryHandlerProvider;
import org.eclipse.emf.cdo.spi.server.ICommitConflictResolver;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalCommitManager;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalUnitManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.object.CDOFactoryImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;
import org.eclipse.net4j.util.security.operations.OperationAuthorizer;
import org.eclipse.net4j.util.transaction.TransactionException;

public class Repository
extends Container<Object>
implements InternalRepository {
    private static final List<CDOLockDelta> NO_LOCK_DELTAS = Collections.emptyList();
    private static final List<CDOLockState> NO_LOCK_STATES = Collections.emptyList();
    private static final int UNCHUNKED = -1;
    private static final int NONE = 0;
    private static final String PROP_UUID = "org.eclipse.emf.cdo.server.repositoryUUID";
    private static final Map<String, Repository> REPOSITORIES = new HashMap<String, Repository>();
    private static final boolean DISABLE_LOGIN_PEEKS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.internal.server.Repository.DISABLE_LOGIN_PEEKS");
    private static final String PROP_DISABLE_FEATURE_MAP_CHECKS = "org.eclipse.emf.cdo.internal.server.Repository.DISABLE_FEATURE_MAP_CHECKS";
    private static final boolean DISABLE_FEATURE_MAP_CHECKS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.internal.server.Repository.DISABLE_FEATURE_MAP_CHECKS");
    private static final boolean ENABLE_FEATURE_MAP_CHECKS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.internal.server.Repository.ENABLE_FEATURE_MAP_CHECKS");
    private static boolean featureMapsChecked;
    private String name;
    private String uuid;
    private InternalStore store;
    private CDOCommonRepository.Type type = CDOCommonRepository.Type.MASTER;
    private CDOCommonRepository.State state = CDOCommonRepository.State.INITIAL;
    private Object[] elements = new Object[0];
    private final IRegistry<String, Object> propertiesContainer = new HashMapRegistry.AutoCommit();
    private Map<String, String> properties;
    private boolean supportingLoginPeeks = !DISABLE_LOGIN_PEEKS;
    private boolean supportingAudits;
    private boolean supportingBranches;
    private boolean supportingUnits;
    private boolean serializingCommits;
    private boolean ensuringReferentialIntegrity;
    private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
    private CDOCommonRepository.CommitInfoStorage commitInfoStorage;
    private long optimisticLockingTimeout = 10000L;
    private CDOTimeProvider timeProvider;
    private final Semaphore packageRegistryCommitLock = new Semaphore(1);
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDOBranchManager branchManager;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;
    private ICommitConflictResolver commitConflictResolver;
    private InternalSessionManager sessionManager;
    private InternalQueryManager queryManager;
    private InternalCommitManager commitManager;
    private InternalLockManager lockingManager;
    private InternalUnitManager unitManager;
    private IQueryHandlerProvider queryHandlerProvider;
    private IRepositoryProtector protector;
    private List<OperationAuthorizer<ISession>> operationAuthorizers = new ArrayList<OperationAuthorizer<ISession>>();
    private IManagedContainer container;
    private final List<IRepository.ReadAccessHandler> readAccessHandlers = new ArrayList<IRepository.ReadAccessHandler>();
    private final List<IRepository.WriteAccessHandler> writeAccessHandlers = new ArrayList<IRepository.WriteAccessHandler>();
    private final TimeStampAuthority timeStampAuthority = new TimeStampAuthority(this);
    @ReflectUtil.ExcludeFromDump
    private final transient Object commitTransactionLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private final transient ReadWriteLock branchingLock = new ReentrantReadWriteLock();
    private boolean skipInitialization;
    private EPackage[] initialPackages;
    private CDOID rootResourceID;
    private long lastTreeRestructuringCommit = -1L;
    private CDOBranchManager.CDOTagList tagList;

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getUUID() {
        return this.uuid;
    }

    @Override
    public InternalStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(InternalStore store) {
        this.store = store;
    }

    public CDOCommonRepository.Type getType() {
        return this.type;
    }

    @Override
    public void setType(CDOCommonRepository.Type type) {
        this.checkArg(type, "type");
        if (this.type != type) {
            this.changingType(this.type, type);
        }
    }

    protected void changingType(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.type = newType;
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryTypeNotification(oldType, newType);
        }
    }

    public CDOCommonRepository.State getState() {
        return this.state;
    }

    @Override
    public void setState(CDOCommonRepository.State state) {
        this.checkArg(state, "state");
        if (this.state != state) {
            this.changingState(this.state, state);
        }
    }

    protected void changingState(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.state = newState;
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryStateNotification(oldState, newState, this.getRootResourceID());
        }
    }

    public boolean waitWhileInitial(IProgressMonitor monitor) {
        return CDOCommonUtil.waitWhileInitial((CDOCommonRepository)this, (INotifier)this, (IProgressMonitor)monitor);
    }

    public IRegistry<String, Object> properties() {
        return this.propertiesContainer;
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isAuthenticating() {
        if (this.sessionManager != null) {
            return this.sessionManager.getAuthenticator() != null;
        }
        return false;
    }

    public boolean isSupportingLoginPeeks() {
        return this.supportingLoginPeeks;
    }

    public boolean isSupportingAudits() {
        return this.supportingAudits;
    }

    public boolean isSupportingBranches() {
        return this.supportingBranches;
    }

    public boolean isSupportingUnits() {
        return this.supportingUnits;
    }

    public boolean isSerializingCommits() {
        return this.serializingCommits;
    }

    public boolean isEnsuringReferentialIntegrity() {
        return this.ensuringReferentialIntegrity;
    }

    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return this.idGenerationLocation;
    }

    public CDOCommonRepository.CommitInfoStorage getCommitInfoStorage() {
        return this.commitInfoStorage;
    }

    @Override
    public long getOptimisticLockingTimeout() {
        return this.optimisticLockingTimeout;
    }

    @Override
    public void setOptimisticLockingTimeout(long optimisticLockingTimeout) {
        this.optimisticLockingTimeout = optimisticLockingTimeout;
    }

    public String getStoreType() {
        return this.store.getType();
    }

    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return this.store.getObjectIDTypes();
    }

    public CDOID getRootResourceID() {
        return this.rootResourceID;
    }

    @Override
    public void setRootResourceID(CDOID rootResourceID) {
        this.rootResourceID = rootResourceID;
    }

    public Object processPackage(Object value) {
        CDOFactoryImpl.prepareDynamicEPackage((Object)value);
        return value;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadPackageUnit((InternalCDOPackageUnit)packageUnit);
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (!this.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported by " + this);
        }
        long baseTimeStamp = branchInfo.getBaseTimeStamp();
        long baseTimeStampMax = this.timeStampAuthority.getMaxBaseTimeForNewBranch();
        if (baseTimeStamp == 0L || baseTimeStamp > baseTimeStampMax) {
            baseTimeStamp = baseTimeStampMax;
            branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(branchInfo.getName(), branchInfo.getBaseBranchID(), baseTimeStamp);
        }
        Lock writeLock = this.branchingLock.writeLock();
        writeLock.lock();
        try {
            this.authorizeOperation(CoreOperations.createBranch((int)branchID, (String)branchInfo.getName(), (int)branchInfo.getBaseBranchID(), (long)branchInfo.getBaseTimeStamp()));
            this.checkDuplicateBranchBase(branchInfo.getBaseBranchID(), branchInfo.getName());
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            Pair pair = accessor.createBranch(branchID, branchInfo);
            return pair;
        }
        finally {
            writeLock.unlock();
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranches(startID, endID, branchHandler);
    }

    public CDOBranch[] deleteBranches(int branchID, OMMonitor monitor) {
        if (!this.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported by " + this);
        }
        if (branchID == 0) {
            throw new IllegalArgumentException("Deleting the MAIN branch is not supported");
        }
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (!(accessor instanceof InternalCDOBranchManager.BranchLoader5)) {
            throw new UnsupportedOperationException("Branch deletion is not supported by " + this);
        }
        Lock writeLock = this.branchingLock.writeLock();
        writeLock.lock();
        try {
            CDOBranchUtil.forEachBranchInTree((CDOBranch)this.getBranchManager().getBranch(branchID), b -> this.authorizeOperation(CoreOperations.deleteBranch((int)b.getID())));
            CDOBranch[] branches = ((InternalCDOBranchManager.BranchLoader5)accessor).deleteBranches(branchID, monitor);
            InternalSession[] internalSessionArray = this.sessionManager.getSessions();
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                InternalView[] internalViewArray = session.getViews();
                int n3 = internalViewArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalView view = internalViewArray[n4];
                    CDOBranch viewBranch = view.getBranch();
                    CDOBranch[] cDOBranchArray = branches;
                    int n5 = branches.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        CDOBranch branch = cDOBranchArray[n6];
                        if (viewBranch == branch) {
                            view.close();
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            InternalCDORevisionCache revisionCache = this.getRevisionManager().getCache();
            revisionCache.removeRevisions(branches);
            CDOBranch[] cDOBranchArray = branches;
            return cDOBranchArray;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void renameBranch(int branchID, String oldName, String newName) throws CDODuplicateBranchException {
        if (!this.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported by " + this);
        }
        if (branchID == 0) {
            throw new IllegalArgumentException("Renaming the MAIN branch is not supported");
        }
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (!(accessor instanceof InternalCDOBranchManager.BranchLoader3)) {
            throw new UnsupportedOperationException("Branch renaming is not supported by " + this);
        }
        Lock writeLock = this.branchingLock.writeLock();
        writeLock.lock();
        try {
            this.authorizeOperation(CoreOperations.renameBranch((int)branchID, (String)newName));
            this.checkDuplicateBranch(branchID, newName);
            ((InternalCDOBranchManager.BranchLoader3)accessor).renameBranch(branchID, oldName, newName);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void checkDuplicateBranch(int branchID, String name) throws CDODuplicateBranchException {
        InternalCDOBranch branch = this.branchManager.getBranch(branchID);
        CDOBranch baseBranch = branch.getBase().getBranch();
        int baseBranchID = baseBranch.getID();
        this.checkDuplicateBranchBase(baseBranchID, name);
    }

    private void checkDuplicateBranchBase(int baseBranchID, String name) throws CDODuplicateBranchException {
        InternalCDOBranch baseBranch = this.branchManager.getBranch(baseBranchID);
        CDOBranch existingBranch = baseBranch.getBranch(name);
        if (existingBranch != null && !existingBranch.isDeleted()) {
            throw new CDODuplicateBranchException(existingBranch);
        }
    }

    public CDOBranchPoint changeTag(AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        IStoreAccessor accessor;
        if (this.isSupportingAudits() && (accessor = StoreThreadLocal.getAccessor()) instanceof InternalCDOBranchManager.BranchLoader4) {
            Lock writeLock = this.branchingLock.writeLock();
            writeLock.lock();
            try {
                if (oldName == null && branchPoint == null) {
                    branchPoint = this.branchManager.getMainBranch().getHead();
                }
                if (branchPoint != null && branchPoint.getTimeStamp() == 0L) {
                    branchPoint = branchPoint.getBranch().getPoint(this.getTimeStamp());
                }
                switch (InternalCDOBranchManager.getTagChangeKind((String)oldName, (String)newName, (CDOBranchPoint)branchPoint)) {
                    case CREATED: {
                        this.authorizeOperation(CoreOperations.createTag((String)newName, (int)branchPoint.getBranch().getID(), (long)branchPoint.getTimeStamp()));
                        break;
                    }
                    case RENAMED: {
                        this.authorizeOperation(CoreOperations.renameTag((String)oldName, (String)newName));
                        break;
                    }
                    case MOVED: {
                        this.authorizeOperation(CoreOperations.moveTag((String)oldName, (int)branchPoint.getBranch().getID(), (long)branchPoint.getTimeStamp()));
                        break;
                    }
                    case DELETED: {
                        this.authorizeOperation(CoreOperations.deleteTag((String)oldName));
                    }
                }
                ((InternalCDOBranchManager.BranchLoader4)accessor).changeTag(modCount, oldName, newName, branchPoint);
                InternalSession sender = null;
                try {
                    sender = StoreThreadLocal.getSession();
                }
                catch (StoreThreadLocal.NoSessionRegisteredException noSessionRegisteredException) {
                    // empty catch block
                }
                int newModCount = modCount.get() + 1;
                this.sessionManager.sendTagNotification(sender, newModCount, oldName, newName, branchPoint);
                CDOBranchPoint cDOBranchPoint = branchPoint;
                return cDOBranchPoint;
            }
            finally {
                writeLock.unlock();
            }
        }
        throw new UnsupportedOperationException("Branch tagging is not supported by " + this);
    }

    public void loadTags(String name, Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler) {
        IStoreAccessor accessor;
        if (this.isSupportingAudits() && (accessor = StoreThreadLocal.getAccessor()) instanceof InternalCDOBranchManager.BranchLoader4) {
            ((InternalCDOBranchManager.BranchLoader4)accessor).loadTags(name, handler);
        }
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.loadCommitInfos(branch, startTime, endTime, handler);
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadCommitData(timeStamp);
    }

    public List<RevisionInfo> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean prefetchLockStates) {
        block6: for (RevisionInfo info : infos) {
            CDOID id = info.getID();
            RevisionInfo.Type type = info.getType();
            switch (type) {
                case AVAILABLE_NORMAL: {
                    RevisionInfo.Available.Normal availableInfo = (RevisionInfo.Available.Normal)info;
                    this.checkArg(!availableInfo.isDirect(), "Load is not needed");
                    break;
                }
                case AVAILABLE_POINTER: {
                    RevisionInfo.Available.Pointer pointerInfo = (RevisionInfo.Available.Pointer)info;
                    boolean needsTarget = !pointerInfo.hasTarget();
                    this.checkArg(!pointerInfo.isDirect() || needsTarget, "Load is not needed");
                    if (!needsTarget) break;
                    CDOBranchVersion targetBranchVersion = pointerInfo.getTargetBranchVersion();
                    InternalCDORevision target = this.loadRevisionByVersion(id, targetBranchVersion, referenceChunk);
                    PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, pointerInfo.getAvailableBranchVersion().getBranch(), 0L, (CDOBranchVersion)target);
                    info.setResult(target);
                    info.setSynthetic((SyntheticCDORevision)pointer);
                    continue block6;
                }
                case AVAILABLE_DETACHED: {
                    RevisionInfo.Available.Detached detachedInfo = (RevisionInfo.Available.Detached)info;
                    this.checkArg(!detachedInfo.isDirect(), "Load is not needed");
                    break;
                }
                case MISSING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid revision info type: " + type);
                }
            }
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) {
                if (this.isSupportingAudits()) {
                    InternalCDORevision target = this.loadRevisionTarget(id, branchPoint, referenceChunk, accessor);
                    if (target != null) {
                        target = this.normalizeRevision(target, info, referenceChunk);
                        CDOBranch branch = branchPoint.getBranch();
                        long revised = this.loadRevisionRevised(id, branch);
                        PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, branch, revised, (CDOBranchVersion)target);
                        info.setSynthetic((SyntheticCDORevision)pointer);
                    }
                    info.setResult(target);
                    continue;
                }
                DetachedCDORevision detachedRevision = new DetachedCDORevision(EcorePackage.Literals.ECLASS, id, branchPoint.getBranch(), 0, 0L);
                info.setSynthetic((SyntheticCDORevision)detachedRevision);
                continue;
            }
            if (revision instanceof DetachedCDORevision) {
                DetachedCDORevision detached = (DetachedCDORevision)revision;
                info.setSynthetic((SyntheticCDORevision)detached);
                continue;
            }
            revision.freeze();
            revision = this.normalizeRevision(revision, info, referenceChunk);
            info.setResult(revision);
        }
        return null;
    }

    private InternalCDORevision normalizeRevision(InternalCDORevision revision, RevisionInfo info, int referenceChunk) {
        BaseCDORevision availableRevision;
        RevisionInfo.Available availableInfo;
        CDOBranchVersion availableBranchVersion;
        if (info instanceof RevisionInfo.Available && (availableBranchVersion = (availableInfo = (RevisionInfo.Available)info).getAvailableBranchVersion()) instanceof BaseCDORevision && (availableRevision = (BaseCDORevision)availableBranchVersion).equals((Object)revision)) {
            this.ensureChunks((InternalCDORevision)availableRevision, referenceChunk);
            return availableRevision;
        }
        if (referenceChunk == -1) {
            revision.setUnchunked();
        }
        return revision;
    }

    private InternalCDORevision loadRevisionTarget(CDOID id, CDOBranchPoint branchPoint, int referenceChunk, IStoreAccessor accessor) {
        CDOBranch branch = branchPoint.getBranch();
        while (!branch.isMainBranch()) {
            branchPoint = branch.getBase();
            branch = branchPoint.getBranch();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) continue;
            revision.freeze();
            return revision;
        }
        return null;
    }

    private long loadRevisionRevised(CDOID id, CDOBranch branch) {
        InternalCDORevision revision = this.loadRevisionByVersion(id, branch.getVersion(1), -1);
        if (revision != null) {
            return revision.getTimeStamp() - 1L;
        }
        return 0L;
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.readRevisionByVersion(id, branchVersion, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
    }

    public CDOBranchPointRange loadObjectLifetime(CDOID id, CDOBranchPoint branchPoint) {
        InternalCDORevision revision = this.revisionManager.getRevision(id, branchPoint, -1, 0, true);
        if (revision == null) {
            return null;
        }
        CDORevision firstRevision = this.getFirstRevision(id, (CDORevision)revision);
        if (firstRevision == null) {
            return null;
        }
        CDOBranchPoint lastPoint = this.getLastBranchPoint((CDORevision)revision, branchPoint);
        return CDOBranchUtil.createRange((CDOBranchPoint)firstRevision, (CDOBranchPoint)lastPoint);
    }

    private CDORevision getFirstRevision(CDOID id, CDORevision revision) {
        CDOBranchPoint base;
        InternalCDORevision baseRevision;
        CDOBranch branch = revision.getBranch();
        int version = revision.getVersion() - 1;
        while (version >= 1) {
            InternalCDORevision rev = this.revisionManager.getRevisionByVersion(id, branch.getVersion(version), -1, true);
            if (rev == null) {
                return revision;
            }
            revision = rev;
            --version;
        }
        if (!branch.isMainBranch() && (baseRevision = this.revisionManager.getRevision(id, base = branch.getBase(), -1, 0, true)) != null) {
            return this.getFirstRevision(id, (CDORevision)baseRevision);
        }
        return revision;
    }

    private CDOBranchPoint getLastBranchPoint(CDORevision revision, CDOBranchPoint branchPoint) {
        CDOBranch branch = branchPoint.getBranch();
        if (revision.getBranch() != branch) {
            return branch.getHead();
        }
        CDOID id = revision.getID();
        int version = revision.getVersion() + 1;
        while (version <= Integer.MAX_VALUE) {
            InternalCDORevision rev;
            if (revision.getRevised() == 0L || (rev = this.revisionManager.getRevisionByVersion(id, branch.getVersion(version), -1, true)) == null) break;
            revision = rev;
            ++version;
        }
        return branch.getPoint(revision.getRevised());
    }

    @Deprecated
    protected void ensureChunks(InternalCDORevision revision, int referenceChunk, IStoreAccessor accessor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureChunks(InternalCDORevision revision) {
        this.ensureChunks(revision, -1);
    }

    public void ensureChunks(InternalCDORevision revision, int chunkSize) {
        if (revision.isUnchunked()) {
            return;
        }
        IStoreAccessor accessor = null;
        boolean unchunked = true;
        EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            int size;
            CDOList list;
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany() && (list = revision.getListOrNull(feature)) != null && (size = list.size()) != 0) {
                int chunkSizeToUse = chunkSize;
                if (chunkSizeToUse == -1) {
                    chunkSizeToUse = size;
                }
                int chunkEnd = Math.min(chunkSizeToUse, size);
                accessor = this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, 0, chunkEnd);
                if (unchunked) {
                    int i = chunkEnd;
                    while (i < size) {
                        if (list.get(i) == InternalCDOList.UNINITIALIZED) {
                            unchunked = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            ++n2;
        }
        if (unchunked) {
            revision.setUnchunked();
        }
    }

    @Override
    public IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, int chunkStart, int chunkEnd) {
        if (!revision.isUnchunked()) {
            CDOList list = revision.getListOrNull(feature);
            if (list == null) {
                return null;
            }
            chunkEnd = Math.min(chunkEnd, list.size());
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, chunkStart, chunkEnd);
            if (this.isUnchunked(revision)) {
                revision.setUnchunked();
            }
            return accessor;
        }
        return null;
    }

    private boolean isUnchunked(InternalCDORevision revision) {
        EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOList list;
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany() && (list = revision.getListOrNull(feature)) != null) {
                int size = list.size();
                int i = 0;
                while (i < size) {
                    if (list.get(i) == InternalCDOList.UNINITIALIZED) {
                        return false;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return true;
    }

    protected IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, IStoreAccessor accessor, MoveableList<Object> list, int chunkStart, int chunkEnd) {
        IStoreChunkReader chunkReader = null;
        int fromIndex = -1;
        int j = chunkStart;
        while (j < chunkEnd) {
            if (list.get(j) == InternalCDOList.UNINITIALIZED) {
                if (fromIndex == -1) {
                    fromIndex = j;
                }
            } else if (fromIndex != -1) {
                int toIndex;
                if (chunkReader == null) {
                    if (accessor == null) {
                        accessor = StoreThreadLocal.getAccessor();
                    }
                    chunkReader = accessor.createChunkReader(revision, feature);
                }
                if (fromIndex == (toIndex = j) - 1) {
                    chunkReader.addSimpleChunk(fromIndex);
                } else {
                    chunkReader.addRangedChunk(fromIndex, toIndex);
                }
                fromIndex = -1;
            }
            ++j;
        }
        if (fromIndex != -1) {
            int toIndex;
            if (chunkReader == null) {
                if (accessor == null) {
                    accessor = StoreThreadLocal.getAccessor();
                }
                chunkReader = accessor.createChunkReader(revision, feature);
            }
            if (fromIndex == (toIndex = chunkEnd) - 1) {
                chunkReader.addSimpleChunk(fromIndex);
            } else {
                chunkReader.addRangedChunk(fromIndex, toIndex);
            }
        }
        if (chunkReader != null) {
            InternalCDOList cdoList = list instanceof InternalCDOList ? (InternalCDOList)list : null;
            List<IStoreChunkReader.Chunk> chunks = chunkReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : chunks) {
                int startIndex = chunk.getStartIndex();
                int indexInChunk = 0;
                while (indexInChunk < chunk.size()) {
                    Object id = chunk.get(indexInChunk);
                    if (cdoList != null) {
                        cdoList.setWithoutFrozenCheck(startIndex + indexInChunk, id);
                    } else {
                        list.set(startIndex + indexInChunk, id);
                    }
                    ++indexInChunk;
                }
            }
        }
        return accessor;
    }

    @Override
    public CDOTimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @Override
    public void setTimeProvider(CDOTimeProvider timeProvider) {
        this.checkInactive();
        this.timeProvider = timeProvider;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry(boolean considerCommitContext) {
        InternalCDOPackageRegistry contextualPackageRegistry;
        IStoreAccessor.CommitContext commitContext;
        if (considerCommitContext && (commitContext = StoreThreadLocal.getCommitContext()) != null && (contextualPackageRegistry = commitContext.getPackageRegistry()) != null) {
            return contextualPackageRegistry;
        }
        return this.packageRegistry;
    }

    @Override
    public Semaphore getPackageRegistryCommitLock() {
        return this.packageRegistryCommitLock;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.getPackageRegistry(true);
    }

    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.checkInactive();
        this.packageRegistry = packageRegistry;
    }

    @Override
    public InternalSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(InternalSessionManager sessionManager) {
        this.checkInactive();
        this.sessionManager = sessionManager;
    }

    @Override
    public InternalUnitManager getUnitManager() {
        return this.unitManager;
    }

    @Override
    public void setUnitManager(InternalUnitManager unitManager) {
        this.checkInactive();
        this.unitManager = unitManager;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public void setBranchManager(InternalCDOBranchManager branchManager) {
        this.checkInactive();
        this.branchManager = branchManager;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    public void setCommitInfoManager(InternalCDOCommitInfoManager commitInfoManager) {
        this.checkInactive();
        this.commitInfoManager = commitInfoManager;
    }

    @Override
    public ICommitConflictResolver getCommitConflictResolver() {
        return this.commitConflictResolver;
    }

    @Override
    public void setCommitConflictResolver(ICommitConflictResolver commitConflictResolver) {
        this.checkInactive();
        this.commitConflictResolver = commitConflictResolver;
    }

    @Override
    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public void setRevisionManager(InternalCDORevisionManager revisionManager) {
        this.checkInactive();
        this.revisionManager = revisionManager;
    }

    @Override
    public InternalQueryManager getQueryManager() {
        return this.queryManager;
    }

    public void setQueryManager(InternalQueryManager queryManager) {
        this.checkInactive();
        this.queryManager = queryManager;
    }

    @Override
    public InternalCommitManager getCommitManager() {
        return this.commitManager;
    }

    public void setCommitManager(InternalCommitManager commitManager) {
        this.checkInactive();
        this.commitManager = commitManager;
    }

    @Override
    public InternalLockManager getLockingManager() {
        return this.lockingManager;
    }

    public void setLockingManager(InternalLockManager lockingManager) {
        this.checkInactive();
        this.lockingManager = lockingManager;
    }

    @Override
    public IRepositoryProtector getProtector() {
        return this.protector;
    }

    @Override
    public void setProtector(IRepositoryProtector protector) {
        if (!Repository.isSecurityManagerWrapper(protector)) {
            this.checkInactive();
        }
        this.protector = protector;
    }

    @Override
    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        return new TransactionCommitContext(transaction);
    }

    @Override
    public long getLastCommitTimeStamp() {
        return this.timeStampAuthority.getLastFinishedTimeStamp();
    }

    @Override
    public void setLastCommitTimeStamp(long lastCommitTimeStamp) {
        this.timeStampAuthority.setLastFinishedTimeStamp(lastCommitTimeStamp);
    }

    @Override
    public long waitForCommit(long timeout) {
        return this.timeStampAuthority.waitForCommit(timeout);
    }

    @Override
    public long[] createCommitTimeStamp(OMMonitor monitor) {
        return this.timeStampAuthority.startCommit(0L, monitor);
    }

    @Override
    public long[] forceCommitTimeStamp(long override, OMMonitor monitor) {
        return this.timeStampAuthority.startCommit(override, monitor);
    }

    @Override
    public void endCommit(long timestamp) {
        this.timeStampAuthority.endCommit(timestamp);
    }

    @Override
    public void failCommit(long timestamp) {
        this.timeStampAuthority.failCommit(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOutsideStartCommit(Runnable runnable) {
        TimeStampAuthority timeStampAuthority = this.timeStampAuthority;
        synchronized (timeStampAuthority) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(InternalCommitContext commitContext, OMMonitor monitor) {
        block17: {
            if (!DISABLE_FEATURE_MAP_CHECKS) {
                InternalCDORevision[] newObjects = commitContext.getNewObjects();
                if (newObjects != null && newObjects.length != 0) {
                    int i = 0;
                    while (i < newObjects.length) {
                        InternalCDORevision revision = newObjects[i];
                        if (revision.getClassInfo().hasPersistentFeatureMaps()) {
                            throw new CDOException(revision + " contains a feature map");
                        }
                        ++i;
                    }
                }
                if (!featureMapsChecked) {
                    featureMapsChecked = true;
                    if (!ENABLE_FEATURE_MAP_CHECKS) {
                        OM.LOG.info("If no model contains feature maps commit performance can be slightly increased by specifying -Dorg.eclipse.emf.cdo.internal.server.Repository.DISABLE_FEATURE_MAP_CHECKS=true");
                    }
                }
            }
            Lock readLock = this.branchingLock.readLock();
            readLock.lock();
            try {
                if (commitContext.isTreeRestructuring()) {
                    Object object = this.commitTransactionLock;
                    synchronized (object) {
                        commitContext.setLastTreeRestructuringCommit(this.lastTreeRestructuringCommit);
                        this.commitUnsynced(commitContext, monitor);
                        this.lastTreeRestructuringCommit = commitContext.getTimeStamp();
                        break block17;
                    }
                }
                if (this.serializingCommits) {
                    Object object = this.commitTransactionLock;
                    synchronized (object) {
                        this.commitUnsynced(commitContext, monitor);
                        break block17;
                    }
                }
                this.commitUnsynced(commitContext, monitor);
            }
            finally {
                readLock.unlock();
            }
        }
    }

    protected void commitUnsynced(InternalCommitContext commitContext, OMMonitor monitor) {
        ProgressDistributor distributor = this.store.getIndicatingCommitDistributor();
        distributor.run(InternalCommitContext.OPS, (Object)commitContext, monitor);
    }

    @Override
    public void sendCommitNotification(CDOProtocol.CommitNotificationInfo info) {
        boolean isFailureCommitInfo;
        CDOCommitInfo commitInfo = info.getCommitInfo();
        boolean bl = isFailureCommitInfo = commitInfo.getBranch() == null;
        if (isFailureCommitInfo || !commitInfo.isEmpty() || info.getLockChangeInfo() != null) {
            this.sessionManager.sendCommitNotification(info);
            this.commitInfoManager.notifyCommitInfoHandlers(commitInfo);
        }
    }

    @Override
    public IQueryHandlerProvider getQueryHandlerProvider() {
        return this.queryHandlerProvider;
    }

    @Override
    public void setQueryHandlerProvider(IQueryHandlerProvider queryHandlerProvider) {
        this.queryHandlerProvider = queryHandlerProvider;
    }

    @Override
    public synchronized IQueryHandler getQueryHandler(CDOQueryInfo info) {
        IQueryHandler handler;
        String language = info.getQueryLanguage();
        if ("resources".equals(language)) {
            return new ResourcesQueryHandler();
        }
        if ("instances".equals(language)) {
            return new InstancesQueryHandler();
        }
        if ("xrefs".equals(language)) {
            return new XRefsQueryHandler();
        }
        IStoreAccessor storeAccessor = StoreThreadLocal.getAccessor();
        if (storeAccessor != null && (handler = storeAccessor.getQueryHandler(info)) != null) {
            return handler;
        }
        if (this.queryHandlerProvider == null) {
            IManagedContainer container = this.getContainer();
            this.queryHandlerProvider = new ContainerQueryHandlerProvider(container);
        }
        if ((handler = this.queryHandlerProvider.getQueryHandler(info)) != null) {
            return handler;
        }
        return null;
    }

    @Override
    public void addOperationAuthorizer(OperationAuthorizer<ISession> operationAuthorizer) {
        this.checkInactive();
        this.operationAuthorizers.add(operationAuthorizer);
    }

    public boolean isAuthorizingOperations() {
        return !this.operationAuthorizers.isEmpty();
    }

    public String authorizeOperation(ISession session, AuthorizableOperation operation) {
        if (session == null) {
            return "No session";
        }
        for (OperationAuthorizer<ISession> authorizer : this.operationAuthorizers) {
            try {
                String result = authorizer.authorizeOperation((Object)session, operation);
                if (result == null) continue;
                return result;
            }
            catch (Error ex) {
                throw ex;
            }
            catch (Throwable t) {
                OM.LOG.error(t);
                return "Error: " + t.getLocalizedMessage();
            }
        }
        return null;
    }

    protected final void authorizeOperation(AuthorizableOperation operation) throws AuthorizationException {
        InternalSession session;
        String denial;
        if (this.isAuthorizingOperations() && (denial = this.authorizeOperation(session = StoreThreadLocal.getSession(), operation)) != null) {
            throw new AuthorizationException(denial);
        }
    }

    public IManagedContainer getContainer() {
        if (this.container == null) {
            return IPluginContainer.INSTANCE;
        }
        return this.container;
    }

    @Override
    public void setContainer(IManagedContainer container) {
        this.container = container;
    }

    public ExecutorService getExecutorService() {
        IManagedContainer container = this.getContainer();
        return ConcurrencyUtil.getExecutorService((IManagedContainer)container);
    }

    public Object[] getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return false;
    }

    public long getCreationTime() {
        return this.store.getCreationTime();
    }

    @Override
    public void validateTimeStamp(long timeStamp) throws IllegalArgumentException {
        long creationTimeStamp = this.getCreationTime();
        if (timeStamp < creationTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
        }
        long currentTimeStamp = this.getTimeStamp();
        if (timeStamp > currentTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) > current time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)currentTimeStamp)));
        }
    }

    public long getTimeStamp() {
        return this.timeProvider.getTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IRepository.Handler> getHandlers() {
        HashSet<IRepository.Handler> handlers = new HashSet<IRepository.Handler>();
        List<IRepository.Handler> list = this.readAccessHandlers;
        synchronized (list) {
            handlers.addAll(this.readAccessHandlers);
        }
        list = this.writeAccessHandlers;
        synchronized (list) {
            handlers.addAll(this.writeAccessHandlers);
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                if (!this.readAccessHandlers.contains(handler)) {
                    this.readAccessHandlers.add((IRepository.ReadAccessHandler)handler);
                }
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                if (!this.writeAccessHandlers.contains(handler)) {
                    this.writeAccessHandlers.add((IRepository.WriteAccessHandler)handler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                this.readAccessHandlers.remove(handler);
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                this.writeAccessHandlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReadAccessHandlers(InternalSession session, CDORevision[] revisions, List<CDORevision> additionalRevisions) {
        IRepository.ReadAccessHandler[] handlers;
        List<IRepository.ReadAccessHandler> list = this.readAccessHandlers;
        synchronized (list) {
            int size = this.readAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.readAccessHandlers.toArray(new IRepository.ReadAccessHandler[size]);
        }
        IRepository.ReadAccessHandler[] readAccessHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository.ReadAccessHandler handler = readAccessHandlerArray[n2];
            handler.handleRevisionsBeforeSending(session, revisions, additionalRevisions);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWriteAccessHandlers(ITransaction transaction, IStoreAccessor.CommitContext commitContext, boolean beforeCommit, OMMonitor monitor) {
        IRepository.WriteAccessHandler[] handlers;
        List<IRepository.WriteAccessHandler> list = this.writeAccessHandlers;
        synchronized (list) {
            int size = this.writeAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.writeAccessHandlers.toArray(new IRepository.WriteAccessHandler[size]);
        }
        try {
            monitor.begin((double)handlers.length);
            IRepository.WriteAccessHandler[] writeAccessHandlerArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository.WriteAccessHandler handler = writeAccessHandlerArray[n2];
                try {
                    if (beforeCommit) {
                        handler.handleTransactionBeforeCommitting(transaction, commitContext, monitor.fork());
                    } else {
                        handler.handleTransactionAfterCommitted(transaction, commitContext, monitor.fork());
                    }
                }
                catch (RuntimeException ex) {
                    if (!beforeCommit) {
                        OM.LOG.error((Throwable)ex);
                    }
                    throw ex;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setInitialPackages(EPackage ... initialPackages) {
        this.checkInactive();
        this.initialPackages = initialPackages;
    }

    @Override
    public CDOReplicationInfo replicateRaw(CDODataOutput out, int lastReplicatedBranchID, long lastReplicatedCommitTime) throws IOException {
        int fromBranchID = lastReplicatedBranchID + 1;
        final int toBranchID = this.store.getLastBranchID();
        long fromCommitTime = lastReplicatedCommitTime + 1L;
        final long toCommitTime = this.store.getLastCommitTime();
        out.writeXInt(toBranchID);
        out.writeXLong(toCommitTime);
        IStoreAccessor.Raw accessor = (IStoreAccessor.Raw)StoreThreadLocal.getAccessor();
        accessor.rawExport(out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
        return new CDOReplicationInfo(){

            public int getLastReplicatedBranchID() {
                return toBranchID;
            }

            public long getLastReplicatedCommitTime() {
                return toCommitTime;
            }

            public String[] getLockAreaIDs() {
                return null;
            }
        };
    }

    @Override
    public void replicate(CDOReplicationContext context) {
        int startID = context.getLastReplicatedBranchID() + 1;
        this.branchManager.getBranches(startID, 0, (CDOBranchHandler)context);
        long startTime = context.getLastReplicatedCommitTime();
        this.commitInfoManager.getCommitInfos(null, startTime + 1L, 0L, (CDOCommitInfoHandler)context);
        this.getLockingManager().getLockAreas(null, (IDurableLockingManager.LockArea.Handler)context);
    }

    @Override
    public CDOChangeSetData getChangeSet(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        CDOChangeSetSegment[] segments = CDOBranchUtil.isContainedBy((CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint) ? CDOChangeSetSegment.createFrom((CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint) : CDOChangeSetSegment.createFrom((CDOBranchPoint)endPoint, (CDOBranchPoint)startPoint);
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        Set<CDOID> ids = accessor.readChangeSet((OMMonitor)new Monitor(), segments);
        return CDORevisionUtil.createChangeSetData(ids, (CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint, (CDORevisionManager)this.revisionManager);
    }

    @Override
    public CDOSessionProtocol.MergeDataResult getMergeData2(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo, OMMonitor monitor) {
        CDOBranchPoint target = targetInfo.getBranchPoint();
        CDOBranchPoint source = sourceInfo.getBranchPoint();
        monitor.begin(5.0);
        try {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            CDOSessionProtocol.MergeDataResult result = new CDOSessionProtocol.MergeDataResult();
            Set targetIDs = result.getTargetIDs();
            Set sourceIDs = result.getSourceIDs();
            if (targetBaseInfo == null && sourceBaseInfo == null) {
                if (CDOBranchUtil.isContainedBy((CDOBranchPoint)source, (CDOBranchPoint)target)) {
                    targetIDs.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)source, (CDOBranchPoint)target)));
                } else if (CDOBranchUtil.isContainedBy((CDOBranchPoint)target, (CDOBranchPoint)source)) {
                    targetIDs.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)target, (CDOBranchPoint)source)));
                } else {
                    CDOBranchPoint ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
                    targetIDs.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)target)));
                    sourceIDs.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)source)));
                }
            } else {
                CDOChangeSetSegment[] sourceSegments;
                CDOChangeSetSegment[] targetSegments;
                if (targetBaseInfo.getBranchPoint() == CDOBranchUtil.AUTO_BRANCH_POINT) {
                    CDOBranchPointRange latestSourceMerge;
                    CDOBranchPoint ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
                    targetSegments = CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)target);
                    sourceSegments = CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)source);
                    CDOBranchPoint targetBase = ancestor;
                    CDOBranchPoint sourceBase = ancestor;
                    long ancestorTime = ancestor.getTimeStamp();
                    CDOBranchPointRange latestTargetMerge = this.getLatestMerge(targetSegments, sourceSegments, ancestorTime);
                    if (latestTargetMerge != null) {
                        targetBase = latestTargetMerge.getEndPoint();
                        sourceBase = latestTargetMerge.getStartPoint();
                        if (!sourceBase.equals(ancestor)) {
                            sourceSegments = CDOChangeSetSegment.createFrom((CDOBranchPoint)sourceBase, (CDOBranchPoint)source);
                        }
                    }
                    if ((latestSourceMerge = this.getLatestMerge(sourceSegments, targetSegments, ancestorTime)) != null) {
                        CDOBranchPoint mergeSource = latestSourceMerge.getStartPoint();
                        if (targetBase.getTimeStamp() < mergeSource.getTimeStamp()) {
                            targetBase = mergeSource;
                        }
                        result.setResultBase(sourceBase);
                    }
                    if (!targetBase.equals(ancestor)) {
                        targetSegments = CDOChangeSetSegment.createFrom((CDOBranchPoint)targetBase, (CDOBranchPoint)target);
                    }
                    targetBaseInfo.setBranchPoint(targetBase);
                    sourceBaseInfo.setBranchPoint(sourceBase);
                } else {
                    CDORevisionAvailabilityInfo sourceBaseInfoToUse = sourceBaseInfo == null ? targetBaseInfo : sourceBaseInfo;
                    targetSegments = CDOChangeSetSegment.createFrom((CDOBranchPoint)targetBaseInfo.getBranchPoint(), (CDOBranchPoint)target);
                    sourceSegments = CDOChangeSetSegment.createFrom((CDOBranchPoint)sourceBaseInfoToUse.getBranchPoint(), (CDOBranchPoint)source);
                }
                targetIDs.addAll(accessor.readChangeSet(monitor.fork(), targetSegments));
                sourceIDs.addAll(accessor.readChangeSet(monitor.fork(), sourceSegments));
            }
            this.loadMergeData(targetIDs, targetInfo, monitor.fork());
            this.loadMergeData(sourceIDs, sourceInfo, monitor.fork());
            if (targetBaseInfo != null) {
                this.loadMergeData(targetIDs, targetBaseInfo, monitor.fork());
            }
            if (sourceBaseInfo != null && !targetBaseInfo.getBranchPoint().equals(sourceBaseInfo.getBranchPoint())) {
                this.loadMergeData(sourceIDs, sourceBaseInfo, monitor.fork());
            }
            CDOSessionProtocol.MergeDataResult mergeDataResult = result;
            return mergeDataResult;
        }
        finally {
            monitor.done();
        }
    }

    private CDOBranchPointRange getLatestMerge(CDOChangeSetSegment[] targetSegments, CDOChangeSetSegment[] sourceSegments, long ancestorTime) {
        int i = targetSegments.length - 1;
        while (i >= 0) {
            CDOChangeSetSegment targetSegment = targetSegments[i];
            CDOBranch targetBranch = targetSegment.getBranch();
            long startTime = targetSegment.getTimeStamp();
            long endTime = targetSegment.getEndTime();
            while (endTime > startTime || endTime == 0L) {
                long timeStamp;
                CDOCommitInfo commitInfo = this.commitInfoManager.getCommitInfo(targetBranch, endTime, false);
                if (commitInfo == null || (timeStamp = commitInfo.getTimeStamp()) <= startTime) break;
                CDOBranchPoint mergeSource = this.getMergeSource(commitInfo, sourceSegments, ancestorTime);
                if (mergeSource != null) {
                    CDOBranchPoint endPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)commitInfo);
                    return CDOBranchUtil.createRange((CDOBranchPoint)mergeSource, (CDOBranchPoint)endPoint);
                }
                endTime = timeStamp - 1L;
            }
            --i;
        }
        return null;
    }

    private CDOBranchPoint getMergeSource(CDOCommitInfo commitInfo, CDOChangeSetSegment[] sourceSegments, long ancestorTime) {
        CDOBranchPoint mergeSource = commitInfo.getMergeSource();
        if (mergeSource != null) {
            if (CDOChangeSetSegment.contains((CDOChangeSetSegment[])sourceSegments, (CDOBranchPoint)mergeSource)) {
                return mergeSource;
            }
            CDOChangeSetSegment[] targetSegments = CDOChangeSetSegment.createFrom((long)ancestorTime, (CDOBranchPoint)mergeSource);
            CDOBranchPointRange latestMerge = this.getLatestMerge(targetSegments, sourceSegments, ancestorTime);
            if (latestMerge != null) {
                return latestMerge.getStartPoint();
            }
        }
        return null;
    }

    private void loadMergeData(Set<CDOID> ids, CDORevisionAvailabilityInfo info, OMMonitor monitor) {
        int size = ids.size();
        monitor.begin((double)size);
        try {
            CDOBranchPoint branchPoint = info.getBranchPoint();
            for (CDOID id : ids) {
                if (info.containsRevision(id)) {
                    info.removeRevision(id);
                } else {
                    InternalCDORevision revision = this.getRevisionFromBranch(id, branchPoint);
                    if (revision != null) {
                        info.addRevision((CDORevisionKey)revision);
                    } else {
                        info.removeRevision(id);
                    }
                }
                monitor.worked();
            }
        }
        finally {
            monitor.done();
        }
    }

    private InternalCDORevision getRevisionFromBranch(CDOID id, CDOBranchPoint branchPoint) {
        return this.revisionManager.getRevision(id, branchPoint, -1, 0, true);
    }

    @Override
    public void queryLobs(List<byte[]> ids) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.queryLobs(ids);
    }

    @Override
    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.handleLobs(fromTime, toTime, handler);
    }

    @Override
    public void loadLob(byte[] id, OutputStream out) throws IOException {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.loadLob(id, out);
    }

    @Override
    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, final CDORevisionHandler handler) {
        CDORevisionHandler wrapper = handler;
        if (!exactBranch && !branch.isMainBranch()) {
            if (exactTime && timeStamp == 0L) {
                throw new IllegalArgumentException("Time stamp must be specified if exactBranch==false and exactTime==true");
            }
            wrapper = new CDORevisionHandler(){
                private Set<CDOID> handled = new HashSet<CDOID>();

                public boolean handleRevision(CDORevision revision) {
                    CDOID id = revision.getID();
                    if (this.handled.add(id)) {
                        return handler.handleRevision(revision);
                    }
                    return true;
                }
            };
        }
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        while (branch != null) {
            accessor.handleRevisions(eClass, branch, timeStamp, exactTime, wrapper);
            if (exactBranch) break;
            CDOBranchPoint base = branch.getBase();
            branch = base.getBranch();
            timeStamp = base.getTimeStamp();
        }
    }

    private CDORevisionKey[] checkStaleRevisions(InternalView view, List<CDORevisionKey> revisionKeys, List<Object> objectsToLock, IRWLockManager.LockType lockType, long[] requiredTimestamp) {
        LinkedList<CDORevisionKey> staleRevisions = new LinkedList<CDORevisionKey>();
        if (revisionKeys != null) {
            InternalCDORevisionManager revManager = this.getRevisionManager();
            CDOBranch viewedBranch = view.getBranch();
            for (CDORevisionKey revKey : revisionKeys) {
                CDOID id = revKey.getID();
                InternalCDORevision rev = revManager.getRevision(id, viewedBranch.getHead(), -1, 0, true);
                if (rev == null) {
                    throw new IllegalArgumentException(String.format("Object %s not found in branch %s (possibly detached)", id, viewedBranch));
                }
                if (revKey.equals(rev)) continue;
                staleRevisions.add(CDORevisionUtil.copyRevisionKey((CDORevisionKey)rev));
                requiredTimestamp[0] = Math.max(requiredTimestamp[0], rev.getTimeStamp());
            }
        }
        CDORevisionKey[] staleRevisionsArray = new CDORevisionKey[staleRevisions.size()];
        staleRevisions.toArray(staleRevisionsArray);
        return staleRevisionsArray;
    }

    private void sendLockNotifications(IView view, List<CDOLockDelta> lockDeltas, List<CDOLockState> lockStates) {
        CDOBranchPoint branchPoint = view.getBranch().getPoint(this.getTimeStamp());
        CDOLockOwner lockOwner = view.getLockOwner();
        CDOLockChangeInfo lockChangeInfo = CDOLockUtil.createLockChangeInfo((CDOBranchPoint)branchPoint, (CDOLockOwner)lockOwner, lockDeltas, lockStates);
        InternalSession sender = (InternalSession)view.getSession();
        this.sessionManager.sendLockNotification(sender, lockChangeInfo);
    }

    @Override
    public CDOSessionProtocol.LockObjectsResult lock(InternalView view, IRWLockManager.LockType lockType, List<CDORevisionKey> revKeys, boolean recursive, long timeout) {
        List<Object> lockables = Repository.revisionKeysToObjects(revKeys, view.getBranch(), this.isSupportingBranches());
        return this.doLock(view, lockType, lockables, revKeys, recursive, timeout);
    }

    protected CDOSessionProtocol.LockObjectsResult doLock(InternalView view, IRWLockManager.LockType lockType, List<Object> lockables, List<CDORevisionKey> loadedRevs, boolean recursive, long timeout) {
        boolean staleNoUpdate;
        LockingManager.LockDeltaCollector lockDeltas = new LockingManager.LockDeltaCollector(CDOLockChangeInfo.Operation.LOCK);
        LockingManager.LockStateCollector lockStates = new LockingManager.LockStateCollector();
        try {
            this.lockingManager.lock(view, lockables, lockType, 1, timeout, recursive, true, lockDeltas, lockStates);
        }
        catch (TimeoutRuntimeException ex) {
            return new CDOSessionProtocol.LockObjectsResult(false, true, false, 0L, new CDORevisionKey[0], NO_LOCK_DELTAS, NO_LOCK_STATES, this.getTimeStamp());
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        long[] requiredTimestamp = new long[1];
        CDORevisionKey[] staleRevisionsArray = null;
        try {
            staleRevisionsArray = this.checkStaleRevisions(view, loadedRevs, lockables, lockType, requiredTimestamp);
        }
        catch (IllegalArgumentException ex) {
            this.lockingManager.unlock(view, lockables, lockType, 1, recursive, true, null, null);
            throw ex;
        }
        InternalSession session = view.getSession();
        boolean bl = staleNoUpdate = staleRevisionsArray.length > 0 && !session.isPassiveUpdateEnabled();
        if (staleNoUpdate) {
            this.lockingManager.unlock(view, lockables, lockType, 1, recursive, true, null, null);
            return new CDOSessionProtocol.LockObjectsResult(false, false, false, requiredTimestamp[0], staleRevisionsArray, NO_LOCK_DELTAS, NO_LOCK_STATES, this.getTimeStamp());
        }
        this.sendLockNotifications(view, lockDeltas, lockStates);
        boolean waitForUpdate = staleRevisionsArray.length > 0;
        return new CDOSessionProtocol.LockObjectsResult(true, false, waitForUpdate, requiredTimestamp[0], staleRevisionsArray, (List)lockDeltas, (List)lockStates, this.getTimeStamp());
    }

    @Override
    public CDOSessionProtocol.UnlockObjectsResult unlock(InternalView view, IRWLockManager.LockType lockType, List<CDOID> objectIDs, boolean recursive) {
        ArrayList<Object> unlockables = null;
        if (objectIDs != null) {
            unlockables = new ArrayList<Object>(objectIDs.size());
            CDOBranch branch = view.getBranch();
            for (CDOID id : objectIDs) {
                CDOID key = this.supportingBranches ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)branch) : id;
                unlockables.add(key);
            }
        }
        return this.doUnlock(view, lockType, unlockables, recursive, 1);
    }

    @Override
    public CDOSessionProtocol.UnlockObjectsResult unlock(InternalView view) {
        return this.doUnlock(view, null, null, false, -1);
    }

    protected CDOSessionProtocol.UnlockObjectsResult doUnlock(InternalView view, IRWLockManager.LockType lockType, List<Object> unlockables, boolean recursive, int count) {
        LockingManager.LockDeltaCollector lockDeltas = new LockingManager.LockDeltaCollector(CDOLockChangeInfo.Operation.UNLOCK);
        LockingManager.LockStateCollector lockStates = new LockingManager.LockStateCollector();
        this.lockingManager.unlock(view, unlockables, lockType, count, recursive, true, lockDeltas, lockStates);
        this.sendLockNotifications(view, lockDeltas, lockStates);
        long timestamp = this.getTimeStamp();
        return new CDOSessionProtocol.UnlockObjectsResult(timestamp, (List)lockDeltas, (List)lockStates);
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public String toString() {
        return MessageFormat.format("Repository[{0}]", this.name);
    }

    @Override
    public boolean isSkipInitialization() {
        return this.skipInitialization;
    }

    @Override
    public void setSkipInitialization(boolean skipInitialization) {
        this.skipInitialization = skipInitialization;
    }

    protected void initProperties() {
        String valueTimeout;
        String valueCommitInfoStorage;
        String valueIDLocation;
        String valueIntegrity;
        String valueCommits;
        String valueAudits;
        String valueLoginPeeks;
        this.uuid = this.properties.get("overrideUUID");
        if (this.uuid != null && this.uuid.length() == 0) {
            this.uuid = this.getName();
        }
        if ((valueLoginPeeks = this.properties.get("supportingLoginPeeks")) != null) {
            this.supportingLoginPeeks = Boolean.valueOf(valueLoginPeeks);
        }
        this.supportingAudits = (valueAudits = this.properties.get("supportingAudits")) != null ? Boolean.valueOf(valueAudits) : this.store.getRevisionTemporality() == IStore.RevisionTemporality.AUDITING;
        String valueBranches = this.properties.get("supportingBranches");
        this.supportingBranches = valueBranches != null ? Boolean.valueOf(valueBranches) : this.store.getRevisionParallelism() == IStore.RevisionParallelism.BRANCHING;
        String valueUnits = this.properties.get("supportingUnits");
        if (valueUnits != null) {
            this.supportingUnits = Boolean.valueOf(valueUnits);
        }
        if ((valueCommits = this.properties.get("serializeCommits")) != null) {
            this.serializingCommits = Boolean.valueOf(valueCommits);
        }
        if ((valueIntegrity = this.properties.get("ensureReferentialIntegrity")) != null) {
            this.ensuringReferentialIntegrity = Boolean.valueOf(valueIntegrity);
        }
        if ((valueIDLocation = this.properties.get("idGenerationLocation")) != null) {
            this.idGenerationLocation = CDOCommonRepository.IDGenerationLocation.valueOf((String)valueIDLocation);
        }
        if (this.idGenerationLocation == null) {
            this.idGenerationLocation = CDOCommonRepository.IDGenerationLocation.STORE;
        }
        if ((valueCommitInfoStorage = this.properties.get("commitInfoStorage")) != null) {
            this.commitInfoStorage = CDOCommonRepository.CommitInfoStorage.valueOf((String)valueCommitInfoStorage);
        }
        if (this.commitInfoStorage == null) {
            this.commitInfoStorage = CDOCommonRepository.CommitInfoStorage.WITH_MERGE_SOURCE;
        }
        if (this.commitInfoStorage != CDOCommonRepository.CommitInfoStorage.NO && !this.supportingBranches) {
            this.commitInfoStorage = CDOCommonRepository.CommitInfoStorage.YES;
        }
        if ((valueTimeout = this.properties.get("optimisticLockingTimeout")) != null) {
            this.optimisticLockingTimeout = Long.valueOf(valueTimeout);
        }
    }

    @Override
    public void initSystemPackages(final boolean firstStart) {
        long timeStamp;
        final ArrayList<InternalCDOPackageUnit> newPackageUnits = new ArrayList<InternalCDOPackageUnit>();
        if (firstStart) {
            timeStamp = this.store.getCreationTime();
            newPackageUnits.add(this.initPackage(timeStamp, (EPackage)EcorePackage.eINSTANCE));
            newPackageUnits.add(this.initPackage(timeStamp, (EPackage)EresourcePackage.eINSTANCE));
            newPackageUnits.add(this.initPackage(timeStamp, (EPackage)EtypesPackage.eINSTANCE));
        } else {
            this.readPackageUnits();
            timeStamp = this.getTimeStamp();
            this.initPackage(timeStamp, (EPackage)EcorePackage.eINSTANCE);
            this.initPackage(timeStamp, (EPackage)EresourcePackage.eINSTANCE);
            this.initPackage(timeStamp, (EPackage)EtypesPackage.eINSTANCE);
        }
        if (this.initialPackages != null) {
            EPackage[] ePackageArray = this.initialPackages;
            int n = this.initialPackages.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage initialPackage = ePackageArray[n2];
                if (!this.packageRegistry.containsKey((Object)initialPackage.getNsURI())) {
                    newPackageUnits.add(this.initPackage(timeStamp, initialPackage));
                }
                ++n2;
            }
        }
        if (!newPackageUnits.isEmpty()) {
            IStoreAccessor writer = this.store.getWriter(null);
            StoreThreadLocal.setAccessor(writer);
            try {
                InternalCDOPackageUnit[] packageUnits = newPackageUnits.toArray(new InternalCDOPackageUnit[newPackageUnits.size()]);
                writer.writePackageUnits(packageUnits, (OMMonitor)new Monitor());
                writer.commit((OMMonitor)new Monitor());
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        this.fireEvent(new InternalRepository.PackagesInitializedEvent(){

            @Override
            public InternalRepository getSource() {
                return Repository.this;
            }

            @Override
            public boolean isFirstStart() {
                return firstStart;
            }

            @Override
            public List<InternalCDOPackageUnit> getPackageUnits() {
                return Collections.unmodifiableList(newPackageUnits);
            }
        });
    }

    protected InternalCDOPackageUnit initPackage(long timeStamp, EPackage ePackage) {
        EMFUtil.registerPackage((EPackage)ePackage, (EPackage.Registry[])new EPackage.Registry[]{this.packageRegistry});
        InternalCDOPackageInfo packageInfo = this.packageRegistry.getPackageInfo(ePackage);
        InternalCDOPackageUnit packageUnit = packageInfo.getPackageUnit();
        packageUnit.setState(CDOPackageUnit.State.LOADED);
        if (packageUnit.getTimeStamp() == 0L) {
            packageUnit.setTimeStamp(timeStamp);
        }
        return packageUnit;
    }

    @Override
    public void initMainBranch(InternalCDOBranchManager branchManager, long timeStamp) {
        branchManager.initMainBranch(false, timeStamp);
    }

    protected void initRootResource() {
        CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
        CDORevisionFactory factory = this.getRevisionManager().getFactory();
        InternalCDORevision rootResource = (InternalCDORevision)factory.createRevision(EresourcePackage.Literals.CDO_RESOURCE);
        rootResource.setBranchPoint(head);
        rootResource.setContainerID((Object)CDOID.NULL);
        rootResource.setContainingFeatureID(0);
        CDOID id = this.createRootResourceID();
        rootResource.setID(id);
        rootResource.setResourceID(id);
        InternalSession session = this.getSessionManager().openSession(null);
        InternalTransaction transaction = session.openTransaction(1, head);
        TransactionCommitContext commitContext = new TransactionCommitContext(transaction){

            @Override
            protected long[] createTimeStamp(OMMonitor monitor) {
                InternalRepository repository = this.getTransaction().getSession().getRepository();
                return repository.forceCommitTimeStamp(Repository.this.store.getCreationTime(), monitor);
            }

            @Override
            public String getUserID() {
                return "CDO_SYSTEM";
            }

            @Override
            public String getCommitComment() {
                return "<initialize>";
            }
        };
        commitContext.setNewObjects(new InternalCDORevision[]{rootResource});
        commitContext.preWrite();
        commitContext.write((OMMonitor)new Monitor());
        commitContext.commit((OMMonitor)new Monitor());
        String rollbackMessage = commitContext.getRollbackMessage();
        if (rollbackMessage != null) {
            throw new TransactionException(rollbackMessage);
        }
        this.rootResourceID = id instanceof CDOIDTemp ? commitContext.getIDMappings().get(id) : id;
        commitContext.postCommit(true);
        session.close();
    }

    protected CDOID createRootResourceID() {
        if (this.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            return CDOIDUtil.createTempObject((int)1);
        }
        return CDOIDGenerator.UUID.generateCDOID(null);
    }

    protected void readRootResource() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
            this.rootResourceID = reader.readResourceID(CDOID.NULL, null, head);
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void readPackageUnits() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            Collection<InternalCDOPackageUnit> packageUnits = reader.readPackageUnits();
            for (InternalCDOPackageUnit packageUnit : packageUnits) {
                this.packageRegistry.putPackageUnit(packageUnit);
            }
            for (InternalCDOPackageUnit packageUnit : packageUnits) {
                InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
                int n = internalCDOPackageInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                    packageInfo.getEPackage(true);
                    ++n2;
                }
            }
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void setPostActivateState() {
        this.setState(CDOCommonRepository.State.ONLINE);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(!StringUtil.isEmpty((String)this.name), "name is empty");
        this.checkState(this.store, "store");
        this.checkState(this.packageRegistry, "packageRegistry");
        this.checkState(this.sessionManager, "sessionManager");
        this.checkState(this.branchManager, "branchManager");
        this.checkState(this.revisionManager, "revisionManager");
        this.checkState(this.queryManager, "queryManager");
        this.checkState(this.commitInfoManager, "commitInfoManager");
        this.checkState(this.commitManager, "commitManager");
        this.checkState(this.lockingManager, "lockingManager");
        this.packageRegistry.setReplacingDescriptors(true);
        if (this.packageRegistry.getPackageProcessor() == null) {
            this.packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)this);
        }
        if (this.packageRegistry.getPackageLoader() == null) {
            this.packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        }
        if (this.branchManager.getRepository() == null) {
            this.branchManager.setRepository((CDOCommonRepository)this);
        }
        if (this.branchManager.getBranchLoader() == null) {
            this.branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)this);
        }
        if (this.revisionManager.getRevisionLoader() == null) {
            this.revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)this);
        }
        if (this.sessionManager.getRepository() == null) {
            this.sessionManager.setRepository(this);
        }
        if (this.queryManager.getRepository() == null) {
            this.queryManager.setRepository(this);
        }
        if (this.commitInfoManager.getRepository() == null) {
            this.commitInfoManager.setRepository((CDOCommonRepository)this);
        }
        if (this.commitInfoManager.getBranchManager() == null) {
            this.commitInfoManager.setBranchManager((CDOBranchManager)this.branchManager);
        }
        if (this.commitInfoManager.getCommitInfoLoader() == null) {
            this.commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)this);
        }
        if (this.commitManager.getRepository() == null) {
            this.commitManager.setRepository(this);
        }
        if (this.lockingManager.getRepository() == null) {
            this.lockingManager.setRepository(this);
        }
        if (this.store.getRepository() == null) {
            this.store.setRepository(this);
        }
        if (this.protector != null && this.protector.getRepository() == null) {
            this.protector.setRepository(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doActivate() throws Exception {
        super.doActivate();
        this.initProperties();
        if (this.idGenerationLocation == CDOCommonRepository.IDGenerationLocation.CLIENT && !(this.store instanceof IStore.CanHandleClientAssignedIDs)) {
            throw new IllegalStateException("Store can not handle client-assigned IDs: " + this.store);
        }
        this.store.setRevisionTemporality(this.supportingAudits ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        this.store.setRevisionParallelism(this.supportingBranches ? IStore.RevisionParallelism.BRANCHING : IStore.RevisionParallelism.NONE);
        this.revisionManager.setSupportingAudits(this.supportingAudits);
        this.revisionManager.setSupportingBranches(this.supportingBranches);
        LifecycleUtil.activate((Object)this.store);
        Map<String, String> persistentProperties = this.store.getPersistentProperties(Collections.singleton(PROP_UUID));
        String persistentUUID = persistentProperties.get(PROP_UUID);
        if (this.uuid == null) {
            this.uuid = persistentUUID == null ? UUID.randomUUID().toString() : persistentUUID;
        }
        if (persistentUUID == null || !persistentUUID.equals(this.uuid)) {
            persistentProperties.put(PROP_UUID, this.uuid);
            this.store.setPersistentProperties(persistentProperties);
        }
        LifecycleUtil.activate((Object)this.packageRegistry);
        LifecycleUtil.activate((Object)this.sessionManager);
        LifecycleUtil.activate((Object)this.revisionManager);
        LifecycleUtil.activate((Object)this.branchManager);
        LifecycleUtil.activate((Object)this.queryManager);
        LifecycleUtil.activate((Object)this.commitInfoManager);
        LifecycleUtil.activate((Object)this.commitManager);
        LifecycleUtil.activate((Object)this.queryHandlerProvider);
        if (this.supportingUnits) {
            LifecycleUtil.activate((Object)this.unitManager);
        }
        if (!this.skipInitialization) {
            long creationTime = this.store.getCreationTime();
            this.initMainBranch(this.branchManager, creationTime);
            long lastCommitTime = Math.max(creationTime, this.store.getLastCommitTime());
            this.timeStampAuthority.setLastFinishedTimeStamp(lastCommitTime);
            this.commitInfoManager.setLastCommitOfBranch(null, lastCommitTime);
            if (this.store.isFirstStart()) {
                this.initSystemPackages(true);
                this.initRootResource();
            } else {
                this.initSystemPackages(false);
                this.readRootResource();
            }
            this.branchManager.setTagModCount(0);
            if (this.supportingAudits) {
                IStoreAccessor reader = this.store.getReader(null);
                StoreThreadLocal.setAccessor(reader);
                try {
                    this.tagList = this.branchManager.getTagList();
                }
                finally {
                    StoreThreadLocal.release();
                }
            }
        }
        LifecycleUtil.activate((Object)this.lockingManager);
        LifecycleUtil.activate((Object)this.protector);
        this.setPostActivateState();
        Map<String, Repository> map = REPOSITORIES;
        synchronized (map) {
            if (REPOSITORIES.putIfAbsent(this.uuid, this) != null) {
                OM.LOG.warn("Attempt to register repository with duplicate UUID: " + this.uuid);
            }
        }
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        ArrayList elements = new ArrayList();
        CollectionUtil.addNotNull(elements, (Object)this.packageRegistry);
        CollectionUtil.addNotNull(elements, (Object)this.branchManager);
        CollectionUtil.addNotNull(elements, (Object)this.revisionManager);
        CollectionUtil.addNotNull(elements, (Object)this.sessionManager);
        CollectionUtil.addNotNull(elements, (Object)this.queryManager);
        CollectionUtil.addNotNull(elements, (Object)this.commitManager);
        CollectionUtil.addNotNull(elements, (Object)this.commitConflictResolver);
        CollectionUtil.addNotNull(elements, (Object)this.commitInfoManager);
        CollectionUtil.addNotNull(elements, (Object)this.lockingManager);
        CollectionUtil.addNotNull(elements, (Object)this.unitManager);
        CollectionUtil.addNotNull(elements, (Object)this.store);
        this.elements = elements.toArray();
        List postActivateables = elements.stream().filter(InternalRepository.PostActivateable.class::isInstance).map(InternalRepository.PostActivateable.class::cast).collect(Collectors.toList());
        if (!postActivateables.isEmpty()) {
            try (InternalSession session = this.getSessionManager().openSession(null);){
                StoreThreadLocal.wrap((ISession)session, () -> {
                    for (InternalRepository.PostActivateable postActivateable : postActivateables) {
                        postActivateable.doPostActivate(session);
                    }
                }).run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        Map<String, Repository> map = REPOSITORIES;
        synchronized (map) {
            REPOSITORIES.remove(this.uuid);
        }
        LifecycleUtil.deactivate((Object)this.unitManager);
        LifecycleUtil.deactivate((Object)this.lockingManager);
        LifecycleUtil.deactivate((Object)this.queryHandlerProvider);
        LifecycleUtil.deactivate((Object)this.commitManager);
        LifecycleUtil.deactivate((Object)this.commitInfoManager);
        LifecycleUtil.deactivate((Object)this.queryManager);
        LifecycleUtil.deactivate((Object)this.revisionManager);
        LifecycleUtil.deactivate((Object)this.sessionManager);
        LifecycleUtil.deactivate((Object)this.store);
        LifecycleUtil.deactivate((Object)this.branchManager);
        LifecycleUtil.deactivate((Object)this.packageRegistry);
        super.doDeactivate();
    }

    private static boolean isSecurityManagerWrapper(IRepositoryProtector protector) {
        return protector != null && protector.getAuthorizationStrategy() == null;
    }

    public static List<Object> revisionKeysToObjects(List<CDORevisionKey> revisionKeys, CDOBranch viewedBranch, boolean isSupportingBranches) {
        ArrayList<Object> lockables = new ArrayList<Object>();
        for (CDORevisionKey revKey : revisionKeys) {
            CDOID id = revKey.getID();
            if (isSupportingBranches) {
                lockables.add(CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)viewedBranch));
                continue;
            }
            lockables.add(id);
        }
        return lockables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Repository get(String uuid) {
        Map<String, Repository> map = REPOSITORIES;
        synchronized (map) {
            return REPOSITORIES.get(uuid);
        }
    }

    @Deprecated
    public boolean isSupportingEcore() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public List<RevisionInfo> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public InternalLockManager getLockManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public CDOCommitInfoHandler[] getCommitInfoHandlers() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addCommitInfoHandler(CDOCommitInfoHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void removeCommitInfoHandler(CDOCommitInfoHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Set<CDOID> getMergeData(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initSystemPackages() {
        throw new UnsupportedOperationException();
    }

    public static class Default
    extends Repository {
        @Override
        protected void doBeforeActivate() throws Exception {
            if (this.getTimeProvider() == null) {
                this.setTimeProvider(this.createTimeProvider());
            }
            if (this.getPackageRegistry(false) == null) {
                this.setPackageRegistry(this.createPackageRegistry());
            }
            if (this.getSessionManager() == null) {
                this.setSessionManager(this.createSessionManager());
            }
            if (this.getBranchManager() == null) {
                this.setBranchManager(this.createBranchManager());
            }
            if (this.getRevisionManager() == null) {
                this.setRevisionManager(this.createRevisionManager());
            }
            if (this.getQueryManager() == null) {
                this.setQueryManager(this.createQueryManager());
            }
            if (this.getCommitInfoManager() == null) {
                this.setCommitInfoManager(this.createCommitInfoManager());
            }
            if (this.getCommitManager() == null) {
                this.setCommitManager(this.createCommitManager());
            }
            if (this.getLockingManager() == null) {
                this.setLockingManager(this.createLockingManager());
            }
            if (this.getUnitManager() == null) {
                this.setUnitManager(this.createUnitManager());
            }
            super.doBeforeActivate();
        }

        protected CDOTimeProvider createTimeProvider() {
            return CurrentTimeProvider.INSTANCE;
        }

        protected InternalCDOPackageRegistry createPackageRegistry() {
            return new CDOPackageRegistryImpl();
        }

        protected InternalSessionManager createSessionManager() {
            return new SessionManager();
        }

        protected InternalCDOBranchManager createBranchManager() {
            return CDOBranchUtil.createBranchManager();
        }

        protected InternalCDORevisionManager createRevisionManager() {
            return (InternalCDORevisionManager)CDORevisionUtil.createRevisionManager();
        }

        protected InternalQueryManager createQueryManager() {
            return new QueryManager();
        }

        protected InternalCDOCommitInfoManager createCommitInfoManager() {
            return CDOCommitInfoUtil.createCommitInfoManager();
        }

        protected InternalCommitManager createCommitManager() {
            return new CommitManager();
        }

        protected InternalUnitManager createUnitManager() {
            return new UnitManager(this);
        }

        public LockingManager createLockingManager() {
            return new LockingManager();
        }
    }
}

