/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDialogAccess;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.ExclusionInclusionDialog;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.LinkFolderDialog;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.RemoveLinkedFolderDialog;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;

public class BuildpathModifierQueries {
    public static IInclusionExclusionQuery getDefaultInclusionExclusionQuery(final Shell shell) {
        return new IInclusionExclusionQuery(){
            protected IPath[] fInclusionPattern;
            protected IPath[] fExclusionPattern;

            @Override
            public boolean doQuery(BPListElement element, boolean focusOnExcluded) {
                boolean[] result = new boolean[1];
                Display.getDefault().syncExec(() -> {
                    Shell sh = shell != null ? shell : DLTKUIPlugin.getActiveWorkbenchShell();
                    ExclusionInclusionDialog dialog = new ExclusionInclusionDialog(sh, element, focusOnExcluded);
                    blArray[0] = dialog.open() == 0;
                    this.fInclusionPattern = dialog.getInclusionPattern();
                    this.fExclusionPattern = dialog.getExclusionPattern();
                });
                return result[0];
            }

            @Override
            public IPath[] getInclusionPattern() {
                return this.fInclusionPattern;
            }

            @Override
            public IPath[] getExclusionPattern() {
                return this.fExclusionPattern;
            }
        };
    }

    public static ILinkToQuery getDefaultLinkQuery(final Shell shell, final IScriptProject project, IPath desiredOutputLocation) {
        return new ILinkToQuery(){
            protected IFolder fFolder;

            @Override
            public boolean doQuery() {
                boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(() -> {
                    Shell sh = shell != null ? shell : DLTKUIPlugin.getActiveWorkbenchShell();
                    LinkFolderDialog dialog = new LinkFolderDialog(sh, (IContainer)project.getProject());
                    boolean bl = blArray[0] = dialog.open() == 0;
                    if (isOK[0]) {
                        this.fFolder = dialog.getCreatedFolder();
                    }
                });
                return isOK[0];
            }

            @Override
            public IFolder getCreatedFolder() {
                return this.fFolder;
            }
        };
    }

    public static IAddArchivesQuery getDefaultArchivesQuery(Shell shell, IEnvironment environment) {
        return () -> {
            IPath[][] selected = new IPath[1][];
            Display.getDefault().syncExec(() -> {
                Shell sh = shell != null ? shell : DLTKUIPlugin.getActiveWorkbenchShell();
                iPathArray[0] = BuildpathDialogAccess.chooseExternalArchiveEntries(sh, environment);
            });
            if (selected[0] == null) {
                return new IPath[0];
            }
            return selected[0];
        };
    }

    public static IRemoveLinkedFolderQuery getDefaultRemoveLinkedFolderQuery(Shell shell) {
        return folder -> {
            int[] result = new int[]{1};
            Display.getDefault().syncExec(() -> {
                RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell != null ? shell : DLTKUIPlugin.getActiveWorkbenchShell(), folder);
                int status = dialog.open();
                nArray[0] = status == 0 ? dialog.getRemoveStatus() : 0;
            });
            return result[0];
        };
    }

    public static IAddLibrariesQuery getDefaultLibrariesQuery(Shell shell) {
        return (project, entries) -> {
            IBuildpathEntry[][] selected = new IBuildpathEntry[1][];
            Display.getDefault().syncExec(() -> {
                Shell sh = shell != null ? shell : DLTKUIPlugin.getActiveWorkbenchShell();
                iBuildpathEntryArray[0] = BuildpathDialogAccess.chooseContainerEntries(sh, project, entries);
            });
            if (selected[0] == null) {
                return new IBuildpathEntry[0];
            }
            return selected[0];
        };
    }

    public static ICreateFolderQuery getDefaultCreateFolderQuery(final Shell shell, final IScriptProject project) {
        return new ICreateFolderQuery(){
            private IFolder fNewFolder;

            @Override
            public boolean doQuery() {
                boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(() -> {
                    Shell sh = shell != null ? shell : DLTKUIPlugin.getActiveWorkbenchShell();
                    NewFolderDialog dialog = new NewFolderDialog(sh, (IContainer)project.getProject());
                    boolean bl = blArray[0] = dialog.open() == 0;
                    if (isOK[0]) {
                        IResource sourceContainer = (IResource)dialog.getResult()[0];
                        this.fNewFolder = sourceContainer instanceof IFolder ? (IFolder)sourceContainer : null;
                    }
                });
                return isOK[0];
            }

            @Override
            public boolean isSourceFolder() {
                return true;
            }

            @Override
            public IFolder getCreatedFolder() {
                return this.fNewFolder;
            }
        };
    }

    public static interface IAddArchivesQuery {
        public IPath[] doQuery();
    }

    public static interface IAddLibrariesQuery {
        public IBuildpathEntry[] doQuery(IScriptProject var1, IBuildpathEntry[] var2);
    }

    public static interface ICreateFolderQuery {
        public boolean doQuery();

        public boolean isSourceFolder();

        public IFolder getCreatedFolder();
    }

    public static interface IInclusionExclusionQuery {
        public boolean doQuery(BPListElement var1, boolean var2);

        public IPath[] getInclusionPattern();

        public IPath[] getExclusionPattern();
    }

    public static interface ILinkToQuery {
        public boolean doQuery();

        public IFolder getCreatedFolder();
    }

    public static interface IRemoveLinkedFolderQuery {
        public static final int REMOVE_CANCEL = 0;
        public static final int REMOVE_BUILD_PATH = 1;
        public static final int REMOVE_BUILD_PATH_AND_FOLDER = 2;

        public int doQuery(IFolder var1);
    }
}

