/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.server.DefaultLanguageScripts;
import com.google.gwt.i18n.server.RegionInheritance;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtLocaleImpl
implements GwtLocale {
    private static final String[] deprecatedLanguages = new String[]{"he", "iw", "id", "in", "jv", "jw", "ro", "mo", "yi", "ji"};
    private static final String[] deprecatedRegions = new String[]{"TL", "TP"};
    private final GwtLocaleFactory factory;
    private final String language;
    private final String region;
    private final String script;
    private final String variant;
    private final Object cacheLock = new Object[0];
    private List<GwtLocale> cachedSearchList;
    private List<GwtLocale> cachedAliases;

    private static void addDeprecatedPairs(GwtLocaleFactory factory, GwtLocale locale, List<GwtLocale> aliases) {
        int n = deprecatedLanguages.length;
        for (int i = 0; i < n; i += 2) {
            if (deprecatedLanguages[i].equals(locale.getLanguage())) {
                aliases.add(factory.fromComponents(deprecatedLanguages[i + 1], locale.getScript(), locale.getRegion(), locale.getVariant()));
                break;
            }
            if (!deprecatedLanguages[i + 1].equals(locale.getLanguage())) continue;
            aliases.add(factory.fromComponents(deprecatedLanguages[i], locale.getScript(), locale.getRegion(), locale.getVariant()));
            break;
        }
    }

    private static void addImmediateParentRegions(GwtLocaleFactory factory, GwtLocale locale, Collection<GwtLocale> work) {
        String language = locale.getLanguage();
        String script = locale.getScript();
        String region = locale.getRegion();
        String variant = locale.getVariant();
        if (variant != null) {
            work.add(factory.fromComponents(language, script, region, null));
        }
        Set<String> immediateParents = RegionInheritance.getImmediateParents(region);
        for (String parent : immediateParents) {
            work.add(factory.fromComponents(language, script, parent, variant));
            if (variant == null) continue;
            work.add(factory.fromComponents(language, script, parent, null));
        }
        if (immediateParents.isEmpty()) {
            work.add(factory.fromComponents(language, script, null, variant));
            if (variant != null) {
                work.add(factory.fromComponents(language, script, null, null));
            }
        }
        if (script != null) {
            work.add(factory.fromComponents(language, null, region, variant));
            if (variant != null) {
                work.add(factory.fromComponents(language, null, region, null));
            }
        }
    }

    private static void addParentRegionLocales(GwtLocaleFactory factory, List<GwtLocale> inherits, String language, String script, String region, String variant) {
        for (String parent : RegionInheritance.getAllAncestors(region)) {
            inherits.add(factory.fromComponents(language, script, parent, variant));
        }
    }

    private static void addSpecialAliases(GwtLocaleFactory factory, GwtLocale locale, String initialScript, List<GwtLocale> aliases) {
        String language = locale.getLanguage();
        String script = locale.getScript();
        String region = locale.getRegion();
        String variant = locale.getVariant();
        if ("zh".equals(language) && region == null && (initialScript == null || initialScript.equals(script))) {
            aliases.add(factory.fromComponents("zh", script, "Hant".equals(script) ? "TW" : "CN", variant));
        } else if ("no".equals(language)) {
            if (variant == null || "BOKMAL".equals(variant)) {
                aliases.add(factory.fromComponents("nb", script, region, null));
                aliases.add(factory.fromComponents("no-bok", script, region, null));
            } else if ("NYNORSK".equals(variant)) {
                aliases.add(factory.fromComponents("nn", script, region, null));
                aliases.add(factory.fromComponents("no-nyn", script, region, null));
            }
        } else if ("nb".equals(language)) {
            aliases.add(factory.fromComponents("no", script, region, "BOKMAL"));
        } else if ("nn".equals(language)) {
            aliases.add(factory.fromComponents("no", script, region, "NYNORSK"));
        } else if ("pt".equals(language)) {
            if (region == null) {
                aliases.add(factory.fromComponents("pt", script, "BR", variant));
            } else if ("BR".equals(region)) {
                aliases.add(factory.fromComponents("pt", script, null, variant));
            }
        }
    }

    private static boolean equalsNullCheck(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    private static int stringCompare(String a, String b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    GwtLocaleImpl(GwtLocaleFactory factory, String language, String region, String script, String variant) {
        this.factory = factory;
        this.language = language;
        this.region = region;
        this.script = script;
        this.variant = variant;
    }

    @Override
    public int compareTo(GwtLocale o) {
        int c = GwtLocaleImpl.stringCompare(this.language, o.getLanguage());
        if (c == 0) {
            c = GwtLocaleImpl.stringCompare(this.script, o.getScript());
        }
        if (c == 0) {
            c = GwtLocaleImpl.stringCompare(this.region, o.getRegion());
        }
        if (c == 0) {
            c = GwtLocaleImpl.stringCompare(this.variant, o.getVariant());
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GwtLocale)) {
            return false;
        }
        GwtLocale other = (GwtLocale)obj;
        return GwtLocaleImpl.equalsNullCheck(this.language, other.getLanguage()) && GwtLocaleImpl.equalsNullCheck(this.region, other.getRegion()) && GwtLocaleImpl.equalsNullCheck(this.script, other.getScript()) && GwtLocaleImpl.equalsNullCheck(this.variant, other.getVariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GwtLocale> getAliases() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedAliases == null) {
                String initialScript;
                this.cachedAliases = new ArrayList<GwtLocale>();
                GwtLocale canonicalForm = this.getCanonicalForm();
                HashSet<GwtLocale> seen = new HashSet<GwtLocale>();
                this.cachedAliases.add(canonicalForm);
                ArrayList<GwtLocale> nextGroup = new ArrayList<GwtLocale>();
                nextGroup.add(this);
                String defaultScript = DefaultLanguageScripts.getDefaultScript(this.language, this.region);
                if (defaultScript != null) {
                    if (this.script == null) {
                        nextGroup.add(this.factory.fromComponents(this.language, defaultScript, this.region, this.variant));
                    } else if (this.script.equals(defaultScript)) {
                        nextGroup.add(this.factory.fromComponents(this.language, null, this.region, this.variant));
                    }
                }
                String string = initialScript = this.script == null ? defaultScript : this.script;
                while (!nextGroup.isEmpty()) {
                    ArrayList<GwtLocale> thisGroup = nextGroup;
                    nextGroup = new ArrayList();
                    for (GwtLocale locale : thisGroup) {
                        if (seen.contains(locale)) continue;
                        seen.add(locale);
                        if (!locale.equals(canonicalForm)) {
                            this.cachedAliases.add(locale);
                        }
                        GwtLocaleImpl.addDeprecatedPairs(this.factory, locale, nextGroup);
                        GwtLocaleImpl.addSpecialAliases(this.factory, locale, initialScript, nextGroup);
                    }
                }
                this.cachedAliases = Collections.unmodifiableList(this.cachedAliases);
            }
            return this.cachedAliases;
        }
    }

    @Override
    public String getAsString() {
        StringBuilder buf = new StringBuilder();
        if (this.language != null) {
            buf.append(this.language);
        }
        if (this.script != null) {
            buf.append('_');
            buf.append(this.script);
        }
        if (this.region != null) {
            buf.append('_');
            buf.append(this.region);
        }
        if (this.variant != null) {
            buf.append('_');
            buf.append(this.variant);
        }
        return buf.toString();
    }

    @Override
    public GwtLocale getCanonicalForm() {
        int i;
        String canonLanguage = this.language;
        String canonScript = this.script;
        String canonRegion = this.region;
        String canonVariant = this.variant;
        int n = deprecatedLanguages.length;
        for (i = 0; i < n; i += 2) {
            if (!deprecatedLanguages[i + 1].equals(canonLanguage)) continue;
            canonLanguage = deprecatedLanguages[i];
            break;
        }
        n = deprecatedRegions.length;
        for (i = 0; i < n; i += 2) {
            if (!deprecatedRegions[i + 1].equals(canonRegion)) continue;
            canonRegion = deprecatedRegions[i];
            break;
        }
        if ("zh".equals(canonLanguage)) {
            if (canonRegion != null) {
                if ("CN".equals(canonRegion) && "Hans".equals(canonScript)) {
                    canonScript = null;
                } else if ("TW".equals(canonRegion) && "Hant".equals(canonScript)) {
                    canonScript = null;
                }
            } else if ("Hans".equals(canonScript)) {
                canonRegion = "CN";
                canonScript = null;
            } else if ("Hant".equals(canonScript)) {
                canonRegion = "TW";
                canonScript = null;
            }
        }
        if ("no-bok".equals(canonLanguage)) {
            canonLanguage = "nb";
            canonVariant = null;
        } else if ("no-nyn".equals(canonLanguage)) {
            canonLanguage = "nn";
            canonVariant = null;
        } else if ("no".equals(canonLanguage)) {
            if (canonVariant == null || "BOKMAL".equals(canonVariant)) {
                canonLanguage = "nb";
                canonVariant = null;
            } else if ("NYNORSK".equals(canonVariant)) {
                canonLanguage = "nn";
                canonVariant = null;
            }
        }
        if (canonScript != null && canonScript.equals(DefaultLanguageScripts.getDefaultScript(canonLanguage, canonRegion))) {
            canonScript = null;
        }
        return this.factory.fromComponents(canonLanguage, canonScript, canonRegion, canonVariant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GwtLocale> getCompleteSearchList() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedSearchList == null) {
                this.cachedSearchList = new ArrayList<GwtLocale>();
                HashSet<GwtLocale> seen = new HashSet<GwtLocale>();
                String initialScript = this.script;
                if (initialScript == null) {
                    initialScript = DefaultLanguageScripts.getDefaultScript(this.language, this.region);
                }
                ArrayList<GwtLocale> thisGroup = new ArrayList<GwtLocale>(this.getAliases());
                seen.addAll(thisGroup);
                GwtLocale defLocale = this.factory.getDefault();
                seen.add(defLocale);
                while (!thisGroup.isEmpty()) {
                    this.cachedSearchList.addAll(thisGroup);
                    ArrayList<GwtLocale> nextGroup = new ArrayList<GwtLocale>();
                    for (GwtLocale locale : thisGroup) {
                        List<GwtLocale> aliases = locale.getAliases();
                        aliases = this.filterBadScripts(aliases, initialScript);
                        ArrayList<GwtLocale> work = new ArrayList<GwtLocale>(aliases);
                        work.removeAll(seen);
                        nextGroup.addAll(work);
                        seen.addAll(work);
                        work.clear();
                        if (locale.getRegion() != null) {
                            GwtLocaleImpl.addImmediateParentRegions(this.factory, locale, work);
                        } else if (locale.getVariant() != null) {
                            work.add(this.factory.fromComponents(locale.getLanguage(), locale.getScript(), null, null));
                        } else if (locale.getScript() != null) {
                            work.add(this.factory.fromComponents(locale.getLanguage(), null, null, null));
                        }
                        work.removeAll(seen);
                        nextGroup.addAll(work);
                        seen.addAll(work);
                    }
                    thisGroup = nextGroup;
                }
                if (!this.isDefault()) {
                    this.cachedSearchList.add(defLocale);
                }
                this.cachedSearchList = Collections.unmodifiableList(this.cachedSearchList);
            }
            return this.cachedSearchList;
        }
    }

    @Override
    public List<GwtLocale> getInheritanceChain() {
        ArrayList<GwtLocale> inherits = new ArrayList<GwtLocale>();
        inherits.add(this);
        if (this.variant != null) {
            inherits.add(this.factory.fromComponents(this.language, this.script, this.region, null));
        }
        if (this.region != null) {
            GwtLocaleImpl.addParentRegionLocales(this.factory, inherits, this.language, this.script, this.region, null);
            inherits.add(this.factory.fromComponents(this.language, this.script, null, null));
        }
        if (this.script != null) {
            inherits.add(this.factory.fromComponents(this.language, null, this.region, null));
            GwtLocaleImpl.addParentRegionLocales(this.factory, inherits, this.language, null, this.region, null);
            if (this.region != null) {
                inherits.add(this.factory.fromComponents(this.language, null, null, null));
            }
        }
        if (this.language != null) {
            inherits.add(this.factory.fromComponents(null, null, null, null));
        }
        return inherits;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getLanguageNotNull() {
        return this.language == null ? "" : this.language;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getRegionNotNull() {
        return this.region == null ? "" : this.region;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public String getScriptNotNull() {
        return this.script == null ? "" : this.script;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public String getVariantNotNull() {
        return this.variant == null ? "" : this.variant;
    }

    public int hashCode() {
        int result = this.language == null ? 0 : this.language.hashCode();
        result = 37 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 43 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 53 * result + (this.variant == null ? 0 : this.variant.hashCode());
        return result;
    }

    @Override
    public boolean inheritsFrom(GwtLocale parent) {
        if (this.equals(parent)) {
            return false;
        }
        return this.getInheritanceChain().contains(parent);
    }

    @Override
    public boolean isDefault() {
        return this.language == null;
    }

    @Override
    public String toString() {
        if (this.language == null) {
            return "default";
        }
        return this.getAsString();
    }

    @Override
    public boolean usesSameScript(GwtLocale other) {
        List<GwtLocale> myAliases = this.getAliases();
        List<GwtLocale> otherAliases = other.getAliases();
        for (GwtLocale alias : myAliases) {
            for (GwtLocale otherAlias : otherAliases) {
                if (!GwtLocaleImpl.equalsNullCheck(alias.getScript(), otherAlias.getScript())) continue;
                return true;
            }
        }
        return false;
    }

    private List<GwtLocale> filterBadScripts(List<GwtLocale> aliases, String initialScript) {
        if (initialScript == null) {
            return aliases;
        }
        ArrayList<GwtLocale> result = new ArrayList<GwtLocale>();
        for (GwtLocale alias : aliases) {
            String aliasScript = alias.getScript();
            if (aliasScript != null && !aliasScript.equals(initialScript)) continue;
            result.add(alias);
        }
        return result;
    }
}

