/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.eclipse.wst.jsdt.chromium.debug.ui.TableUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.Messages;

public class ChooseVmControl {
    public static Logic create(Composite parent) {
        final Table table = new Table(parent, 67618);
        table.setFont(parent.getFont());
        final CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        TableUtils.ValueAdapter<ScriptTargetMapping, ConnectedTargetData> pairToTargetAdapter = new TableUtils.ValueAdapter<ScriptTargetMapping, ConnectedTargetData>(){

            @Override
            public ConnectedTargetData convert(ScriptTargetMapping from) {
                return from.getConnectedTargetData();
            }
        };
        List<TableUtils.ColumnData<ScriptTargetMapping, ?>> columnDataList = ChooseVmControl.createLaunchTargetColumns(pairToTargetAdapter);
        for (TableUtils.ColumnData<ScriptTargetMapping, ?> data : columnDataList) {
            data.getLabelProvider().createColumn(table);
        }
        TableUtils.ValueAdapter<Object, ScriptTargetMapping> rowElementAdapter = TableUtils.createCastAdapter(ScriptTargetMapping.class);
        TableUtils.ColumnBasedLabelProvider<ScriptTargetMapping> labelProvider = new TableUtils.ColumnBasedLabelProvider<ScriptTargetMapping>(rowElementAdapter, columnDataList);
        tableViewer.setLabelProvider(labelProvider);
        final ArrayList listeners = new ArrayList(1);
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                for (Logic.Listener listener : listeners) {
                    listener.checkStateChanged();
                }
            }
        });
        return new Logic(){

            @Override
            public Control getControl() {
                return table;
            }

            @Override
            public void setData(List<? extends ScriptTargetMapping> targets) {
                TableData input = new TableData(targets);
                tableViewer.setInput((Object)input);
            }

            @Override
            public List<ScriptTargetMapping> getSelected() {
                final Object[] array = tableViewer.getCheckedElements();
                return new AbstractList<ScriptTargetMapping>(){

                    @Override
                    public ScriptTargetMapping get(int index) {
                        return (ScriptTargetMapping)array[index];
                    }

                    @Override
                    public int size() {
                        return array.length;
                    }
                };
            }

            @Override
            public void selectAll() {
                tableViewer.setAllChecked(true);
            }

            @Override
            public void addListener(Logic.Listener listener) {
                listeners.add(listener);
            }

            @Override
            public void removeListener(Logic.Listener listener) {
                listeners.remove(listener);
            }
        };
    }

    public static <R> List<TableUtils.ColumnData<R, ?>> createLaunchTargetColumns(TableUtils.ValueAdapter<R, ConnectedTargetData> rowValueAdapter) {
        ArrayList result = new ArrayList(2);
        result.add(TableUtils.ColumnData.create(rowValueAdapter, new LaunchNameLabelProvider()));
        result.add(TableUtils.ColumnData.create(rowValueAdapter, new TargetNameLabelProvider()));
        return result;
    }

    private static class ContentProviderImpl
    implements IStructuredContentProvider {
        private ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            TableData input = (TableData)inputElement;
            return input.targets.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class LaunchNameLabelProvider
    extends TableUtils.ColumnLabelProvider<ConnectedTargetData> {
        private Map<ConnectedTargetData, Image> createdImages = new HashMap<ConnectedTargetData, Image>();

        private LaunchNameLabelProvider() {
        }

        @Override
        public Image getColumnImage(ConnectedTargetData connectedTargetData) {
            Image result = this.createdImages.get(connectedTargetData);
            if (result == null) {
                ImageDescriptor imageDescriptor = DebugUITools.getDefaultImageDescriptor((Object)connectedTargetData.getDebugTarget().getLaunch().getLaunchConfiguration());
                result = imageDescriptor.createImage();
                this.createdImages.put(connectedTargetData, result);
            }
            return result;
        }

        @Override
        public String getColumnText(ConnectedTargetData connectedTargetData) {
            return connectedTargetData.getDebugTarget().getLaunch().getLaunchConfiguration().getName();
        }

        @Override
        public TableColumn createColumn(Table table) {
            TableColumn launchCol = new TableColumn(table, 0);
            launchCol.setText(Messages.ChooseVmControl_LAUNCH);
            launchCol.setWidth(200);
            return launchCol;
        }

        @Override
        public void dispose() {
            for (Image image : this.createdImages.values()) {
                image.dispose();
            }
        }
    }

    public static interface Logic {
        public Control getControl();

        public void setData(List<? extends ScriptTargetMapping> var1);

        public List<ScriptTargetMapping> getSelected();

        public void selectAll();

        public void addListener(Listener var1);

        public void removeListener(Listener var1);

        public static interface Listener {
            public void checkStateChanged();
        }
    }

    private static class TableData {
        final List<? extends ScriptTargetMapping> targets;

        TableData(List<? extends ScriptTargetMapping> targets) {
            this.targets = targets;
        }
    }

    private static class TargetNameLabelProvider
    extends TableUtils.ColumnLabelProvider<ConnectedTargetData> {
        private TargetNameLabelProvider() {
        }

        @Override
        public Image getColumnImage(ConnectedTargetData connectedTargetData) {
            return null;
        }

        @Override
        public String getColumnText(ConnectedTargetData connectedTargetData) {
            return connectedTargetData.getName();
        }

        @Override
        public TableColumn createColumn(Table table) {
            TableColumn targetCol = new TableColumn(table, 0);
            targetCol.setText(Messages.ChooseVmControl_TARGET);
            targetCol.setWidth(200);
            return targetCol;
        }
    }
}

