/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.generic;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.generic.AbstractContainer;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public final class AbstractContainerRequestValidator
implements ILayoutRequestValidator {
    private final AbstractContainer m_container;

    public AbstractContainerRequestValidator(AbstractContainer container) {
        this.m_container = container;
    }

    @Override
    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        Object newObject = request.getNewObject();
        return this.m_container.validateComponent(newObject);
    }

    @Override
    public boolean validatePasteRequest(EditPart host, final PasteRequest request) {
        return ExecutionUtils.runObjectLog(new RunnableObjectEx<Boolean>(){

            @Override
            public Boolean runObject() throws Exception {
                List mementos = (List)request.getMemento();
                for (Object memento : mementos) {
                    Object component = GlobalState.getValidatorHelper().getPasteComponent(memento);
                    if (AbstractContainerRequestValidator.this.m_container.validateComponent(component)) continue;
                    return false;
                }
                return true;
            }
        }, false);
    }

    @Override
    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        return this.validateComponents(request);
    }

    @Override
    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        return this.validateComponents(request);
    }

    private boolean validateComponents(ChangeBoundsRequest request) {
        for (EditPart editPart : request.getEditParts()) {
            Object object = editPart.getModel();
            if (this.m_container.validateComponent(object)) continue;
            return false;
        }
        return true;
    }
}

