/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.services.contexts.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.listener.ModelAdapter;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.services.contexts.interfaces.IContextService;
import org.eclipse.tcf.te.tcf.services.contexts.internal.ContextServiceAdapter;

public class AdapterFactory
implements IAdapterFactory {
    Map<IPeer, IContextService> adapters = new HashMap<IPeer, IContextService>();
    private static final Class<?>[] CLASSES = new Class[]{IContextService.class};

    public AdapterFactory() {
        ModelAdapter listener = new ModelAdapter(){

            public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
                IContextService adapter;
                if (peerNode != null && peerNode.getPeer() != null && !added && (adapter = AdapterFactory.this.adapters.remove(peerNode.getPeer())) instanceof IDisposable) {
                    ((IDisposable)adapter).dispose();
                }
            }
        };
        Runnable runnable = new Runnable((IPeerModelListener)listener){
            private final /* synthetic */ IPeerModelListener val$listener;
            {
                this.val$listener = iPeerModelListener;
            }

            @Override
            public void run() {
                ModelManager.getPeerModel().addListener(this.val$listener);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IPeer) {
            IContextService adapter = this.adapters.get(adaptableObject);
            if (adapter == null) {
                adapter = new ContextServiceAdapter((IPeer)adaptableObject);
                this.adapters.put((IPeer)adaptableObject, adapter);
            }
            return adapter;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

