/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.action;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.ui.action.Messages;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Section;

public class ChangeAttachmentJob
extends Job {
    private final ITaskAttachment attachment;
    private final TaskEditor editor;
    private IStatus error;

    public ChangeAttachmentJob(ITaskAttachment attachment, TaskEditor editor) {
        super(Messages.UpdateAttachmentJob_update_attachment);
        this.attachment = attachment;
        this.editor = editor;
    }

    public IStatus getError() {
        return this.error;
    }

    public IStatus run(IProgressMonitor monitor) {
        ITask task = this.editor.getTaskEditorInput().getTask();
        if (!task.getConnectorKind().equals("bugzilla")) {
            return Status.OK_STATUS;
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
        monitor.beginTask(Messages.UpdateAttachmentJob_update_attachments, 20);
        try {
            try {
                ((BugzillaTaskDataHandler)connector.getTaskDataHandler()).postUpdateAttachment(this.attachment.getTaskRepository(), this.attachment.getTaskAttribute(), "update", monitor);
                monitor.worked(10);
                if (this.attachment != null) {
                    if (connector != null) {
                        TasksUiInternal.synchronizeTask((AbstractRepositoryConnector)connector, (ITask)task, (boolean)true, (IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                                    try {
                                        if (ChangeAttachmentJob.this.editor != null) {
                                            IFormPage formPage;
                                            ChangeAttachmentJob.this.editor.refreshPages();
                                            ChangeAttachmentJob.this.editor.getEditorSite().getPage().activate((IWorkbenchPart)ChangeAttachmentJob.this.editor);
                                            IFormPage iFormPage = formPage = ChangeAttachmentJob.this.editor.getActivePageInstance();
                                            if (iFormPage instanceof BugzillaTaskEditorPage) {
                                                void bugzillaPage;
                                                Control control;
                                                BugzillaTaskEditorPage bugzillaTaskEditorPage = (BugzillaTaskEditorPage)iFormPage;
                                                BugzillaTaskEditorPage cfr_ignored_0 = (BugzillaTaskEditorPage)iFormPage;
                                                Control control2 = control = bugzillaPage.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.attachments").getControl();
                                                if (control2 instanceof Section) {
                                                    void section;
                                                    Section section2 = (Section)control2;
                                                    Section cfr_ignored_1 = (Section)control2;
                                                    CommonFormUtil.setExpanded((ExpandableComposite)section, (boolean)true);
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        if (ChangeAttachmentJob.this.editor != null) {
                                            ChangeAttachmentJob.this.editor.showBusy(false);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    monitor.worked(10);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        if (this.editor != null) {
                            this.editor.showBusy(true);
                        }
                    });
                }
            }
            catch (OperationCanceledException e) {
                IStatus iStatus = Status.CANCEL_STATUS;
                monitor.done();
                return iStatus;
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Update of an Attachment failed", (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

