/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.ui.internal;

import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.modisco.workflow.core.WorkflowModel;
import org.eclipse.modisco.workflow.core.WorkflowModelListener;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowController;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowControllerImpl;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowModelImpl;
import org.eclipse.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.modisco.workflow.ui.internal.Activator;
import org.eclipse.modisco.workflow.ui.internal.AdditionalButtonsComposite;
import org.eclipse.modisco.workflow.ui.internal.Messages;
import org.eclipse.modisco.workflow.ui.internal.WorkflowTableContextMenu;
import org.eclipse.modisco.workflow.ui.internal.wizard.WizardToSelectLaunchers;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class WorkflowTab
extends AbstractLaunchConfigurationTab
implements WorkflowModelListener {
    private static final int HEIGHT = 200;
    private static final int WIDTH = 400;
    private TableViewer tableViewer;
    private WorkflowTableContextMenu popUp;
    private WorkflowModel workflowModel;
    private final WorkflowController workflowController;
    private boolean isValid;

    public WorkflowTab() {
        this.initWorkflowModel();
        this.workflowController = new WorkflowControllerImpl();
    }

    final WorkflowModel getWorkflowModel() {
        return this.workflowModel;
    }

    public void createControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        rootContainer.setLayout((Layout)layout);
        int nColumns = 3;
        layout.numColumns = 3;
        int verticalSpacing = 9;
        layout.verticalSpacing = 9;
        Label labelWFTransfo = new Label(rootContainer, 0);
        labelWFTransfo.setText(Messages.WorkflowTab_basicLabel);
        GridData gdLabel = new GridData();
        gdLabel.horizontalSpan = 3;
        labelWFTransfo.setLayoutData((Object)gdLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.tableViewer = new TableViewer(rootContainer, 2564);
        this.tableViewer.setContentProvider(WorkflowTab.getContentProvider());
        this.tableViewer.setLabelProvider(WorkflowTab.getLabelProvider());
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)gridData);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                int rightButton = 3;
                if (evt.button == 3) {
                    WorkflowTab.this.setupContextMenu(evt);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    WorkflowTab.this.removeWork();
                }
            }
        });
        AdditionalButtonsComposite buttonsComposite = new AdditionalButtonsComposite(rootContainer, 0, this);
        this.setControl((Control)rootContainer);
    }

    private static IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List elements = (List)inputElement;
                    return elements.toArray();
                }
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    private static IBaseLabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof Element) {
                    Element element = (Element)object;
                    return element.getName();
                }
                return null;
            }

            public Image getImage(Object object) {
                if (object instanceof Element) {
                    Element element = (Element)object;
                    return DebugUITools.getImage((String)element.getType());
                }
                return null;
            }
        };
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    protected final void setupContextMenu(MouseEvent evt) {
        Point p = new Point(evt.x, evt.y);
        TableItem item = this.getTable().getItem(p);
        if (item == null) {
            this.getPopUp().createPopupMenuNoSelectionItem(this.getShell());
            this.getTable().setMenu(this.getPopUp().getMenuNoSelection());
        } else {
            this.getPopUp().createPopupMenuSelectionItem(this.getShell());
            this.getTable().setMenu(this.getPopUp().getMenuSelection());
        }
    }

    public WorkflowTableContextMenu getPopUp() {
        if (this.popUp == null) {
            this.popUp = new WorkflowTableContextMenu(this);
        }
        return this.popUp;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initWorkflowModel();
        this.workflowModel.initialize(configuration);
        this.updateStatus();
        this.getTableViewer().setInput((Object)this.workflowModel.getAllElements());
    }

    private final void initWorkflowModel() {
        if (this.workflowModel != null) {
            this.workflowModel.removeListener((WorkflowModelListener)this);
        }
        this.workflowModel = new WorkflowModelImpl();
        this.workflowModel.addListener((WorkflowModelListener)this);
    }

    private final void updateStatus() {
        this.setMessage(Messages.WorkflowTab_basicLabel);
        this.isValid = true;
        String errorMessage = this.workflowController.validate(this.workflowModel);
        if (errorMessage != null) {
            this.isValid = false;
        }
        this.setErrorMessage(errorMessage);
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.workflowModel.save(configuration);
    }

    public String getName() {
        return Messages.WorkflowTab_name;
    }

    public void elementAdded(Element element) {
        this.refreshTable();
        this.updateStatus();
    }

    private final void refreshTable() {
        this.getTableViewer().refresh();
    }

    public void elementInserted(int index, Element element) {
        this.getTable().select(index);
        this.refreshTable();
        this.updateStatus();
    }

    public void elementRemoved(int index) {
        this.refreshTable();
        this.updateStatus();
    }

    public Image getImage() {
        return Activator.getImageDescriptor("icons/workflow16x16.png").createImage();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.isValid;
    }

    public void loadAdditionalWork() {
        WizardToSelectLaunchers wizard = new WizardToSelectLaunchers(this.workflowModel);
        WizardDialog dialog = new WizardDialog(PlatformUI.createDisplay().getActiveShell(), (IWizard)wizard);
        dialog.setPageSize(400, 200);
        dialog.open();
    }

    public void removeWork() {
        int index = this.getTable().getSelectionIndex();
        if (index != -1) {
            this.workflowModel.removeElement(index);
        }
    }

    public void moveWorkUp() {
        int index = this.getTable().getSelectionIndex();
        if (index > 0) {
            this.workflowModel.moveElementUp(index);
        }
    }

    public void moveWorkDown() {
        int index = this.getTable().getSelectionIndex();
        if (index >= 0 && index < this.getTable().getItemCount() - 1) {
            this.workflowModel.moveElementDown(index);
        }
    }
}

