/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class DebugTargetEventHandler
extends DebugEventHandler {
    public DebugTargetEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    @Override
    protected boolean handlesEvent(DebugEvent event) {
        return event.getSource() instanceof IDebugTarget;
    }

    @Override
    protected void handleChange(DebugEvent event) {
        int flags = 2048;
        if (event.getDetail() == 512) {
            flags |= 0x400;
        }
        this.fireDelta((IDebugTarget)event.getSource(), flags);
    }

    @Override
    protected void handleCreate(DebugEvent event) {
        this.fireDelta((IDebugTarget)event.getSource(), 0x100000);
    }

    @Override
    protected void handleResume(DebugEvent event) {
        this.fireDelta((IDebugTarget)event.getSource(), 0x200C00);
    }

    @Override
    protected void handleSuspend(DebugEvent event) {
        this.fireDelta((IDebugTarget)event.getSource(), 3072);
    }

    @Override
    protected void handleTerminate(DebugEvent event) {
        this.fireDelta((IDebugTarget)event.getSource(), 0x800C00);
    }

    private void fireDelta(IDebugTarget target, int flags) {
        ModelDelta root = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
        ModelDelta delta = root.addNode(target.getLaunch(), 0);
        delta.addNode(target, flags);
        this.fireDelta(root);
    }
}

