/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelEntityRelationshipFactory
extends AbstractStylingModelFactory {
    public GraphModelEntityRelationshipFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        if (!(viewer.getContentProvider() instanceof IGraphEntityRelationshipContentProvider)) {
            throw new IllegalArgumentException("Expected IGraphEntityRelationshipContentProvider");
        }
    }

    @Override
    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    @Override
    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object[] nodes = this.getContentProvider().getElements(this.getViewer().getInput());
        nodes = this.filter(this.getViewer().getInput(), nodes);
        this.createModelNodes(model, nodes);
        this.createModelRelationships(model);
    }

    private void createModelRelationships(Graph model) {
        GraphNode[] modelNodes = this.getNodesArray(model);
        ArrayList<GraphNode> listOfNodes = new ArrayList<GraphNode>();
        int i = 0;
        while (i < modelNodes.length) {
            listOfNodes.add(modelNodes[i]);
            ++i;
        }
        i = 0;
        while (i < listOfNodes.size()) {
            GraphNode node = (GraphNode)((Object)listOfNodes.get(i));
            if (node instanceof GraphContainer) {
                List<GraphNode> childNodes = ((GraphContainer)node).getNodes();
                listOfNodes.addAll(childNodes);
            }
            ++i;
        }
        modelNodes = listOfNodes.toArray(new GraphNode[listOfNodes.size()]);
        IGraphEntityRelationshipContentProvider content = this.getCastedContent();
        int i2 = 0;
        while (i2 < modelNodes.length) {
            int j = 0;
            while (j < modelNodes.length) {
                Object[] rels = content.getRelationships(modelNodes[i2].getData(), modelNodes[j].getData());
                if (rels != null) {
                    rels = this.filter(this.getViewer().getInput(), rels);
                    int r = 0;
                    while (r < rels.length) {
                        this.createConnection(model, rels[r], modelNodes[i2].getData(), modelNodes[j].getData());
                        ++r;
                    }
                }
                ++j;
            }
            ++i2;
        }
    }

    private void createModelNodes(Graph model, Object[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            this.createNode(model, nodes[i]);
            ++i;
        }
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    @Override
    public void refresh(Graph graph, Object element, boolean updateLabels) {
        this.refreshGraph(graph);
    }

    private IGraphEntityRelationshipContentProvider getCastedContent() {
        return (IGraphEntityRelationshipContentProvider)this.getContentProvider();
    }
}

