/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.osgi.framework.BundleContext;

public final class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wb.core.databinding";
    private static Activator m_plugin;
    private static final Map<String, Image> m_nameToIconMap;

    static {
        m_nameToIconMap = new HashMap<String, Image>();
    }

    public void stop(BundleContext context) throws Exception {
        m_plugin = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
    }

    public static Activator getDefault() {
        return m_plugin;
    }

    public static InputStream getFile(final String path) {
        return (InputStream)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<InputStream>(){

            public InputStream runObject() throws Exception {
                return m_plugin.getBundle().getEntry(path).openStream();
            }
        }, (String)"Unable to open plugin file %s", (Object[])new Object[]{path});
    }

    public static Image getImage(String name) {
        Image image = m_nameToIconMap.get(name);
        if (image == null) {
            Object path = name.startsWith("/") ? name : "icons/" + name;
            InputStream is = Activator.getFile((String)path);
            try {
                image = new Image((Device)Display.getCurrent(), is);
                m_nameToIconMap.put(name, image);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        URL url = m_plugin.getBundle().getEntry("icons/" + name);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static IPreferenceStore getStore() {
        return m_plugin.getPreferenceStore();
    }
}

