/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tools.templates.ui.NewWizard;
import org.eclipse.tools.templates.ui.TemplateWizard;
import org.eclipse.tools.templates.ui.internal.Activator;
import org.eclipse.tools.templates.ui.internal.Tag;
import org.eclipse.tools.templates.ui.internal.TagListViewer;
import org.eclipse.tools.templates.ui.internal.Template;
import org.eclipse.tools.templates.ui.internal.TemplateExtension;
import org.eclipse.tools.templates.ui.internal.TemplateTable;
import org.eclipse.ui.INewWizard;

public class TemplateSelectionPage
extends WizardPage {
    private final String[] requestedTags;
    private final List<Template> templates;
    private TagListViewer tagList;
    private TemplateTable templateTable;

    public TemplateSelectionPage(String pageName, String ... tags) {
        super(pageName);
        this.requestedTags = tags;
        TemplateExtension templateExtension = Activator.getTemplateExtension();
        this.templates = new ArrayList<Template>();
        block0: for (Template template : templateExtension.getTemplates()) {
            String[] stringArray = this.requestedTags;
            int n = this.requestedTags.length;
            int n2 = 0;
            while (n2 < n) {
                String requestedTag = stringArray[n2];
                if (template.hasTag(requestedTag)) {
                    this.templates.add(template);
                    continue block0;
                }
                ++n2;
            }
        }
    }

    public void createControl(Composite parent) {
        SashForm form = new SashForm(parent, 256);
        this.setControl((Control)form);
        this.tagList = new TagListViewer((Composite)form, 2048);
        this.tagList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Collection<Tag> selectedTags = TemplateSelectionPage.this.tagList.getSelectedTags();
                ArrayList<Template> selectedTemplates = new ArrayList<Template>();
                block0: for (Template template : TemplateSelectionPage.this.templates) {
                    for (Tag tag : selectedTags) {
                        if (!template.hasTag(tag.getId())) continue;
                        selectedTemplates.add(template);
                        continue block0;
                    }
                }
                Template selected = TemplateSelectionPage.this.templateTable.getSelectedTemplate();
                TemplateSelectionPage.this.templateTable.setTemplates(selectedTemplates);
                TemplateSelectionPage.this.templateTable.selectTemplate(selected);
                TemplateSelectionPage.this.updateButtons();
            }
        });
        this.templateTable = new TemplateTable((Composite)form, 2564);
        this.templateTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateSelectionPage.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                TemplateSelectionPage.this.getContainer().showPage(TemplateSelectionPage.this.getNextPage());
            }
        });
        HashSet<Tag> tags = new HashSet<Tag>();
        for (Template template : this.templates) {
            tags.addAll(template.getTags());
        }
        if (this.requestedTags.length == 1) {
            for (Tag tag : tags) {
                if (!tag.getId().equals(this.requestedTags[0])) continue;
                tags.remove(tag);
                break;
            }
        }
        this.templateTable.setTemplates(this.templates);
        this.tagList.setInput(tags);
        this.tagList.getList().select(0);
        form.setWeights(new int[]{20, 80});
    }

    public void selectTemplate(String id) {
        if (this.templateTable != null) {
            for (Template template : this.templates) {
                if (!template.getId().equals(id)) continue;
                this.templateTable.selectTemplate(template);
                this.updateButtons();
                break;
            }
        }
    }

    private void updateButtons() {
        this.setPageComplete(this.templateTable.getSelectedTemplate() != null);
        this.getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        Template template = this.templateTable.getSelectedTemplate();
        if (template != null) {
            try {
                NewWizard oldWizard = (NewWizard)this.getWizard();
                TemplateWizard nextWizard = (TemplateWizard)template.getWizard();
                oldWizard.initialize((INewWizard)nextWizard);
                nextWizard.addPages();
                return nextWizard.getPages()[0];
            }
            catch (CoreException e) {
                Platform.getLog(((Object)((Object)this)).getClass()).log(e.getStatus());
            }
        }
        return super.getNextPage();
    }

    public void dispose() {
        if (this.templateTable != null) {
            this.templateTable.dispose();
            this.templateTable = null;
        }
        super.dispose();
    }
}

