/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.activator;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.preferences.ScopedEclipsePreferences;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.editor.EditorPeerModelListener;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;
    private static volatile ScopedEclipsePreferences scopedPreferences;
    private IWorkbenchListener listener;
    final ListenerList listeners = new ListenerList();
    IPeerModelListener peerModelListener = null;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tcf.te.tcf.ui";
    }

    public static ScopedEclipsePreferences getScopedPreferences() {
        if (scopedPreferences == null) {
            scopedPreferences = new ScopedEclipsePreferences(UIPlugin.getUniqueIdentifier());
        }
        return scopedPreferences;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                Object[] candidates;
                boolean proceedShutdown = true;
                Object[] objectArray = candidates = UIPlugin.this.listeners.getListeners();
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    if (listener instanceof IWorkbenchListener && !(proceedShutdown &= ((IWorkbenchListener)listener).preShutdown(workbench, forced)) && !forced) break;
                    ++n2;
                }
                if (proceedShutdown || forced) {
                    IPeerModel model = ModelManager.getPeerModel((boolean)true);
                    if (model != null) {
                        final ArrayList<IPeerNode> peerNodes = new ArrayList<IPeerNode>();
                        IPeerNode[] iPeerNodeArray = model.getPeerNodes();
                        int n3 = iPeerNodeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPeerNode peerNode = iPeerNodeArray[n4];
                            if (peerNode.isConnectStateChangeActionAllowed(1)) {
                                peerNodes.add(peerNode);
                            }
                            ++n4;
                        }
                        if (!peerNodes.isEmpty()) {
                            IRunnableWithProgress dialogRunnable = new IRunnableWithProgress(){

                                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    ProgressHelper.setTaskName((IProgressMonitor)monitor, (String)"Disconnecting Connections...");
                                    final AsyncCallbackCollector collector = new AsyncCallbackCollector();
                                    Protocol.invokeAndWait((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            for (IPeerNode peerNode : peerNodes) {
                                                if (!peerNode.isConnectStateChangeActionAllowed(1)) continue;
                                                peerNode.changeConnectState(1, (ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector), null);
                                            }
                                            collector.initDone();
                                        }
                                    });
                                    ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)new IConditionTester(){

                                        public boolean isConditionFulfilled() {
                                            return collector.getConditionTester().isConditionFulfilled() || monitor != null && monitor.isCanceled();
                                        }

                                        public void cleanup() {
                                        }
                                    });
                                }
                            };
                            ProgressMonitorDialog dialog = new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell());
                            try {
                                dialog.run(true, true, dialogRunnable);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    Tcf.getChannelManager().closeAll(!Protocol.isDispatchThread());
                }
                return proceedShutdown;
            }

            public void postShutdown(IWorkbench workbench) {
                Object[] candidates;
                Object[] objectArray = candidates = UIPlugin.this.listeners.getListeners();
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    if (listener instanceof IWorkbenchListener) {
                        ((IWorkbenchListener)listener).postShutdown(workbench);
                    }
                    ++n2;
                }
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.listener);
        this.peerModelListener = new EditorPeerModelListener();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ModelManager.getPeerModel().addListener(UIPlugin.this.peerModelListener);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        if (this.listener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.listener);
            this.listener = null;
        }
        if (this.peerModelListener != null) {
            ModelManager.getPeerModel().removeListener(this.peerModelListener);
            this.peerModelListener = null;
        }
        plugin = null;
        scopedPreferences = null;
        super.stop(context);
    }

    public void addListener(IWorkbenchListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    public void removeListener(IWorkbenchListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.remove((Object)listener);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        URL url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/peer.gif");
        registry.put("PeerObject", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/peer_discovered.gif");
        registry.put("PeerObjectDiscovered", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/peer.gif");
        registry.put("PeerObjectStatic", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/targets_view.gif");
        registry.put("SystemMgmtView", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/connection.gif");
        registry.put("ConnectionObject", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/elcl16/newTarget_wiz.gif");
        registry.put("NewPeerObject", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/busy.gif");
        registry.put("BusyOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/gold_ovr.gif");
        registry.put("GoldOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/warning_ovr.gif");
        registry.put("WarningOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/green_ovr.gif");
        registry.put("GreenOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/grey_ovr.gif");
        registry.put("GreyOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/red_ovr.gif");
        registry.put("RedOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/redX_ovr.gif");
        registry.put("RedXOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/link_ovr.gif");
        registry.put("LinkOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/etool16/newConfig.gif");
        registry.put("NewConfig", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Image getSharedImage(AbstractImageDescriptor descriptor) {
        String imageKey;
        ImageRegistry registry = UIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(imageKey = descriptor.getDecriptorKey());
        if (image == null) {
            registry.put(imageKey, (ImageDescriptor)descriptor);
            image = registry.get(imageKey);
        }
        return image;
    }
}

