/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class AnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        String[] messages = this.getMessagesForLine(sourceViewer, lineNumber);
        if (messages.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < messages.length) {
            buffer.append(messages[i]);
            if (i < messages.length - 1) {
                buffer.append(System.lineSeparator());
            }
            ++i;
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String[] getMessagesForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return new String[0];
        }
        ArrayList<String> messages = new ArrayList<String>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            String descr;
            IMarker marker;
            String message;
            void annotation;
            Annotation object = (Annotation)iter.next();
            Annotation annotation2 = object;
            if (!(annotation2 instanceof MarkerAnnotation)) continue;
            MarkerAnnotation cfr_ignored_0 = (MarkerAnnotation)annotation2;
            MarkerAnnotation cfr_ignored_1 = (MarkerAnnotation)annotation2;
            if (!this.compareRulerLine(model.getPosition((Annotation)annotation), document, line) || (message = (marker = annotation.getMarker()).getAttribute("message", null)) == null || message.trim().length() <= 0) continue;
            String problemKind = marker.getAttribute("version", null);
            if (problemKind != null && (descr = marker.getAttribute("description", null)) != null && !descr.isEmpty()) {
                message = NLS.bind((String)PDEUIMessages.AnnotationHover_version_change, (Object[])new String[]{message, descr});
            }
            messages.add(message);
        }
        return messages.toArray(new String[messages.size()]);
    }

    private boolean compareRulerLine(Position position, IDocument document, int line) {
        try {
            if (position.getOffset() > -1 && position.getLength() > -1) {
                return document.getLineOfOffset(position.getOffset()) == line;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

