/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.api.tools.internal.ApiDescriptionProcessor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiToolingSetupRefactoring;
import org.eclipse.pde.api.tools.ui.internal.wizards.ProjectUpdateChange;
import org.eclipse.pde.api.tools.ui.internal.wizards.StringFilter;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ApiToolingSetupWizardPage
extends UserInputWizardPage {
    private static final String SETTINGS_SECTION = "ApiToolingSetupWizardPage";
    private static final String SETTINGS_REMOVECXML = "remove_componentxml";
    CheckboxTableViewer tableviewer = null;
    HashSet<Object> checkedset = new HashSet();
    Button removecxml = null;
    UpdateJob updatejob = new UpdateJob();
    StringFilter filter = new StringFilter();
    private Text checkcount = null;

    protected ApiToolingSetupWizardPage() {
        super(WizardMessages.UpdateJavadocTagsWizardPage_4);
        this.setTitle(WizardMessages.UpdateJavadocTagsWizardPage_4);
        this.setMessage(WizardMessages.UpdateJavadocTagsWizardPage_7);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.API_TOOLING_SETUP_WIZARD_PAGE);
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_6, 1, 100);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiToolingSetupWizardPage_6, 1, 50);
        Text text = SWTFactory.createText(comp, 2048, 1);
        text.addModifyListener(e -> {
            this.updatejob.setFilter(text.getText().trim());
            this.updatejob.cancel();
            this.updatejob.schedule();
        });
        text.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 0x1000002 && this.tableviewer != null) {
                this.tableviewer.getTable().setFocus();
            }
        }));
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_8, 1, 50);
        Table table = new Table(comp, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableviewer.setInput((Object)this.getInputProjects());
        this.tableviewer.setComparator(new ViewerComparator());
        this.tableviewer.addFilter((ViewerFilter)this.filter);
        this.tableviewer.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.checkedset.add(event.getElement());
            } else {
                this.checkedset.remove(event.getElement());
            }
            this.setPageComplete(this.pageValid());
        });
        Composite bcomp = SWTFactory.createComposite(comp, 3, 1, 771, 0, 0);
        Button button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_10, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.tableviewer.setAllChecked(true);
            this.checkedset.addAll(Arrays.asList(this.tableviewer.getCheckedElements()));
            this.setPageComplete(this.pageValid());
        }));
        button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_11, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items;
            this.tableviewer.setAllChecked(false);
            TableItem[] tableItemArray = items = this.tableviewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                this.checkedset.remove(item.getData());
                ++n2;
            }
            this.setPageComplete(this.pageValid());
        }));
        this.checkcount = SWTFactory.createText(bcomp, 0x800008, 1, 640);
        this.checkcount.setBackground(bcomp.getBackground());
        Object[] selected = this.getWorkbenchSelection();
        if (selected.length > 0) {
            this.tableviewer.setCheckedElements(selected);
            this.checkedset.addAll(Arrays.asList(selected));
        }
        this.setPageComplete(this.checkedset.size() > 0);
        SWTFactory.createVerticalSpacer(comp, 1);
        this.removecxml = SWTFactory.createCheckButton(comp, WizardMessages.ApiToolingSetupWizardPage_0, null, true, 1);
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings != null) {
            this.removecxml.setSelection(settings.getBoolean(SETTINGS_REMOVECXML));
        }
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        this.updateCheckStatus(this.checkedset.size());
    }

    private void updateCheckStatus(int count) {
        if (this.checkcount == null) {
            return;
        }
        this.checkcount.setText(MessageFormat.format(WizardMessages.ApiToolingSetupWizardPage_n_items_checked, Integer.toString(count)));
    }

    private IProject[] getInputProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> pjs = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (this.acceptProject(project)) {
                    pjs.add(project);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return pjs.toArray(new IProject[pjs.size()]);
    }

    private boolean acceptProject(IProject project) throws CoreException {
        if (project == null) {
            return false;
        }
        return project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature") && !project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature") && !Util.isBinaryProject((IProject)project);
    }

    protected Object[] getWorkbenchSelection() {
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            Object[] jps = ((IStructuredSelection)provider.getSelection()).toArray();
            ArrayList<IProject> pjs = new ArrayList<IProject>();
            Object[] objectArray = jps;
            int n = jps.length;
            int n2 = 0;
            while (n2 < n) {
                Object jp = objectArray[n2];
                if (jp instanceof IAdaptable) {
                    IAdaptable adapt = (IAdaptable)jp;
                    IProject pj = (IProject)adapt.getAdapter(IProject.class);
                    try {
                        if (this.acceptProject(pj)) {
                            pjs.add(pj);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n2;
            }
            return pjs.toArray();
        }
        return new Object[0];
    }

    protected boolean pageValid() {
        if (this.checkedset.size() < 1) {
            this.setErrorMessage(WizardMessages.UpdateJavadocTagsWizardPage_12);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IWizardPage getNextPage() {
        this.collectChanges();
        IWizardPage page = super.getNextPage();
        if (page != null) {
            page.setDescription(WizardMessages.ApiToolingSetupWizardPage_5);
        }
        return page;
    }

    void createTagChanges(CompositeChange projectchange, IJavaProject project, File cxml) {
        try {
            HashMap map = new HashMap();
            ApiDescriptionProcessor.collectTagUpdates((IJavaProject)project, (File)cxml, map);
            IFile file = null;
            TextFileChange change = null;
            MultiTextEdit multiedit = null;
            Set alledits = null;
            for (Map.Entry entry : map.entrySet()) {
                file = (IFile)entry.getKey();
                change = new TextFileChange(MessageFormat.format(WizardMessages.JavadocTagRefactoring_2, file.getName()), file);
                multiedit = new MultiTextEdit();
                change.setEdit((TextEdit)multiedit);
                alledits = (Set)entry.getValue();
                if (alledits != null) {
                    for (TextEdit edit : alledits) {
                        multiedit.addChild(edit);
                    }
                }
                projectchange.add((Change)change);
            }
        }
        catch (IOException | CoreException e) {
            ApiUIPlugin.log(e);
        }
    }

    private void collectChanges() {
        ApiToolingSetupRefactoring refactoring = (ApiToolingSetupRefactoring)this.getRefactoring();
        IRunnableWithProgress op = monitor -> {
            IProject[] projects = this.checkedset.toArray(new IProject[this.checkedset.size()]);
            IProject project = null;
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor);
            localmonitor.beginTask("", projects.length);
            localmonitor.setTaskName(WizardMessages.ApiToolingSetupWizardPage_7);
            refactoring.resetRefactoring();
            boolean remove = this.removecxml.getSelection();
            CompositeChange pchange = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project2;
                project = project2 = iProjectArray[n2];
                pchange = new CompositeChange(project.getName());
                refactoring.addChange((Change)pchange);
                pchange.add((Change)new ProjectUpdateChange(project));
                localmonitor.subTask(MessageFormat.format(WizardMessages.ApiToolingSetupWizardPage_4, project.getName()));
                IResource cxml = project.findMember("component.xml");
                if (cxml != null) {
                    this.createTagChanges(pchange, JavaCore.create((IProject)project), new File(cxml.getLocationURI()));
                    if (remove) {
                        pchange.add((Change)new DeleteResourceChange(cxml.getFullPath(), true));
                    }
                }
                localmonitor.split(1);
                ++n2;
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            ApiUIPlugin.log(e);
        }
    }

    protected boolean performFinish() {
        this.collectChanges();
        return super.performFinish();
    }

    public boolean finish() {
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION);
        settings.put(SETTINGS_REMOVECXML, this.removecxml.getSelection());
        this.notifyNoDefaultProfile();
        return true;
    }

    private void notifyNoDefaultProfile() {
        if (ApiPlugin.getDefault().getApiBaselineManager().getDefaultApiBaseline() == null) {
            UIJob job = UIJob.create((String)"No default API profile detected", monitor -> {
                String msg = WizardMessages.ApiToolingSetupWizardPage_2 + WizardMessages.ApiToolingSetupWizardPage_3;
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)WizardMessages.ApiToolingSetupWizardPage_1, (String)msg)) {
                    SWTFactory.showPreferencePage(this.getShell(), "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage", null);
                }
                return Status.OK_STATUS;
            });
            job.setSystem(true);
            job.schedule();
        }
    }

    class UpdateJob
    extends WorkbenchJob {
        private String pattern;

        public UpdateJob() {
            super(WizardMessages.ApiToolingSetupWizardPage_filter_update_job);
            this.pattern = null;
            this.setSystem(true);
        }

        public synchronized void setFilter(String pattern) {
            this.pattern = pattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (ApiToolingSetupWizardPage.this.tableviewer != null) {
                try {
                    ApiToolingSetupWizardPage.this.tableviewer.getTable().setRedraw(false);
                    UpdateJob updateJob = this;
                    synchronized (updateJob) {
                        ApiToolingSetupWizardPage.this.filter.setPattern(this.pattern + "*");
                    }
                    ApiToolingSetupWizardPage.this.tableviewer.refresh(true);
                    ApiToolingSetupWizardPage.this.tableviewer.setCheckedElements(ApiToolingSetupWizardPage.this.checkedset.toArray());
                }
                finally {
                    ApiToolingSetupWizardPage.this.tableviewer.getTable().setRedraw(true);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

