/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.restrictions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.api.restrictions.PermissionsExaminationService;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.base.agreements.AgreementAssessmentService;
import org.eclipse.passage.lic.base.agreements.UnacceptedAgreementRestriction;
import org.eclipse.passage.lic.base.diagnostic.code.InsufficientLicenseCoverage;
import org.eclipse.passage.lic.base.restrictions.BaseExaminationCertificate;
import org.eclipse.passage.lic.base.restrictions.BaseRestriction;

public final class BasePermissionsExaminationService
implements PermissionsExaminationService {
    private final StringServiceId id = new StringServiceId("base-permissions-examination-service");
    private final AgreementAcceptanceService acceptance;
    private final LicensedProduct product;

    public BasePermissionsExaminationService(AgreementAcceptanceService acceptance, Supplier<LicensedProduct> product) {
        this.acceptance = acceptance;
        this.product = product.get();
    }

    public StringServiceId id() {
        return this.id;
    }

    public ExaminationCertificate examine(Collection<Requirement> requirements, Collection<Permission> permissions) {
        Objects.requireNonNull(requirements);
        Objects.requireNonNull(permissions);
        Objects.requireNonNull(this.product);
        HashMap<Requirement, Permission> active = new HashMap<Requirement, Permission>();
        Collection<AgreementToAccept> agreements = this.agreements(requirements);
        return new BaseExaminationCertificate(active, this.assessFeature(requirements, permissions, agreements, active), agreements);
    }

    private Collection<AgreementToAccept> agreements(Collection<Requirement> requirements) {
        return new AgreementAssessmentService(requirements, this.acceptance).assessment();
    }

    private List<Restriction> assessFeature(Collection<Requirement> requirements, Collection<Permission> permissions, Collection<AgreementToAccept> agreements, Map<Requirement, Permission> active) {
        List<Restriction> uncovered = this.insufficientCoverage(requirements, permissions, active);
        List<Restriction> unaccepted = this.unacceptedAgreements(agreements);
        return Stream.of(uncovered, unaccepted).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Restriction> insufficientCoverage(Collection<Requirement> requirements, Collection<Permission> permissions, Map<Requirement, Permission> active) {
        return requirements.stream().collect(Collectors.groupingBy(Requirement::feature)).values().stream().map(v -> this.insufficientLicenseCoverage((Collection<Requirement>)v, permissions, active)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<Restriction> insufficientLicenseCoverage(Collection<Requirement> requirements, Collection<Permission> permissions, Map<Requirement, Permission> active) {
        return requirements.stream().filter(requirement -> this.notCovered((Requirement)requirement, permissions, active)).map(this::insufficientLicenseCoverage).collect(Collectors.toList());
    }

    private boolean notCovered(Requirement requirement, Collection<Permission> permissions, Map<Requirement, Permission> active) {
        Optional<Permission> satisfied = permissions.stream().filter(permission -> this.sameFeature(requirement, (Permission)permission)).filter(permission -> this.versionMatches(requirement, (Permission)permission)).findAny();
        if (satisfied.isPresent()) {
            active.put(requirement, satisfied.get());
        }
        return !satisfied.isPresent();
    }

    private boolean sameFeature(Requirement requirement, Permission permission) {
        return requirement.feature().identifier().equals(permission.condition().feature());
    }

    private boolean versionMatches(Requirement requirement, Permission permission) {
        return permission.condition().versionMatch().rule().match(requirement.feature().version(), permission.condition().versionMatch().version());
    }

    private Restriction insufficientLicenseCoverage(Requirement requirement) {
        return new BaseRestriction(this.product, requirement, new InsufficientLicenseCoverage());
    }

    private List<Restriction> unacceptedAgreements(Collection<AgreementToAccept> agreements) {
        return agreements.stream().filter(agreement -> !agreement.acceptance().accepted()).map(agreement -> new UnacceptedAgreementRestriction(this.product, (AgreementToAccept)agreement).get()).collect(Collectors.toList());
    }
}

