/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.CherryPickRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.gerrit.ui.operations.BranchProposalProvider;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class CherryPickDialog
extends GerritOperationDialog {
    private PatchSet patchSet;
    private GerritChange change;
    private RichTextEditor commitMessage;
    private Text destination;

    public CherryPickDialog(Shell parentShell, ITask task) {
        super(parentShell, task);
    }

    public CherryPickDialog(Shell shell, ITask task, PatchSet patchSet, GerritChange gerritChange) {
        super(shell, task);
        this.patchSet = patchSet;
        this.change = gerritChange;
    }

    @Override
    public GerritOperation<?> createOperation() {
        int patchSetId = this.patchSet.getId().get();
        CherryPickRequest request = new CherryPickRequest(this.task.getTaskId(), patchSetId, this.getDestination());
        request.setMessage(this.commitMessage.getText());
        return GerritUiPlugin.getDefault().getOperationFactory().createOperation(this.task, (AbstractRequest)request);
    }

    private String getDestination() {
        return this.destination.getText();
    }

    protected Control createPageControls(Composite parent) {
        this.setTitle(Messages.CherryPickDialog_Cherry_Pick);
        this.setMessage(NLS.bind((String)Messages.CherryPickDialog_Change_X_Set_Y, (Object)this.task.getTaskId(), (Object)this.patchSet.getPatchSetId()));
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        Label branchlabel = new Label(composite, 0);
        branchlabel.setText(NLS.bind((String)Messages.CherryPickDialog_Cherry_Pick_to_Branch, (Object)this.patchSet.getRefName()));
        this.destination = new Text(composite, 18436);
        GridDataFactory.swtDefaults().align(4, 4).applyTo((Control)this.destination);
        Label commitLabel = new Label(composite, 0);
        commitLabel.setText(NLS.bind((String)Messages.CherryPickDialog_Cherry_Pick_Commit_Message, (Object)this.patchSet.getRefName()));
        this.commitMessage = this.createRichTextEditor(composite, "");
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 100).applyTo(this.commitMessage.getControl());
        this.commitMessage.setText(this.getCommitMessage());
        this.destination.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CherryPickDialog.this.updateButtons();
            }
        });
        this.commitMessage.getViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                CherryPickDialog.this.updateButtons();
            }
        });
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.destination, (IControlContentAdapter)new TextContentAdapter(), this.createContentProposalProvider(), "org.eclipse.ui.edit.text.contentAssist.proposals", null, true);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setAutoActivationCharacters(null);
        this.destination.setFocus();
        return composite;
    }

    private String getCommitMessage() {
        List details = this.change.getPatchSetDetails();
        PatchSetDetail patchSetDetail = (PatchSetDetail)details.get(details.size() - 1);
        for (PatchSetDetail detail : details) {
            if (detail.getPatchSet() != this.patchSet) continue;
            patchSetDetail = detail;
        }
        return patchSetDetail.getInfo().getMessage();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setOKButtonEnabled(false);
        return control;
    }

    @Override
    protected boolean processOperationResult(GerritOperation<?> operation) {
        ChangeDetail changeDetail;
        if (operation != null && (changeDetail = (ChangeDetail)operation.getOperationResult()) != null && changeDetail.getChange() != null) {
            TasksUiUtil.openTask((TaskRepository)this.getRepository(), (String)("" + changeDetail.getChange().getChangeId()));
        }
        return super.processOperationResult(operation);
    }

    private void updateButtons() {
        boolean isSubmittable = StringUtils.isNotEmpty((CharSequence)this.destination.getText()) && StringUtils.isNotEmpty((CharSequence)this.commitMessage.getText());
        this.setOKButtonEnabled(isSubmittable);
    }

    private void setOKButtonEnabled(boolean enable) {
        this.getButton(0).setEnabled(enable);
    }

    private IContentProposalProvider createContentProposalProvider() {
        GerritClient client = ((GerritConnector)TasksUi.getRepositoryConnector((String)this.task.getConnectorKind())).getClient(this.getRepository());
        Set allProjectBranches = client.getCachedBranches(this.change.getChangeDetail().getChange().getProject());
        TreeSet<String> proposals = allProjectBranches != null ? new TreeSet<String>(allProjectBranches) : new TreeSet();
        return new BranchProposalProvider(proposals);
    }

    private TaskRepository getRepository() {
        return TasksUi.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
    }
}

