/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IContextListener;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextManager;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.CompositeContextElement;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.IRelationsListener;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.LegacyActivityAdaptor;
import org.eclipse.mylyn.internal.context.core.LocalContextStore;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class InteractionContextManager
implements IInteractionContextManager {
    public static final String SOURCE_ID_DECAY = "org.eclipse.mylyn.core.model.interest.decay";
    public static final String CONTEXT_FILE_EXTENSION_OLD = ".xml";
    public static final String CONTEXT_FILE_EXTENSION = ".xml.zip";
    public static final String CONTAINMENT_PROPAGATION_ID = "org.eclipse.mylyn.core.model.edges.containment";
    @Deprecated
    public static final String OLD_CONTEXT_HISTORY_FILE_NAME = "context-history";
    public static final String CONTEXT_HISTORY_FILE_NAME = "activity";
    public static final String CONTEXT_FILENAME_ENCODING = "UTF-8";
    public static final String PROPERTY_CONTEXT_ACTIVE = "org.eclipse.mylyn.context.core.context.active";
    public static final String ACTIVITY_STRUCTUREKIND_ACTIVATION = "activation";
    public static final String ACTIVITY_STRUCTUREKIND_TIMING = "timing";
    public static final String ACTIVITY_STRUCTUREKIND_WORKINGSET = "workingset";
    public static final String ACTIVITY_STRUCTUREKIND_LIFECYCLE = "lifecycle";
    public static final String ACTIVITY_ORIGINID_USER = "user";
    public static final String ACTIVITY_ORIGINID_OS = "os";
    public static final String ACTIVITY_ORIGINID_WORKBENCH = "org.eclipse.ui.workbench";
    public static final String ACTIVITY_HANDLE_NONE = "none";
    public static final String ACTIVITY_DELTA_STOPPED = "stopped";
    public static final String ACTIVITY_DELTA_STARTED = "started";
    public static final String ACTIVITY_DELTA_REMOVED = "removed";
    public static final String ACTIVITY_DELTA_ADDED = "added";
    public static final String ACTIVITY_DELTA_ACTIVATED = "activated";
    public static final String ACTIVITY_DELTA_DEACTIVATED = "deactivated";
    private static final int MAX_PROPAGATION = 17;
    private static final ILock metaContextLock = Job.getJobManager().newLock();
    private static final String PREFERENCE_ATTENTION_MIGRATED = "mylyn.attention.migrated";
    private static final String SOURCE_ID_DECAY_CORRECTION = "org.eclipse.mylyn.core.model.interest.decay.correction";
    private static final String SOURCE_ID_MODEL_ERROR = "org.eclipse.mylyn.core.model.interest.propagation";
    private static final String SOURCE_ID_MODEL_PROPAGATION = "org.eclipse.mylyn.core.model.interest.propagation";
    private boolean activationHistorySuppressed = false;
    private final CompositeInteractionContext activeContext = new CompositeInteractionContext(ContextCore.getCommonContextScaling());
    private InteractionContext activityMetaContext = null;
    private final List<IContextListener> activityMetaContextListeners = new CopyOnWriteArrayList<IContextListener>();
    private boolean contextCapturePaused = false;
    private final List<IContextListener> contextListeners = new CopyOnWriteArrayList<IContextListener>();
    private final List<String> errorElementHandles = new ArrayList<String>();
    private final Collection<IInteractionContext> globalContexts = new HashSet<IInteractionContext>();
    private int numInterestingErrors = 0;
    private boolean suppressListenerNotification = false;
    private final List<IContextListener> waitingContextListeners = new ArrayList<IContextListener>();
    private final LocalContextStore contextStore;

    public InteractionContextManager(LocalContextStore contextStore) {
        this.contextStore = contextStore;
    }

    @Override
    public void activateContext(String handleIdentifier) {
        try {
            IInteractionContext loadedContext = this.activeContext.getContextMap().get(handleIdentifier);
            final IInteractionContext context = loadedContext == null ? this.contextStore.loadContext(handleIdentifier) : loadedContext;
            ContextCorePlugin.getDefault().initContextContributor();
            for (final IContextListener listener : this.contextListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                    }

                    public void run() throws Exception {
                        ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.PRE_ACTIVATED, context.getHandleIdentifier(), context, null);
                        listener.contextChanged(event);
                    }
                });
            }
            this.suppressListenerNotification = true;
            this.internalActivateContext(context);
            this.suppressListenerNotification = false;
            this.contextListeners.addAll(this.waitingContextListeners);
            this.waitingContextListeners.clear();
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Could not activate context", t));
        }
    }

    public void addActivityMetaContextListener(AbstractContextListener listener) {
        this.activityMetaContextListeners.add(listener);
    }

    public void addAttentionEvents(Map<String, List<InteractionEvent>> attention, InteractionContext temp) {
        try {
            for (String handle : attention.keySet()) {
                List<InteractionEvent> activityEvents = attention.get(handle);
                List<Object> collapsedEvents = new ArrayList();
                if (activityEvents.size() > 1) {
                    collapsedEvents = this.collapseEventsByHour(activityEvents);
                } else if (activityEvents.size() == 1 && activityEvents.get(0).getEndDate().getTime() - activityEvents.get(0).getDate().getTime() > 0L) {
                    collapsedEvents.add(activityEvents.get(0));
                }
                if (!collapsedEvents.isEmpty()) {
                    for (InteractionEvent interactionEvent : collapsedEvents) {
                        temp.parseEvent(interactionEvent);
                    }
                }
                activityEvents.clear();
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Error during meta activity collapse", (Throwable)e));
        }
    }

    public void addErrorPredictedInterest(String handle, String kind, boolean notify) {
        if (this.numInterestingErrors > ((InteractionContextScaling)ContextCore.getCommonContextScaling()).getMaxNumInterestingErrors() || this.activeContext.getContextMap().isEmpty()) {
            return;
        }
        InteractionEvent errorEvent = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, kind, handle, "org.eclipse.mylyn.core.model.interest.propagation", ((InteractionContextScaling)ContextCore.getCommonContextScaling()).getErrorInterest());
        this.processInteractionEvent(errorEvent, true);
        this.errorElementHandles.add(handle);
        ++this.numInterestingErrors;
    }

    public void addGlobalContext(IInteractionContext context) {
        this.globalContexts.add(context);
    }

    private IInteractionElement addInteractionEvent(IInteractionContext interactionContext, InteractionEvent event) {
        if (interactionContext instanceof CompositeInteractionContext) {
            return ((CompositeInteractionContext)interactionContext).addEvent(event);
        }
        if (interactionContext instanceof InteractionContext) {
            return ((InteractionContext)interactionContext).parseEvent(event);
        }
        return null;
    }

    @Override
    public void addListener(AbstractContextListener listener) {
        this.addListener((IContextListener)listener);
    }

    @Override
    public void addListener(IContextListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.suppressListenerNotification && !this.waitingContextListeners.contains(listener)) {
            this.waitingContextListeners.add(listener);
        } else if (!this.contextListeners.contains(listener)) {
            this.contextListeners.add(listener);
        }
    }

    @Deprecated
    protected void checkForLandmarkDeltaAndNotify(float previousInterest, IInteractionElement node, IInteractionContext context) {
        this.checkForLandmarkDeltaAndNotify(previousInterest, node, context, false);
    }

    protected void checkForLandmarkDeltaAndNotify(float previousInterest, final IInteractionElement node, final IInteractionContext context, final boolean isExplicitManipulation) {
        block2: {
            block3: {
                AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                if (!bridge.canBeLandmark(node.getHandleIdentifier())) break block2;
                if (!(previousInterest >= ContextCore.getCommonContextScaling().getLandmark()) || node.getInterest().isLandmark()) break block3;
                for (final IContextListener listener : this.contextListeners) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable e) {
                            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                        }

                        public void run() throws Exception {
                            ArrayList<IInteractionElement> changed = new ArrayList<IInteractionElement>(1);
                            changed.add(node);
                            ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.LANDMARKS_REMOVED, context.getHandleIdentifier(), context, changed, isExplicitManipulation);
                            listener.contextChanged(event);
                        }
                    });
                }
                break block2;
            }
            if (!(previousInterest < ContextCore.getCommonContextScaling().getLandmark()) || !node.getInterest().isLandmark()) break block2;
            for (final IContextListener listener : this.contextListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                    }

                    public void run() throws Exception {
                        ArrayList<IInteractionElement> changed = new ArrayList<IInteractionElement>(1);
                        changed.add(node);
                        ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.LANDMARKS_ADDED, context.getHandleIdentifier(), context, changed, isExplicitManipulation);
                        listener.contextChanged(event);
                    }
                });
            }
        }
    }

    public InteractionContext collapseActivityMetaContext(InteractionContext context) {
        HashMap<String, List<InteractionEvent>> attention = new HashMap<String, List<InteractionEvent>>();
        InteractionContext tempContext = new InteractionContext(CONTEXT_HISTORY_FILE_NAME, ContextCore.getCommonContextScaling());
        for (InteractionEvent event : context.getInteractionHistory()) {
            if (event.getKind().equals((Object)InteractionEvent.Kind.ATTENTION) && event.getDelta().equals(ACTIVITY_DELTA_ADDED)) {
                if (event.getStructureHandle() == null || event.getStructureHandle().equals("")) continue;
                ArrayList<InteractionEvent> interactionEvents = (ArrayList<InteractionEvent>)attention.get(event.getStructureHandle());
                if (interactionEvents == null) {
                    interactionEvents = new ArrayList<InteractionEvent>();
                    attention.put(event.getStructureHandle(), interactionEvents);
                }
                interactionEvents.add(event);
                continue;
            }
            if (!attention.isEmpty()) {
                this.addAttentionEvents(attention, tempContext);
                attention.clear();
            }
            tempContext.parseEvent(event);
        }
        if (!attention.isEmpty()) {
            this.addAttentionEvents(attention, tempContext);
        }
        return tempContext;
    }

    public List<InteractionEvent> collapseEventsByHour(List<InteractionEvent> eventsToCollapse) {
        ArrayList<InteractionEvent> collapsedEvents = new ArrayList<InteractionEvent>();
        Iterator<InteractionEvent> itr = eventsToCollapse.iterator();
        InteractionEvent firstEvent = itr.next();
        long total = 0L;
        Calendar t0 = Calendar.getInstance();
        Calendar t1 = Calendar.getInstance();
        while (itr.hasNext()) {
            InteractionEvent aggregateEvent;
            Date newEndDate;
            t0.setTime(firstEvent.getDate());
            t0.set(12, 0);
            t0.set(13, 0);
            t0.set(14, 0);
            t1.setTime(firstEvent.getDate());
            t1.set(12, t1.getMaximum(12));
            t1.set(13, t1.getMaximum(13));
            t1.set(14, t1.getMaximum(14));
            InteractionEvent nextEvent = itr.next();
            if (t0.getTime().compareTo(nextEvent.getDate()) <= 0 && t1.getTime().compareTo(nextEvent.getDate()) >= 0) {
                if (total == 0L) {
                    total += firstEvent.getEndDate().getTime() - firstEvent.getDate().getTime();
                }
                if (itr.hasNext() || (total += nextEvent.getEndDate().getTime() - nextEvent.getDate().getTime()) == 0L) continue;
                newEndDate = new Date(firstEvent.getDate().getTime() + total);
                aggregateEvent = new InteractionEvent(firstEvent.getKind(), firstEvent.getStructureKind(), firstEvent.getStructureHandle(), firstEvent.getOriginId(), firstEvent.getNavigation(), firstEvent.getDelta(), 1.0f, firstEvent.getDate(), newEndDate);
                collapsedEvents.add(aggregateEvent);
                total = 0L;
                continue;
            }
            if (total != 0L) {
                newEndDate = new Date(firstEvent.getDate().getTime() + total);
                aggregateEvent = new InteractionEvent(firstEvent.getKind(), firstEvent.getStructureKind(), firstEvent.getStructureHandle(), firstEvent.getOriginId(), firstEvent.getNavigation(), firstEvent.getDelta(), 1.0f, firstEvent.getDate(), newEndDate);
                collapsedEvents.add(aggregateEvent);
                total = 0L;
            } else {
                collapsedEvents.add(firstEvent);
                if (!itr.hasNext()) {
                    collapsedEvents.add(nextEvent);
                }
            }
            firstEvent = nextEvent;
        }
        return collapsedEvents;
    }

    public void deactivateAllContexts() {
        HashSet<String> handles = new HashSet<String>(this.activeContext.getContextMap().keySet());
        for (String handleIdentifier : handles) {
            this.deactivateContext(handleIdentifier);
        }
    }

    public void saveContext(IInteractionContext context) {
        if (context != null && this.contextStore != null) {
            this.contextStore.saveContext(context);
        }
    }

    @Override
    public InputStream getAdditionalContextData(IInteractionContext context, String contributorIdentifier) {
        try {
            return this.contextStore.getAdditionalContextInformation(context, contributorIdentifier);
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Searching for additional context data failed", (Throwable)e));
            return null;
        }
    }

    @Override
    public void deactivateContext(String handleIdentifier) {
        try {
            System.setProperty(PROPERTY_CONTEXT_ACTIVE, Boolean.FALSE.toString());
            final IInteractionContext context = this.activeContext.getContextMap().get(handleIdentifier);
            if (context != null) {
                this.saveContext(context);
                this.activeContext.getContextMap().remove(handleIdentifier);
                this.setContextCapturePaused(true);
                for (final IContextListener listener : this.contextListeners) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable e) {
                            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                        }

                        public void run() throws Exception {
                            ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.DEACTIVATED, context.getHandleIdentifier(), context, null);
                            listener.contextChanged(event);
                        }
                    });
                }
                this.setContextCapturePaused(false);
            }
            if (!this.activationHistorySuppressed) {
                this.processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.COMMAND, ACTIVITY_STRUCTUREKIND_ACTIVATION, handleIdentifier, ACTIVITY_ORIGINID_WORKBENCH, null, ACTIVITY_DELTA_DEACTIVATED, 1.0f));
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Could not deactivate context", t));
        }
    }

    @Override
    @Deprecated
    public void deleteElement(IInteractionElement element) {
        this.deleteElements(Arrays.asList(element), this.getActiveContext(), false, true);
    }

    @Override
    public void deleteElements(Collection<IInteractionElement> elements) {
        this.deleteElements(elements, this.getActiveContext(), false, true);
    }

    @Override
    public void deleteElements(Collection<IInteractionElement> elements, IInteractionContext context) {
        this.deleteElements(elements, context, false, true);
    }

    public void deleteElements(Collection<IInteractionElement> elements, boolean isExplicitManipulation) {
        this.deleteElements(elements, this.getActiveContext(), isExplicitManipulation, true);
    }

    public void deleteElements(Collection<IInteractionElement> elements, IInteractionContext context, boolean isExplicitManipulation, boolean notify) {
        Assert.isNotNull(elements);
        if (elements.size() == 0 || context == null) {
            return;
        }
        context.delete(elements);
        if (notify) {
            this.notifyElementsDeleted(context, new ArrayList<IInteractionElement>(elements), isExplicitManipulation);
        }
    }

    @Override
    public void deleteContext(final String handleIdentifier) {
        final IInteractionContext context = this.activeContext.getContextMap().get(handleIdentifier);
        this.setContextCapturePaused(true);
        this.eraseContext(handleIdentifier);
        this.contextStore.deleteContext(handleIdentifier);
        for (final IContextListener listener : this.contextListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.CLEARED, handleIdentifier, context, null);
                    listener.contextChanged(event);
                }
            });
        }
        this.setContextCapturePaused(false);
    }

    private float ensureIsInteresting(IInteractionContext interactionContext, String contentType, String handle, IInteractionElement previous, float previousInterest) {
        float decayOffset = 0.0f;
        if (previousInterest < 0.0f) {
            decayOffset = -1.0f * previous.getInterest().getValue();
            this.addInteractionEvent(interactionContext, new InteractionEvent(InteractionEvent.Kind.MANIPULATION, contentType, handle, SOURCE_ID_DECAY_CORRECTION, decayOffset));
        }
        return decayOffset;
    }

    private void eraseContext(String handleIdentifier) {
        InteractionContext context = this.activeContext.getContextMap().get(handleIdentifier);
        if (context == null) {
            return;
        }
        this.activeContext.getContextMap().remove(context);
        context.reset();
    }

    @Override
    public IInteractionContext getActiveContext() {
        return this.activeContext;
    }

    public Collection<InteractionContext> getActiveContexts() {
        return Collections.unmodifiableCollection(this.activeContext.getContextMap().values());
    }

    @Override
    public IInteractionElement getActiveElement() {
        if (this.activeContext != null) {
            return this.activeContext.getActiveNode();
        }
        return null;
    }

    @Override
    public Set<IInteractionElement> getActiveLandmarks() {
        List<IInteractionElement> allLandmarks = this.activeContext.getLandmarks();
        HashSet<IInteractionElement> acceptedLandmarks = new HashSet<IInteractionElement>();
        for (IInteractionElement node : allLandmarks) {
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge(node.getContentType());
            if (!bridge.canBeLandmark(node.getHandleIdentifier())) continue;
            acceptedLandmarks.add(node);
        }
        return acceptedLandmarks;
    }

    public InteractionContext getActivityMetaContext() {
        try {
            metaContextLock.acquire();
            if (this.activityMetaContext == null) {
                this.loadActivityMetaContext();
            }
        }
        finally {
            metaContextLock.release();
        }
        return this.activityMetaContext;
    }

    @Deprecated
    public String getDominantContextHandleForElement(IInteractionElement node) {
        IInteractionElement dominantNode = null;
        if (node instanceof CompositeContextElement) {
            CompositeContextElement compositeNode = (CompositeContextElement)node;
            if (compositeNode.getNodes().isEmpty()) {
                return null;
            }
            dominantNode = (IInteractionElement)compositeNode.getNodes().toArray()[0];
            for (IInteractionElement iInteractionElement : compositeNode.getNodes()) {
                if (dominantNode == null || !(dominantNode.getInterest().getValue() < iInteractionElement.getInterest().getValue())) continue;
                dominantNode = iInteractionElement;
            }
        } else if (node instanceof InteractionContextElement) {
            dominantNode = node;
        }
        if (dominantNode != null) {
            return ((InteractionContextElement)dominantNode).getContext().getHandleIdentifier();
        }
        return null;
    }

    @Override
    public IInteractionElement getElement(String elementHandle) {
        if (this.activeContext != null && elementHandle != null) {
            return this.activeContext.get(elementHandle);
        }
        return null;
    }

    public Collection<IInteractionContext> getGlobalContexts() {
        return this.globalContexts;
    }

    public Collection<IInteractionElement> getActiveDocuments() {
        return this.getActiveDocuments(this.activeContext);
    }

    @Override
    public Set<IInteractionElement> getActiveDocuments(IInteractionContext context) {
        HashSet<IInteractionElement> set = new HashSet<IInteractionElement>();
        if (context == null) {
            return set;
        }
        List<IInteractionElement> allIntersting = context.getInteresting();
        for (IInteractionElement node : allIntersting) {
            if (!ContextCore.getStructureBridge(node.getContentType()).isDocument(node.getHandleIdentifier())) continue;
            set.add(node);
        }
        return set;
    }

    public List<IContextListener> getListeners() {
        return Collections.unmodifiableList(this.contextListeners);
    }

    @Override
    public boolean hasContext(String handleIdentifier) {
        if (handleIdentifier == null) {
            return false;
        }
        if (this.getActiveContext() != null && handleIdentifier.equals(this.getActiveContext().getHandleIdentifier())) {
            return !this.getActiveContext().getAllElements().isEmpty();
        }
        return this.contextStore.hasContext(handleIdentifier);
    }

    public void internalActivateContext(final IInteractionContext context) {
        Assert.isTrue((boolean)(context instanceof InteractionContext), (String)"Must provide a concrete InteractionContext");
        System.setProperty(PROPERTY_CONTEXT_ACTIVE, Boolean.TRUE.toString());
        this.activeContext.getContextMap().put(context.getHandleIdentifier(), (InteractionContext)context);
        if (!this.activationHistorySuppressed) {
            this.processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.COMMAND, ACTIVITY_STRUCTUREKIND_ACTIVATION, context.getHandleIdentifier(), ACTIVITY_ORIGINID_WORKBENCH, null, ACTIVITY_DELTA_ACTIVATED, 1.0f));
        }
        for (final IContextListener listener : this.contextListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.ACTIVATED, context.getHandleIdentifier(), context, null);
                    listener.contextChanged(event);
                }
            });
        }
    }

    @Deprecated
    public List<IInteractionElement> internalProcessInteractionEvent(InteractionEvent event, IInteractionContext interactionContext, boolean propagateToParents) {
        return this.internalProcessInteractionEvent(event, interactionContext, propagateToParents, false);
    }

    public List<IInteractionElement> internalProcessInteractionEvent(InteractionEvent event, IInteractionContext interactionContext, boolean propagateToParents, boolean isExplicitManipulation) {
        if (this.contextCapturePaused || InteractionEvent.Kind.COMMAND.equals((Object)event.getKind()) || this.suppressListenerNotification) {
            return Collections.emptyList();
        }
        IInteractionElement previous = interactionContext.get(event.getStructureHandle());
        float previousInterest = 0.0f;
        boolean previouslyPredicted = false;
        boolean previouslyPropagated = false;
        float decayOffset = 0.0f;
        if (previous != null) {
            previousInterest = previous.getInterest().getValue();
            previouslyPredicted = previous.getInterest().isPredicted();
            previouslyPropagated = previous.getInterest().isPropagated();
        }
        if (event.getKind().isUserEvent()) {
            decayOffset = this.ensureIsInteresting(interactionContext, event.getStructureKind(), event.getStructureHandle(), previous, previousInterest);
        }
        IInteractionElement element = this.addInteractionEvent(interactionContext, event);
        ArrayList<IInteractionElement> interestDelta = new ArrayList<IInteractionElement>();
        if (propagateToParents && !event.getKind().equals((Object)InteractionEvent.Kind.MANIPULATION)) {
            HashSet<String> handles = new HashSet<String>();
            handles.add(element.getHandleIdentifier());
            this.propegateInterestToParents(interactionContext, event.getKind(), element, previousInterest, decayOffset, 1, interestDelta, event.getOriginId(), null, handles, isExplicitManipulation);
        }
        if (event.getKind().isUserEvent() && interactionContext instanceof CompositeInteractionContext) {
            ((CompositeInteractionContext)interactionContext).setActiveElement(element);
        }
        if (this.isInterestDelta(previousInterest, previouslyPredicted, previouslyPropagated, element)) {
            interestDelta.add(element);
        }
        this.checkForLandmarkDeltaAndNotify(previousInterest, element, interactionContext, isExplicitManipulation);
        return interestDelta;
    }

    public boolean isActivationHistorySuppressed() {
        return this.activationHistorySuppressed;
    }

    @Override
    public boolean isContextActive() {
        return !this.contextCapturePaused && this.activeContext.getContextMap().values().size() > 0;
    }

    @Override
    @Deprecated
    public boolean isContextActivePropertySet() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_CONTEXT_ACTIVE));
    }

    @Override
    public boolean isContextCapturePaused() {
        return this.contextCapturePaused;
    }

    protected boolean isInterestDelta(float previousInterest, boolean previouslyPredicted, boolean previouslyPropagated, IInteractionElement node) {
        float currentInterest = node.getInterest().getValue();
        if (previousInterest <= 0.0f && currentInterest > 0.0f) {
            return true;
        }
        if (previousInterest > 0.0f && currentInterest <= 0.0f) {
            return true;
        }
        if (currentInterest > 0.0f && previouslyPredicted && !node.getInterest().isPredicted()) {
            return true;
        }
        return currentInterest > 0.0f && previouslyPropagated && !node.getInterest().isPropagated();
    }

    public void loadActivityMetaContext() {
        if (this.contextStore != null) {
            for (final IContextListener listener : this.activityMetaContextListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                    }

                    public void run() throws Exception {
                        ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.PRE_ACTIVATED, InteractionContextManager.CONTEXT_HISTORY_FILE_NAME, null, null);
                        listener.contextChanged(event);
                    }
                });
            }
            try {
                File contextHistory;
                metaContextLock.acquire();
                this.activityMetaContext = (InteractionContext)this.contextStore.loadContext(CONTEXT_HISTORY_FILE_NAME);
                if ((this.activityMetaContext == null || this.activityMetaContext.getInteractionHistory().isEmpty()) && this.restoreSnapshot(contextHistory = this.contextStore.getFileForContext(CONTEXT_HISTORY_FILE_NAME))) {
                    this.activityMetaContext = (InteractionContext)this.contextStore.loadContext(CONTEXT_HISTORY_FILE_NAME);
                }
                if (this.activityMetaContext == null) {
                    this.resetActivityMetaContext();
                } else if (!ContextCorePlugin.getDefault().getPluginPreferences().getBoolean(PREFERENCE_ATTENTION_MIGRATED)) {
                    this.activityMetaContext = this.migrateLegacyActivity(this.activityMetaContext);
                    this.saveActivityMetaContext();
                    ContextCorePlugin.getDefault().getPluginPreferences().setValue(PREFERENCE_ATTENTION_MIGRATED, true);
                    ContextCorePlugin.getDefault().savePluginPreferences();
                }
            }
            finally {
                metaContextLock.release();
            }
            for (final IContextListener listener : this.activityMetaContextListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                    }

                    public void run() throws Exception {
                        ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.ACTIVATED, InteractionContextManager.this.activityMetaContext.getHandleIdentifier(), InteractionContextManager.this.activityMetaContext, null);
                        listener.contextChanged(event);
                    }
                });
            }
        } else {
            this.resetActivityMetaContext();
            StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.context.core", "No context store installed, not restoring activity context."));
        }
    }

    public void saveActivityMetaContext() {
        if (this.contextStore == null) {
            return;
        }
        boolean wasPaused = this.contextCapturePaused;
        try {
            try {
                metaContextLock.acquire();
                if (!wasPaused) {
                    this.setContextCapturePaused(true);
                }
                InteractionContext context = this.getActivityMetaContext();
                this.takeSnapshot(this.contextStore.getFileForContext(CONTEXT_HISTORY_FILE_NAME));
                this.contextStore.saveContext(this.collapseActivityMetaContext(context), CONTEXT_HISTORY_FILE_NAME);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Could not save activity history", t));
                metaContextLock.release();
                if (!wasPaused) {
                    this.setContextCapturePaused(false);
                }
            }
        }
        finally {
            metaContextLock.release();
            if (!wasPaused) {
                this.setContextCapturePaused(false);
            }
        }
    }

    protected boolean takeSnapshot(File file) {
        if (file.length() > 0L) {
            File originalFile = file.getAbsoluteFile();
            File backup = new File(file.getParentFile(), "." + file.getName());
            backup.delete();
            return originalFile.renameTo(backup);
        }
        return false;
    }

    protected boolean restoreSnapshot(File file) {
        File backup = new File(file.getParentFile(), "." + file.getName());
        File originalFile = file.getAbsoluteFile();
        if (originalFile.exists()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
            File failed = new File(file.getParentFile(), "failed-" + format.format(new Date()) + "-" + originalFile.getName());
            originalFile.renameTo(failed);
        }
        if (backup.exists()) {
            return backup.renameTo(originalFile);
        }
        return false;
    }

    @Deprecated
    public boolean manipulateInterestForElement(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId) {
        return this.manipulateInterestForElement(element, increment, forceLandmark, preserveUninteresting, sourceId, false);
    }

    public boolean manipulateInterestForElement(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId, boolean isExplicitManipulation) {
        if (!this.isContextActive()) {
            return false;
        }
        return this.manipulateInterestForElement(element, increment, forceLandmark, preserveUninteresting, sourceId, this.activeContext, isExplicitManipulation);
    }

    @Deprecated
    public boolean manipulateInterestForElement(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId, IInteractionContext context) {
        return this.manipulateInterestForElement(element, increment, forceLandmark, preserveUninteresting, sourceId, context, false);
    }

    public boolean manipulateInterestForElements(List<IInteractionElement> elements, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId, IInteractionContext context, boolean isExplicitManipulation) {
        HashSet<IInteractionElement> changedElements = new HashSet<IInteractionElement>();
        boolean manipulated = false;
        for (IInteractionElement element : elements) {
            manipulated |= this.manipulateInterestForElementHelper(element, increment, forceLandmark, preserveUninteresting, sourceId, context, changedElements, null, isExplicitManipulation);
        }
        if (manipulated) {
            if (preserveUninteresting || increment) {
                this.notifyInterestDelta(new ArrayList<IInteractionElement>(changedElements));
            } else {
                this.notifyElementsDeleted(context, new ArrayList<IInteractionElement>(changedElements), isExplicitManipulation);
            }
        }
        return manipulated;
    }

    public boolean manipulateInterestForElement(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId, IInteractionContext context, boolean isExplicitManipulation) {
        HashSet<IInteractionElement> changedElements = new HashSet<IInteractionElement>();
        boolean manipulated = this.manipulateInterestForElementHelper(element, increment, forceLandmark, preserveUninteresting, sourceId, context, changedElements, null, isExplicitManipulation);
        if (manipulated) {
            if (preserveUninteresting || increment) {
                this.notifyInterestDelta(new ArrayList<IInteractionElement>(changedElements));
            } else {
                this.notifyElementsDeleted(context, new ArrayList<IInteractionElement>(changedElements), isExplicitManipulation);
            }
        }
        return manipulated;
    }

    private boolean manipulateInterestForElementHelper(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId, IInteractionContext context, Set<IInteractionElement> changedElements, AbstractContextStructureBridge forcedBridge, boolean isExplicitManipulation) {
        Object parentBridgeHandle;
        AbstractContextStructureBridge parentBridge;
        if (element == null || context == null) {
            return false;
        }
        float originalValue = element.getInterest().getValue();
        float changeValue = 0.0f;
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge(element.getContentType());
        Object objectForHandle = bridge.getObjectForHandle(element.getHandleIdentifier());
        String parentContentType = bridge.getParentContentType();
        if (parentContentType != null && objectForHandle != null && (parentBridge = ContextCorePlugin.getDefault().getStructureBridge(parentContentType)) != null && parentBridge != forcedBridge && (parentBridgeHandle = parentBridge.getHandleIdentifier(objectForHandle)) != null) {
            IInteractionElement parentBridgeElement = context.get((String)parentBridgeHandle);
            this.manipulateInterestForElementHelper(parentBridgeElement, increment, forceLandmark, preserveUninteresting, sourceId, context, changedElements, parentBridge, isExplicitManipulation);
        }
        if (forcedBridge != null) {
            bridge = forcedBridge;
        }
        if (!increment) {
            if (element.getInterest().isLandmark() && bridge.canBeLandmark(element.getHandleIdentifier())) {
                changeValue = -1.0f * originalValue + 1.0f;
            } else {
                if (originalValue >= 0.0f) {
                    changeValue = -1.0f * originalValue - 1.0f;
                }
                for (String childHandle : bridge.getChildHandles(element.getHandleIdentifier())) {
                    IInteractionElement childElement = context.get(childHandle);
                    if (childElement == null || !this.isAPartOfContext(childElement) || childElement.equals(element)) continue;
                    this.manipulateInterestForElementHelper(childElement, increment, forceLandmark, preserveUninteresting, sourceId, context, changedElements, forcedBridge, isExplicitManipulation);
                }
            }
        } else if (!forceLandmark && originalValue > context.getScaling().getLandmark()) {
            changeValue = 0.0f;
        } else if (bridge.canBeLandmark(element.getHandleIdentifier())) {
            changeValue = context.getScaling().getForcedLandmark() - originalValue + 1.0f;
        } else {
            return false;
        }
        if (increment || preserveUninteresting) {
            InteractionEvent interactionEvent = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, element.getContentType(), element.getHandleIdentifier(), sourceId, changeValue);
            List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(interactionEvent, context, true, isExplicitManipulation);
            changedElements.addAll(interestDelta);
        } else {
            changedElements.add(element);
            this.deleteElements(Arrays.asList(element), context, false, false);
        }
        return true;
    }

    private boolean isAPartOfContext(IInteractionElement childElement) {
        if (childElement instanceof CompositeContextElement) {
            CompositeContextElement element = (CompositeContextElement)childElement;
            return element.getNodes() != null && element.getNodes().size() > 0;
        }
        return true;
    }

    public InteractionContext migrateLegacyActivity(InteractionContext context) {
        LegacyActivityAdaptor adaptor = new LegacyActivityAdaptor();
        InteractionContext newMetaContext = new InteractionContext(context.getHandleIdentifier(), ContextCore.getCommonContextScaling());
        for (InteractionEvent event : context.getInteractionHistory()) {
            InteractionEvent temp = adaptor.parseInteractionEvent(event);
            if (temp == null) continue;
            newMetaContext.parseEvent(temp);
        }
        return newMetaContext;
    }

    private void notifyElementsDeleted(final IInteractionContext context, final List<IInteractionElement> interestDelta, final boolean isExplicitManipulation) {
        if (!interestDelta.isEmpty()) {
            for (final IContextListener listener : this.contextListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                    }

                    public void run() throws Exception {
                        ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.ELEMENTS_DELETED, context.getHandleIdentifier(), context, interestDelta, isExplicitManipulation);
                        listener.contextChanged(event);
                    }
                });
            }
        }
    }

    @Deprecated
    public void notifyInterestDelta(List<IInteractionElement> interestDelta) {
        this.notifyInterestDelta(this.getActiveContext(), interestDelta);
    }

    public void notifyInterestDelta(final IInteractionContext context, final List<IInteractionElement> interestDelta) {
        if (!interestDelta.isEmpty()) {
            for (final IContextListener listener : this.contextListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                    }

                    public void run() throws Exception {
                        ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.INTEREST_CHANGED, context.getHandleIdentifier(), context, interestDelta);
                        listener.contextChanged(event);
                    }
                });
            }
        }
    }

    public void notifyRelationshipsChanged(final IInteractionElement element) {
        if (this.suppressListenerNotification) {
            return;
        }
        for (final IContextListener listener : this.contextListeners) {
            if (!(listener instanceof IRelationsListener)) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    ((IRelationsListener)((Object)listener)).relationsChanged(element);
                }
            });
        }
    }

    public void processActivityMetaContextEvent(InteractionEvent event) {
        IInteractionElement element = this.getActivityMetaContext().parseEvent(event);
        final List<IInteractionElement> changed = Collections.singletonList(element);
        for (final IContextListener listener : this.activityMetaContextListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.INTEREST_CHANGED, InteractionContextManager.this.getActivityMetaContext().getHandleIdentifier(), InteractionContextManager.this.getActivityMetaContext(), changed);
                    listener.contextChanged(event);
                }
            });
        }
    }

    @Override
    public IInteractionElement processInteractionEvent(InteractionEvent event) {
        return this.processInteractionEvent(event, true);
    }

    public IInteractionElement processInteractionEvent(InteractionEvent event, boolean propagateToParents) {
        return this.processInteractionEvent(event, propagateToParents, true);
    }

    public IInteractionElement processInteractionEvent(InteractionEvent event, boolean propagateToParents, boolean notifyListeners) {
        boolean alreadyNotified = false;
        if (this.isContextActive()) {
            List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(event, this.activeContext, propagateToParents);
            if (notifyListeners) {
                this.notifyInterestDelta(interestDelta);
            }
        }
        for (IInteractionContext globalContext : this.globalContexts) {
            if (!globalContext.getContentLimitedTo().equals(event.getStructureKind())) continue;
            List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(event, globalContext, propagateToParents);
            if (!notifyListeners || alreadyNotified) continue;
            this.notifyInterestDelta(interestDelta);
        }
        return this.activeContext.get(event.getStructureHandle());
    }

    public IInteractionElement processInteractionEvent(Object object, InteractionEvent.Kind eventKind, String origin, IInteractionContext context) {
        AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge(object);
        if (structureBridge != null) {
            String structureKind = structureBridge.getContentType();
            String handle = structureBridge.getHandleIdentifier(object);
            if (structureKind != null && handle != null) {
                InteractionEvent event = new InteractionEvent(eventKind, structureKind, handle, origin);
                List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(event, context, true);
                this.notifyInterestDelta(interestDelta);
                return context.get(event.getStructureHandle());
            }
        }
        return null;
    }

    public void processInteractionEvents(List<InteractionEvent> events, boolean propagateToParents) {
        HashSet<IInteractionElement> compositeDelta = new HashSet<IInteractionElement>();
        for (InteractionEvent event : events) {
            if (this.isContextActive()) {
                compositeDelta.addAll(this.internalProcessInteractionEvent(event, this.activeContext, propagateToParents));
            }
            for (IInteractionContext globalContext : this.globalContexts) {
                if (!globalContext.getContentLimitedTo().equals(event.getStructureKind())) continue;
                this.internalProcessInteractionEvent(event, globalContext, propagateToParents);
            }
        }
        this.notifyInterestDelta(new ArrayList<IInteractionElement>(compositeDelta));
    }

    private void propegateInterestToParents(IInteractionContext interactionContext, InteractionEvent.Kind kind, IInteractionElement node, float previousInterest, float decayOffset, int level, List<IInteractionElement> interestDelta, String origin, AbstractContextStructureBridge forcedBridge, Set<String> handles, boolean isExplicitManipulation) {
        String parentHandle;
        AbstractContextStructureBridge parentBridge;
        if (level > 17 || node == null || node.getHandleIdentifier() == null || node.getInterest().getValue() <= 0.0f) {
            return;
        }
        this.checkForLandmarkDeltaAndNotify(previousInterest, node, interactionContext, isExplicitManipulation);
        ++level;
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
        Object objectForHandle = bridge.getObjectForHandle(node.getHandleIdentifier());
        String parentBridgeContentType = bridge.getParentContentType();
        if (parentBridgeContentType != null && objectForHandle != null && (parentBridge = ContextCorePlugin.getDefault().getStructureBridge(parentBridgeContentType)) != null && parentBridge != forcedBridge && (parentHandle = parentBridge.getHandleIdentifier(objectForHandle)) != null) {
            Object parentBridgeElement = interactionContext.get(parentHandle);
            float parentPreviousInterest = 0.0f;
            float parentDecayOffset = 0.0f;
            if (parentBridgeElement != null) {
                parentPreviousInterest = parentBridgeElement.getInterest().getValue();
            }
            if (kind.isUserEvent()) {
                parentDecayOffset = this.ensureIsInteresting(interactionContext, parentBridge.getContentType(), parentHandle, (IInteractionElement)parentBridgeElement, parentPreviousInterest);
            }
            if (!handles.contains(parentHandle)) {
                handles.add(parentHandle);
                parentBridgeElement = this.addInteractionEvent(interactionContext, new InteractionEvent(InteractionEvent.Kind.PROPAGATION, parentBridge.getContentType(), parentHandle, origin));
            } else {
                parentBridgeElement = interactionContext.get(parentHandle);
            }
            this.propegateInterestToParents(interactionContext, kind, (IInteractionElement)parentBridgeElement, parentPreviousInterest, parentDecayOffset, level, interestDelta, origin, parentBridge, handles, isExplicitManipulation);
        }
        if (forcedBridge != null) {
            bridge = forcedBridge;
        }
        String parentHandle2 = bridge.getParentHandle(node.getHandleIdentifier(), forcedBridge == null);
        if (forcedBridge == null) {
            for (String contentType : ContextCore.getChildContentTypes(bridge.getContentType())) {
                AbstractContextStructureBridge canonicalBridge;
                AbstractContextStructureBridge childBridge = ContextCore.getStructureBridge(contentType);
                Object resolved = childBridge.getObjectForHandle(parentHandle2);
                if (resolved == null || (canonicalBridge = ContextCore.getStructureBridge(resolved)).getContentType().equals("resource")) continue;
                bridge = canonicalBridge;
                parentHandle2 = bridge.getHandleIdentifier(resolved);
                break;
            }
        }
        if (parentHandle2 != null) {
            String parentContentType = bridge.getContentType(parentHandle2);
            IInteractionElement parentElement = interactionContext.get(parentHandle2);
            float parentPreviousInterest = 0.0f;
            if (parentElement != null && parentElement.getInterest() != null) {
                parentPreviousInterest = parentElement.getInterest().getValue();
            }
            float increment = interactionContext.getScaling().getInteresting();
            if (parentPreviousInterest < node.getInterest().getValue()) {
                increment = node.getInterest().getValue() - parentPreviousInterest;
                InteractionEvent propagationEvent = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, parentContentType, parentHandle2, "org.eclipse.mylyn.core.model.interest.propagation", CONTAINMENT_PROPAGATION_ID, increment);
                if (!handles.contains(parentHandle2)) {
                    handles.add(parentHandle2);
                    parentElement = this.addInteractionEvent(interactionContext, propagationEvent);
                } else {
                    parentElement = interactionContext.get(parentHandle2);
                }
            }
            if (parentElement != null && kind.isUserEvent() && parentElement.getInterest().getValue() < ContextCore.getCommonContextScaling().getInteresting()) {
                float parentOffset = ContextCore.getCommonContextScaling().getInteresting() - parentElement.getInterest().getValue() + increment;
                if (!handles.contains(parentHandle2)) {
                    handles.add(parentHandle2);
                    this.addInteractionEvent(interactionContext, new InteractionEvent(InteractionEvent.Kind.MANIPULATION, parentElement.getContentType(), parentElement.getHandleIdentifier(), SOURCE_ID_DECAY_CORRECTION, parentOffset));
                } else {
                    parentElement = interactionContext.get(parentElement.getHandleIdentifier());
                }
            }
            if (parentElement != null && this.isInterestDelta(parentPreviousInterest, parentElement.getInterest().isPredicted(), parentElement.getInterest().isPropagated(), parentElement)) {
                interestDelta.add(0, parentElement);
            }
            this.propegateInterestToParents(interactionContext, kind, parentElement, parentPreviousInterest, decayOffset, level, interestDelta, origin, forcedBridge, handles, isExplicitManipulation);
        }
    }

    public void removeActivityMetaContextListener(AbstractContextListener listener) {
        this.activityMetaContextListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.waitingContextListeners.clear();
        this.contextListeners.clear();
    }

    public void removeErrorPredictedInterest(String handle, String kind, boolean notify) {
        if (this.activeContext.getContextMap().isEmpty()) {
            return;
        }
        if (handle == null) {
            return;
        }
        IInteractionElement element = this.activeContext.get(handle);
        if (element != null && element.getInterest().isInteresting() && this.errorElementHandles.contains(handle)) {
            InteractionEvent errorEvent = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, kind, handle, "org.eclipse.mylyn.core.model.interest.propagation", ((InteractionContextScaling)ContextCore.getCommonContextScaling()).getErrorInterest());
            this.processInteractionEvent(errorEvent, true);
            --this.numInterestingErrors;
            this.errorElementHandles.remove(handle);
            if (notify) {
                ArrayList<IInteractionElement> changed = new ArrayList<IInteractionElement>();
                changed.add(element);
                final ContextChangeEvent contextChangeEvent = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.INTEREST_CHANGED, handle, null, changed);
                for (final IContextListener listener : this.contextListeners) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable e) {
                            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                        }

                        public void run() throws Exception {
                            listener.contextChanged(contextChangeEvent);
                        }
                    });
                }
            }
        }
    }

    public void removeGlobalContext(IInteractionContext context) {
        this.globalContexts.remove(context);
    }

    @Override
    public void removeListener(AbstractContextListener listener) {
        this.removeListener((IContextListener)listener);
    }

    @Override
    public void removeListener(IContextListener listener) {
        this.waitingContextListeners.remove(listener);
        this.contextListeners.remove(listener);
    }

    public void resetActivityMetaContext() {
        try {
            metaContextLock.acquire();
            this.activityMetaContext = new InteractionContext(CONTEXT_HISTORY_FILE_NAME, ContextCore.getCommonContextScaling());
            this.saveActivityMetaContext();
        }
        finally {
            metaContextLock.release();
        }
    }

    public void resetLandmarkRelationshipsOfKind(String reltationKind) {
        for (IInteractionElement landmark : this.activeContext.getLandmarks()) {
            for (IInteractionRelation iInteractionRelation : landmark.getRelations()) {
                if (!iInteractionRelation.getRelationshipHandle().equals(reltationKind)) continue;
                landmark.clearRelations();
            }
        }
        for (final IContextListener listener : this.contextListeners) {
            if (!(listener instanceof IRelationsListener)) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    ((IRelationsListener)((Object)listener)).relationsChanged(null);
                }
            });
        }
    }

    public void setActivationHistorySuppressed(boolean activationHistorySuppressed) {
        this.activationHistorySuppressed = activationHistorySuppressed;
    }

    public void setActiveSearchEnabled(boolean enabled) {
        for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
            provider.setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContextCapturePaused(boolean paused) {
        InteractionContextManager interactionContextManager = this;
        synchronized (interactionContextManager) {
            this.contextCapturePaused = paused;
        }
    }

    @Override
    public void updateHandle(final IInteractionElement element, String newHandle) {
        if (element == null) {
            return;
        }
        final IInteractionContext context = this.getActiveContext();
        context.updateElementHandle(element, newHandle);
        final List<IInteractionElement> changed = Collections.singletonList(element);
        for (final IContextListener listener : this.contextListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.INTEREST_CHANGED, context.getHandleIdentifier(), context, changed);
                    listener.contextChanged(event);
                }
            });
        }
        if (element.getInterest().isLandmark()) {
            for (final IContextListener listener : this.contextListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                    }

                    public void run() throws Exception {
                        ArrayList<IInteractionElement> changed = new ArrayList<IInteractionElement>();
                        changed.add(element);
                        ContextChangeEvent event = new ContextChangeEvent(ContextChangeEvent.ContextChangeKind.LANDMARKS_ADDED, context.getHandleIdentifier(), context, changed);
                        listener.contextChanged(event);
                    }
                });
            }
        }
    }
}

